/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import lotus.domino.Database;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.local.DateTime;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Session;

public class DbDirectory
extends NotesBase
implements lotus.domino.DbDirectory {
    private transient Session session;

    private native int NgetFirstDatabase(int var1);

    private native int NgetNextDatabase();

    private native int NcreateDatabase(String var1, boolean var2);

    private native int NopenDatabase(String var1, boolean var2);

    private native int NopenDatabaseIfModified(String var1, DateTime var2);

    private static synchronized native int NopenMailDatabase(Session var0);

    private native int NopenDatabaseByReplicaID(String var1);

    DbDirectory() throws NotesException {
    }

    DbDirectory(Session session, int n) throws NotesException {
        super(n, 10);
        if (session == null) {
            throw new NotesException(4404, JavaString.getString("missing_session_object"));
        }
        this.session = session;
        session.AddObject(this);
    }

    DbDirectory(Session session, int n, String string) throws NotesException {
        super(n, 10);
        if (session == null) {
            throw new NotesException(4404, JavaString.getString("missing_session_object"));
        }
        this.session = session;
        session.AddObject(this);
    }

    void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.session.RemoveObject(this);
        this.InternalFinalize();
    }

    void InternalRecycle() throws NotesException {
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            this.session.RemoveObject(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public Database getFirstDatabase(int n) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NgetFirstDatabase(n));
            Object var4_4 = null;
            return database;
        }
    }

    public Database getNextDatabase() throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NgetNextDatabase());
            Object var3_3 = null;
            return database;
        }
    }

    public Database createDatabase(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.createDatabase(string, true);
            Object var4_4 = null;
            return database;
        }
    }

    public Database createDatabase(String string, boolean bl) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NcreateDatabase(string, bl));
            Object var5_5 = null;
            return database;
        }
    }

    public Database openDatabase(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.openDatabase(string, false);
            Object var4_4 = null;
            return database;
        }
    }

    public Database openDatabase(String string, boolean bl) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NopenDatabase(string, bl));
            Object var5_5 = null;
            return database;
        }
    }

    public Database openDatabaseIfModified(String string, lotus.domino.DateTime dateTime) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NopenDatabaseIfModified(string, (DateTime)dateTime));
            Object var5_5 = null;
            return database;
        }
    }

    public Database openMailDatabase() throws NotesException {
        return this.session.FindOrCreateDatabase(DbDirectory.NopenMailDatabase(this.session));
    }

    public Database openDatabaseByReplicaID(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            lotus.domino.local.Database database = this.session.FindOrCreateDatabase(this.NopenDatabaseByReplicaID(string));
            Object var4_4 = null;
            return database;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            String string = this.PropGetString(1240);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public lotus.domino.Session getParent() throws NotesException {
        return this.session;
    }
}

