/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.io.IOException;
import java.util.Vector;
import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.local.Agent;
import lotus.domino.local.AgentContext;
import lotus.domino.local.DateTime;
import lotus.domino.local.DebugDocumentCollection;
import lotus.domino.local.DocumentCollection;
import lotus.domino.local.NotesBase;

public class DebugAgentContext
extends AgentContext {
    private Session s;
    private static String srchItem = "JavaAgentDebugSearchMarker";
    private static String srchValue = "JavaAgentDebugSearchMark";
    private static String srchFormula = "@IsAvailable(" + srchItem + ")";
    private static String srchQuery = "FIELD " + srchItem + " contains " + srchValue;
    private Database CurrentDatabase;
    private lotus.domino.Agent CurrentAgent;
    private Document DocumentContext;
    private String EffectiveUserName;
    private int LastExitStatus;
    private lotus.domino.DateTime LastRun;
    private Document SavedData;
    private DebugDocumentCollection UnprocessedDocuments;

    protected DebugAgentContext(Session session, lotus.domino.AgentContext agentContext, Document document) throws NotesException, IOException, ClassNotFoundException {
        super((lotus.domino.local.Session)session, 1);
        this.CurrentDatabase = agentContext.getCurrentDatabase();
        document.appendItemValue("CurrentDatabase_FilePath", this.CurrentDatabase.getFilePath());
        Name name = session.createName(this.CurrentDatabase.getServer());
        document.appendItemValue("CurrentDatabase_Server", name.getAbbreviated());
        this.CurrentAgent = agentContext.getCurrentAgent();
        document.appendItemValue("CurrentAgent", this.CurrentAgent.getName());
        this.DocumentContext = agentContext.getDocumentContext();
        document.appendItemValue("DocumentContext", this.DocumentContext == null ? null : this.DocumentContext.getUniversalID());
        Name name2 = session.createName(agentContext.getEffectiveUserName());
        document.appendItemValue("EffectiveUserName", name2.getAbbreviated());
        document.appendItemValue("LastExitStatus", agentContext.getLastExitStatus());
        lotus.domino.DateTime dateTime = agentContext.getLastRun();
        if (dateTime != null) {
            document.appendItemValue("LastRun", dateTime);
        }
        this.SavedData = agentContext.getSavedData();
        if (this.SavedData == null) {
            document.appendItemValue("SavedData", null);
        } else if (((NotesBase)((Object)this.SavedData)).cpp_object != 0) {
            document.appendItemValue("SavedData", this.SavedData.getUniversalID());
        } else {
            document.appendItemValue("SavedData", null);
        }
        lotus.domino.DocumentCollection documentCollection = agentContext.getUnprocessedDocuments();
        Vector<String> vector = new Vector<String>(20, 10);
        int n = 1;
        while (n <= documentCollection.getCount()) {
            Document document2 = documentCollection.getNthDocument(n);
            vector.addElement(document2.getNoteID());
            ++n;
        }
        document.appendItemValue("SelectedDocs", vector);
    }

    protected DebugAgentContext(Session session, Document document) throws NotesException, IOException, ClassNotFoundException {
        super((lotus.domino.local.Session)session, 1);
        Base base;
        Object object;
        this.s = session;
        this.CurrentDatabase = session.getDatabase(document.getItemValueString("CurrentDatabase_Server"), document.getItemValueString("CurrentDatabase_FilePath"));
        if (!this.CurrentDatabase.isOpen()) {
            System.out.println("Error: AgentContext - CurrentDatabase is invalid");
            throw new NotesException(0, "AgentContext - CurrentDatabase is invalid");
        }
        this.CurrentAgent = null;
        String string = document.getItemValueString("CurrentAgent");
        try {
            object = this.CurrentDatabase.getAgents();
            int n = 0;
            while (n < ((Vector)object).size()) {
                base = (Agent)((Vector)object).elementAt(n);
                if (string.equals(((Agent)base).getName())) {
                    this.CurrentAgent = base;
                    break;
                }
                ++n;
            }
        }
        catch (NotesException notesException) {
            System.out.println("Error: AgentContext - CurrentAgent not found in CurrentDatabase");
            throw new NotesException(0, "AgentContext - CurrentAgent not found in CurrentDatabase");
        }
        if (this.CurrentAgent == null) {
            System.out.println("Error: AgentContext - CurrentAgent is invalid");
            throw new NotesException(0, "AgentContext - CurrentAgent is invalid");
        }
        object = document.getItemValueString("DocumentContext");
        if (object == null) {
            this.DocumentContext = null;
        } else {
            try {
                this.DocumentContext = this.CurrentDatabase.getDocumentByUNID((String)object);
            }
            catch (NotesException notesException) {
                System.out.println("Error: AgentContext - DocumentContext is invalid");
                throw notesException;
            }
        }
        String string2 = document.getItemValueString("EffectiveUserName");
        if (string2 == null) {
            System.out.println("Error: AgentContext - EffectiveUserName is invalid");
            throw new NotesException(0, "AgentContext - EffectiveUserName is invalid");
        }
        base = session.createName(string2);
        this.EffectiveUserName = base.getCanonical();
        this.LastExitStatus = document.getItemValueInteger("LastExitStatus");
        Vector vector = document.getItemValue("LastRun");
        this.LastRun = vector.isEmpty() ? null : (DateTime)vector.firstElement();
        String string3 = document.getItemValueString("SavedData");
        if (string3 == null) {
            this.SavedData = null;
        } else {
            try {
                this.SavedData = this.CurrentDatabase.getDocumentByUNID(string3);
            }
            catch (NotesException notesException) {
                System.out.println("Error: AgentContext - SavedData is invalid");
                throw notesException;
            }
        }
        DocumentCollection documentCollection = (DocumentCollection)this.CurrentDatabase.getAllDocuments();
        Document document2 = documentCollection.getFirstDocument();
        while (document2 != null) {
            documentCollection.deleteDocument(document2);
            document2 = documentCollection.getFirstDocument();
        }
        this.UnprocessedDocuments = new DebugDocumentCollection(documentCollection, documentCollection.GetCppObj(), this.CurrentDatabase, document);
        if (this.UnprocessedDocuments == null) {
            System.out.println("Error restoring AgentContext - UnprocessedDocuments");
            throw new NotesException(0, "Error restoring AgentContext - UnprocessedDocuments");
        }
    }

    public lotus.domino.Agent getCurrentAgent() throws NotesException {
        return this.CurrentAgent;
    }

    public Database getCurrentDatabase() throws NotesException {
        return this.CurrentDatabase;
    }

    public Document getDocumentContext() throws NotesException {
        return this.DocumentContext;
    }

    public String getEffectiveUserName() throws NotesException {
        return this.EffectiveUserName;
    }

    public int getLastExitStatus() throws NotesException {
        return this.LastExitStatus;
    }

    public lotus.domino.DateTime getLastRun() throws NotesException {
        return this.LastRun;
    }

    public Document getSavedData() throws NotesException {
        return this.SavedData;
    }

    public lotus.domino.DocumentCollection getUnprocessedDocuments() throws NotesException {
        return this.UnprocessedDocuments;
    }

    public String toString() {
        String string;
        try {
            string = this.getEffectiveUserName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public lotus.domino.DocumentCollection unprocessedFTSearch(String string, int n) throws NotesException {
        if (string == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchQuery + ") AND (" + string + ")";
        lotus.domino.DocumentCollection documentCollection = this.CurrentDatabase.FTSearch(string2, n);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public lotus.domino.DocumentCollection unprocessedFTSearch(String string, int n, int n2, int n3) throws NotesException {
        if (string == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchQuery + ") AND (" + string + ")";
        lotus.domino.DocumentCollection documentCollection = this.CurrentDatabase.FTSearch(string2, n, n2, n3);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public lotus.domino.DocumentCollection unprocessedSearch(String string, lotus.domino.DateTime dateTime, int n) throws NotesException {
        if (string == null || dateTime == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchFormula + ") & (" + string + ")";
        lotus.domino.DocumentCollection documentCollection = this.CurrentDatabase.search(string2, dateTime, n);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public void updateProcessedDoc(Document document) throws NotesException {
        this.UnprocessedDocuments.updateProcessedDoc(document);
    }
}

