/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.local.DateTime;
import lotus.domino.local.DocumentCollection;

public class DebugDocumentCollection
extends DocumentCollection {
    private lotus.domino.DocumentCollection dc;
    private Document docAgentContext;
    private int agentTarget;
    private static final int TARGET_NONE = 0;
    private static final int TARGET_ALL_DOCS = 1;
    private static final int TARGET_NEW_DOCS = 2;
    private static final int TARGET_NEW_OR_MODIFIED_DOCS = 3;
    private static final int TARGET_SELECTED_DOCS = 4;
    private static final int TARGET_ALL_DOCS_IN_VIEW = 5;
    private static final int TARGET_UNREAD_DOCS_IN_VIEW = 6;
    private static final int TARGET_PROMPT_USER = 7;
    private static final int TARGET_UI_SELECTABLE_OBJECT = 8;
    private Vector selectedDocs = new Vector(20, 10);
    private Vector processedDocs = new Vector(20, 10);
    private Vector processedDateTimes = new Vector(20, 10);

    protected DebugDocumentCollection(lotus.domino.DocumentCollection documentCollection, int n, Database database, Document document) throws NotesException {
        super((lotus.domino.local.Database)database, n);
        String string;
        this.dc = documentCollection;
        this.docAgentContext = document;
        Document document2 = null;
        lotus.domino.DocumentCollection documentCollection2 = null;
        int n2 = 0;
        this.selectedDocs = document.getItemValue("SelectedDocs");
        n2 = 0;
        document2 = null;
        while (n2 < this.selectedDocs.size()) {
            string = (String)this.selectedDocs.elementAt(n2);
            if (!string.equals("")) {
                document2 = database.getDocumentByID(string);
            }
            if (document2 != null) {
                ++n2;
                continue;
            }
            this.selectedDocs.removeElementAt(n2);
        }
        document.replaceItemValue("SelectedDocs", this.selectedDocs);
        document.save();
        this.processedDocs = document.getItemValue("ProcessedDocs");
        this.processedDateTimes = document.getItemValue("ProcessedDateTimes");
        n2 = 0;
        while (n2 < this.processedDocs.size()) {
            string = (String)this.processedDocs.elementAt(n2);
            document2 = database.getDocumentByID(string);
            if (document2 != null) {
                ++n2;
                continue;
            }
            this.processedDocs.removeElementAt(n2);
            this.processedDateTimes.removeElementAt(n2);
        }
        document.replaceItemValue("SelectedDocs", this.selectedDocs);
        document.save();
        string = document.getItemValueString("AgentSearchCriteria");
        String string2 = document.getItemValueString("AgentRunsOn");
        switch (string2.charAt(0)) {
            case '0': {
                this.agentTarget = 1;
                documentCollection2 = database.getAllDocuments();
                document2 = documentCollection2.getFirstDocument();
                while (document2 != null && documentCollection2.getDocument(document2) != null) {
                    this.dc.addDocument(document2);
                    document2 = documentCollection2.getNextDocument(document2);
                }
                if (string == null) break;
                this.dc.FTSearch(string, 0);
                return;
            }
            case '1': {
                this.agentTarget = 3;
                documentCollection2 = database.getAllDocuments();
                n2 = 0;
                while (n2 < this.processedDocs.size()) {
                    DateTime dateTime = this.processedDateTimes.isEmpty() ? null : (DateTime)this.processedDateTimes.elementAt(n2);
                    String string3 = (String)this.processedDocs.elementAt(n2);
                    document2 = database.getDocumentByID(string3);
                    if (document2 == null || dateTime.timeDifference(document2.getLastModified()) < 0) {
                        this.processedDocs.removeElementAt(n2);
                        this.processedDateTimes.removeElementAt(n2);
                        continue;
                    }
                    if (document2 != null && documentCollection2.getDocument(document2) != null) {
                        documentCollection2.deleteDocument(document2);
                    }
                    ++n2;
                }
                document.replaceItemValue("ProcessedDocs", this.processedDocs);
                while (document.hasItem("ProcessedDateTimes")) {
                    document.removeItem("ProcessedDateTimes");
                }
                document.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
                document.save();
                document2 = documentCollection2.getFirstDocument();
                while (document2 != null && documentCollection2.getDocument(document2) != null) {
                    this.dc.addDocument(document2);
                    document2 = documentCollection2.getNextDocument(document2);
                }
                if (string == null) break;
                this.dc.FTSearch(string, 0);
                return;
            }
            case '2': {
                this.agentTarget = 6;
                String string4 = document.getItemValueString("AgentRunsOnView");
                View view = database.getView(string4);
                document2 = view.getFirstDocument();
                while (document2 != null) {
                    String string5 = document2.getNoteID();
                    if (this.selectedDocs.contains(string5)) {
                        this.dc.addDocument(document2);
                    }
                    document2 = view.getNextDocument(document2);
                }
                if (string == null) break;
                this.dc.FTSearch(string, 0);
                return;
            }
            case '3': {
                this.agentTarget = 5;
                String string6 = document.getItemValueString("AgentRunsOnView");
                View view = database.getView(string6);
                document2 = view.getFirstDocument();
                while (document2 != null) {
                    this.dc.addDocument(document2);
                    document2 = view.getNextDocument(document2);
                }
                if (string == null) break;
                this.dc.FTSearch(string, 0);
                return;
            }
            case '4': {
                this.agentTarget = 4;
                n2 = 0;
                while (n2 < this.selectedDocs.size()) {
                    String string7 = (String)this.selectedDocs.elementAt(n2);
                    document2 = database.getDocumentByID(string7);
                    if (document2 != null) {
                        if (this.dc.getDocument(document2) == null) {
                            this.dc.addDocument(document2);
                        }
                        ++n2;
                        continue;
                    }
                    this.selectedDocs.removeElementAt(n2);
                }
                document.replaceItemValue("SelectedDocs", this.selectedDocs);
                document.save();
                if (string == null) break;
                this.dc.FTSearch(string, 0);
                return;
            }
            case '5': {
                this.agentTarget = 8;
                document2 = null;
                String string8 = document.getItemValueString("DocumentContext");
                try {
                    if (string8 != null && !string8.equals("")) {
                        document2 = database.getDocumentByUNID(string8);
                    }
                }
                catch (NotesException notesException) {
                    System.out.println("Error: AgentContext - DocumentContext is invalid");
                    throw notesException;
                }
                if (document2 == null || this.dc.getDocument(document2) != null) break;
                this.dc.addDocument(document2);
                return;
            }
            default: {
                System.out.println("Exception: Undefined AgentContext state");
                throw new NotesException(0, "Undefined AgentContext state");
            }
        }
    }

    public int getCount() throws NotesException {
        return this.dc.getCount();
    }

    public boolean isSorted() throws NotesException {
        return this.dc.isSorted();
    }

    public Database getParent() throws NotesException {
        return this.dc.getParent();
    }

    public String getQuery() throws NotesException {
        return this.dc.getQuery();
    }

    public String toString() {
        return this.dc.toString();
    }

    public void addDocument(Document document) throws NotesException {
        this.dc.addDocument(document);
    }

    public void addDocument(Document document, boolean bl) throws NotesException {
        this.dc.addDocument(document, bl);
    }

    public void deleteDocument(Document document) throws NotesException {
        this.dc.deleteDocument(document);
    }

    public void FTSearch(String string) throws NotesException {
        this.dc.FTSearch(string);
    }

    public void FTSearch(String string, int n) throws NotesException {
        this.dc.FTSearch(string, n);
    }

    public Document getDocument(Document document) throws NotesException {
        return this.dc.getDocument(document);
    }

    public Document getFirstDocument() throws NotesException {
        return this.dc.getFirstDocument();
    }

    public Document getLastDocument() throws NotesException {
        return this.dc.getLastDocument();
    }

    public Document getNextDocument() throws NotesException {
        return this.dc.getNextDocument();
    }

    public Document getNextDocument(Document document) throws NotesException {
        return this.dc.getNextDocument(document);
    }

    public Document getNthDocument(int n) throws NotesException {
        return this.dc.getNthDocument(n);
    }

    public Document getPrevDocument() throws NotesException {
        return this.dc.getPrevDocument();
    }

    public Document getPrevDocument(Document document) throws NotesException {
        return this.dc.getPrevDocument(document);
    }

    public void putAllInFolder(String string) throws NotesException {
        this.dc.putAllInFolder(string);
    }

    public void removeAll(boolean bl) throws NotesException {
        this.dc.removeAll(bl);
        switch (this.agentTarget) {
            case 3: {
                this.updateAll();
                return;
            }
            case 4: {
                this.selectedDocs.removeAllElements();
                int n = 1;
                while (n <= this.dc.getCount()) {
                    Document document = this.dc.getNthDocument(n);
                    String string = document.getNoteID();
                    this.selectedDocs.addElement(string);
                    ++n;
                }
                this.docAgentContext.replaceItemValue("SelectedDocs", this.processedDocs);
                this.docAgentContext.save();
                return;
            }
        }
    }

    public void removeAllFromFolder(String string) throws NotesException {
        this.dc.removeAllFromFolder(string);
    }

    public void stampAll(String string, Object object) throws NotesException {
        this.dc.stampAll(string, object);
    }

    public void updateAll() throws NotesException {
        if (this.agentTarget == 3) {
            this.processedDocs.removeAllElements();
            this.processedDateTimes.removeAllElements();
            Database database = this.dc.getParent();
            Session session = database.getParent();
            lotus.domino.DateTime dateTime = session.createDateTime("Today");
            dateTime.setNow();
            int n = 1;
            while (n <= this.dc.getCount()) {
                Document document = this.dc.getNthDocument(n);
                String string = document.getNoteID();
                this.processedDocs.addElement(string);
                this.processedDateTimes.addElement(dateTime);
                ++n;
            }
            this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
            while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
                this.docAgentContext.removeItem("ProcessedDateTimes");
            }
            this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
            this.docAgentContext.save();
        }
    }

    public void recycle() throws NotesException {
        this.dc.recycle();
    }

    void updateProcessedDoc(Document document) throws NotesException {
        if (document == null) {
            return;
        }
        if (this.agentTarget == 3) {
            String string = document.getNoteID();
            if (!this.processedDocs.contains(string)) {
                this.processedDocs.addElement(string);
                Database database = this.dc.getParent();
                Session session = database.getParent();
                lotus.domino.DateTime dateTime = session.createDateTime("Today");
                dateTime.setNow();
                this.processedDateTimes.addElement(dateTime);
            }
            this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
            while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
                this.docAgentContext.removeItem("ProcessedDateTimes");
            }
            this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
            this.docAgentContext.save();
        }
    }

    void unstampAll(String string) throws NotesException {
        if (string == null) {
            return;
        }
        Document document = this.dc.getFirstDocument();
        while (document != null) {
            document.removeItem(string);
            document.save();
            document = this.dc.getNextDocument(document);
        }
    }
}

