/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.util.Date;
import java.util.Vector;
import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.DbDirectory;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.International;
import lotus.domino.Log;
import lotus.domino.Name;
import lotus.domino.Newsletter;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Registration;
import lotus.domino.RichTextParagraphStyle;
import lotus.domino.RichTextStyle;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.local.AgentContext;
import lotus.domino.local.DebugAgentContext;

public class DebugSession
extends lotus.domino.local.Session {
    private static String dumpAgentContextFile = "AgentRunner.nsf";
    private lotus.domino.local.Session s;
    private String keySrv;
    private String keyDb;
    private String keyAgent;
    private Document doc;

    public DebugSession(AgentContext agentContext, String string) throws NotesException {
        super(1);
        this.dumpAgentContext((lotus.domino.local.Session)NotesFactory.createSession(), agentContext, string);
    }

    public DebugSession(String string, String string2, String string3) throws NotesException {
        super(1);
        this.s = (lotus.domino.local.Session)NotesFactory.createSession();
        this.keySrv = string;
        this.keyDb = string2;
        this.keyAgent = string3;
    }

    public DateRange createDateRange() throws NotesException {
        return this.s.createDateRange();
    }

    public DateRange createDateRange(DateTime dateTime, DateTime dateTime2) throws NotesException {
        return this.s.createDateRange(dateTime, dateTime2);
    }

    public DateRange createDateRange(Date date, Date date2) throws NotesException {
        return this.s.createDateRange(date, date2);
    }

    public DateTime createDateTime(Date date) throws NotesException {
        return this.s.createDateTime(date);
    }

    public DateTime createDateTime(String string) throws NotesException {
        return this.s.createDateTime(string);
    }

    public Log createLog(String string) throws NotesException {
        return this.s.createLog(string);
    }

    public Name createName(String string) throws NotesException {
        return this.s.createName(string);
    }

    public Name createName(String string, String string2) throws NotesException {
        return this.s.createName(string, string2);
    }

    public Newsletter createNewsletter(DocumentCollection documentCollection) throws NotesException {
        return this.s.createNewsletter(documentCollection);
    }

    public Registration createRegistration() throws NotesException {
        return this.s.createRegistration();
    }

    public RichTextStyle createRichTextStyle() throws NotesException {
        return this.s.createRichTextStyle();
    }

    public RichTextParagraphStyle createRichTextParagraphStyle() throws NotesException {
        return this.s.createRichTextParagraphStyle();
    }

    public Vector evaluate(String string) throws NotesException {
        return this.s.evaluate(string);
    }

    public Vector evaluate(String string, Document document) throws NotesException {
        return this.s.evaluate(string, document);
    }

    public Vector freeTimeSearch(DateRange dateRange, int n, Object object, boolean bl) throws NotesException {
        return this.s.freeTimeSearch(dateRange, n, object, bl);
    }

    public Vector getAddressBooks() throws NotesException {
        return this.s.getAddressBooks();
    }

    public lotus.domino.AgentContext getAgentContext() throws NotesException {
        DebugAgentContext debugAgentContext;
        try {
            Database database = this.s.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                System.out.println("AgentContext database not found");
                throw new NotesException(0, "AgentContext database not found");
            }
            View view = database.getView("($AgentContexts)");
            if (view == null) {
                System.out.println("AgentContext view not found");
                throw new NotesException(0, "AgentContext view not found");
            }
            Vector<String> vector = new Vector<String>(2, 0);
            vector.addElement(String.valueOf(this.keySrv == "" || this.keySrv == "\u0000" ? "Local" : this.keySrv) + "!!" + this.keyDb);
            vector.addElement(this.keyAgent);
            this.doc = view.getDocumentByKey(vector, true);
            if (this.doc == null) {
                System.out.println("AgentContext document not found");
                throw new NotesException(0, "AgentContext document not found");
            }
            debugAgentContext = new DebugAgentContext((Session)this.s, this.doc);
        }
        catch (Exception exception) {
            debugAgentContext = null;
            if (exception instanceof NotesException) {
                System.err.println("NotesException: " + ((NotesException)exception).text);
            }
            exception.printStackTrace();
        }
        return debugAgentContext;
    }

    public String getCommonUserName() throws NotesException {
        return this.s.getCommonUserName();
    }

    public Database getDatabase(String string, String string2) throws NotesException {
        return this.s.getDatabase(string, string2);
    }

    public Database getDatabase(String string, String string2, boolean bl) throws NotesException {
        return this.s.getDatabase(string, string2, bl);
    }

    public DbDirectory getDbDirectory(String string) throws NotesException {
        return this.s.getDbDirectory(string);
    }

    public String getEnvironmentString(String string) throws NotesException {
        return this.s.getEnvironmentString(string);
    }

    public String getEnvironmentString(String string, boolean bl) throws NotesException {
        return this.s.getEnvironmentString(string, bl);
    }

    public Object getEnvironmentValue(String string) throws NotesException {
        return this.s.getEnvironmentValue(string);
    }

    public Object getEnvironmentValue(String string, boolean bl) throws NotesException {
        return this.s.getEnvironmentValue(string, bl);
    }

    public void setEnvironmentVar(String string, Object object) throws NotesException {
        this.s.setEnvironmentVar(string, object);
    }

    public void setEnvironmentVar(String string, Object object, boolean bl) throws NotesException {
        this.s.setEnvironmentVar(string, object, bl);
    }

    public International getInternational() throws NotesException {
        return this.s.getInternational();
    }

    public String getNotesVersion() throws NotesException {
        return this.s.getNotesVersion();
    }

    public String getPlatform() throws NotesException {
        return this.s.getPlatform();
    }

    public String getServerName() throws NotesException {
        return this.s.getServerName();
    }

    public Database getURLDatabase() throws NotesException {
        return this.s.getURLDatabase();
    }

    public String getUserName() throws NotesException {
        return this.s.getUserName();
    }

    public Name getUserNameObject() throws NotesException {
        return this.s.getUserNameObject();
    }

    public boolean isOnServer() throws NotesException {
        return this.s.isOnServer();
    }

    public Base resolve(String string) throws NotesException {
        return this.s.resolve(string);
    }

    public Vector getUserNameList() throws NotesException {
        return this.s.getUserNameList();
    }

    public void recycle() throws NotesException {
        this.s.recycle();
    }

    public void stampAgentContextDoc() throws NotesException {
        try {
            DateTime dateTime = this.s.createDateTime("Today");
            dateTime.setNow();
            this.doc.removeItem("LastRun");
            this.doc.appendItemValue("LastRun", dateTime);
            this.doc.save();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void dumpAgentContext(lotus.domino.local.Session session, AgentContext agentContext, String string) throws NotesException {
        try {
            Database database = session.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                System.out.println("AgentContext database not found");
                throw new NotesException(0, "AgentContext database not found");
            }
            this.doc = database.createDocument();
            this.doc.appendItemValue("Form", "AgentContext");
            this.doc.appendItemValue("ClassName", string);
            new DebugAgentContext(session, agentContext, this.doc);
            this.doc.save();
            this.doc.computeWithForm(false, false);
            this.doc.save();
            String string2 = this.doc.getItemValueString("CurrentDatabase_Server");
            if (string2 == null) {
                string2 = "Local";
            }
            string2 = String.valueOf(this.doc.getItemValueString("CurrentDatabase_FilePath")) + " " + string2;
            string2 = String.valueOf(this.doc.getItemValueString("CurrentAgent")) + " " + string2;
            System.out.println("AgentContext dumped to file " + dumpAgentContextFile + " for agent:");
            System.out.println("\t" + string2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

