/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.local.Database;
import lotus.domino.local.Document;
import lotus.domino.local.NotesBase;

public class DocumentCollection
extends NotesBase
implements lotus.domino.DocumentCollection {
    private transient Database database;
    private transient Document currDoc;

    private native int NgetFirstDocument();

    private native int NgetLastDocument();

    private native int NgetNextDocument(Document var1);

    private native int NgetPrevDocument(Document var1);

    private native int NgetNthDocument(int var1);

    private native void NFTSearch(String var1, int var2);

    private native void NremoveAll(boolean var1);

    private native void NupdateAll();

    private native void NstampAll(String var1, Object var2);

    private native void NputAllInFolder(String var1, boolean var2);

    private native void NremoveAllFromFolder(String var1);

    private native int NgetDocument(Document var1);

    private native void NaddDocument(Document var1);

    private native void NdeleteDocument(Document var1);

    DocumentCollection() throws NotesException {
    }

    DocumentCollection(Database database, int n) throws NotesException {
        super(n, 11);
        if (database == null) {
            throw new NotesException(4405, JavaString.getString("missing_db_object"));
        }
        this.database = database;
        database.AddObject(this);
    }

    void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    void InternalRecycle() throws NotesException {
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            this.database.RemoveObject(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public lotus.domino.Document getFirstDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetFirstDocument());
            if (document != null) {
                this.currDoc = document;
            }
            Document document2 = document;
            Object var3_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getLastDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetLastDocument());
            if (document != null) {
                this.currDoc = document;
            }
            Document document2 = document;
            Object var3_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getNextDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            try {
                ((NotesBase)((Object)document)).CheckObject();
            }
            catch (NotesException notesException) {
                if (notesException.id == 4376) {
                    throw new NotesException(4466, JavaString.getString("arg_deleted"));
                }
                throw notesException;
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextDocument((Document)document));
            if (document2 != null) {
                this.currDoc = document2;
            }
            Document document3 = document2;
            Object var4_6 = null;
            return document3;
        }
    }

    public lotus.domino.Document getPrevDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            ((NotesBase)((Object)document)).CheckObject();
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevDocument((Document)document));
            if (document2 != null) {
                this.currDoc = document2;
            }
            Document document3 = document2;
            Object var4_5 = null;
            return document3;
        }
    }

    public lotus.domino.Document getNthDocument(int n) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetNthDocument(n));
            if (document != null) {
                this.currDoc = document;
            }
            Document document2 = document;
            Object var4_5 = null;
            return document2;
        }
    }

    public lotus.domino.Document getNextDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (this.currDoc == null) {
                lotus.domino.Document document = null;
                Object var3_4 = null;
                return document;
            }
            Document document = this.database.FindOrCreateDocument(this.NgetNextDocument(this.currDoc));
            if (document != null) {
                this.currDoc = document;
            }
            Document document2 = document;
            Object var3_5 = null;
            return document2;
        }
    }

    public lotus.domino.Document getPrevDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (this.currDoc == null) {
                lotus.domino.Document document = null;
                Object var3_4 = null;
                return document;
            }
            Document document = this.database.FindOrCreateDocument(this.NgetPrevDocument(this.currDoc));
            if (document != null) {
                this.currDoc = document;
            }
            Document document2 = document;
            Object var3_5 = null;
            return document2;
        }
    }

    public lotus.domino.Document getDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            try {
                ((NotesBase)((Object)document)).CheckObject();
            }
            catch (NotesException notesException) {
                if (notesException.id == 4376) {
                    throw new NotesException(4466, JavaString.getString("arg_deleted"));
                }
                throw notesException;
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetDocument((Document)document));
            if (document2 != null) {
                this.currDoc = document2;
            }
            Document document3 = document2;
            Object var4_6 = null;
            return document3;
        }
    }

    public void addDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            try {
                ((NotesBase)((Object)document)).CheckObject();
            }
            catch (NotesException notesException) {
                if (notesException.id == 4376) {
                    throw new NotesException(4466, JavaString.getString("arg_deleted"));
                }
                throw notesException;
            }
            this.NaddDocument((Document)document);
            return;
        }
    }

    public void addDocument(lotus.domino.Document document, boolean bl) throws NotesException {
        this.addDocument(document);
    }

    public void deleteDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            try {
                ((NotesBase)((Object)document)).CheckObject();
            }
            catch (NotesException notesException) {
                if (notesException.id == 4376) {
                    throw new NotesException(4466, JavaString.getString("arg_deleted"));
                }
                throw notesException;
            }
            this.NdeleteDocument((Document)document);
            return;
        }
    }

    public void FTSearch(String string) throws NotesException {
        this.FTSearch(string, 0);
    }

    public void FTSearch(String string, int n) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NFTSearch(string, n);
            this.currDoc = null;
            return;
        }
    }

    public void removeAll(boolean bl) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = (Document)this.getFirstDocument();
            while (document != null) {
                Document document2 = (Document)this.getNextDocument(document);
                document.finalize();
                document = document2;
            }
            this.NremoveAll(bl);
            this.currDoc = null;
            return;
        }
    }

    public void updateAll() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NupdateAll();
            return;
        }
    }

    public void stampAll(String string, Object object) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NstampAll(string, object);
            return;
        }
    }

    public void putAllInFolder(String string) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NputAllInFolder(string, true);
            return;
        }
    }

    public void putAllInFolder(String string, boolean bl) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NputAllInFolder(string, bl);
            return;
        }
    }

    public void removeAllFromFolder(String string) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NremoveAllFromFolder(string);
            return;
        }
    }

    public int getCount() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            int n = this.PropGetInt(1330);
            Object var3_3 = null;
            return n;
        }
    }

    public boolean isSorted() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            boolean bl = this.PropGetBool(1331);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getQuery() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            String string = this.PropGetString(1332);
            Object var3_3 = null;
            return string;
        }
    }

    public lotus.domino.Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }
}

