/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import lotus.domino.JavaString;
import lotus.domino.NotesEntityResolver;
import lotus.domino.NotesException;
import lotus.domino.Parser;
import lotus.domino.Processor;
import lotus.domino.XSLTResultTarget;
import lotus.domino.local.Database;
import lotus.domino.local.Document;
import lotus.domino.local.NotesBase;
import lotus.domino.local.RichTextItem;
import lotus.domino.local.Session;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EmbeddedObject
extends NotesBase
implements lotus.domino.EmbeddedObject {
    private transient Document parent;
    private File tempFile;
    private int objectId;

    private native int Nactivate(boolean var1);

    public native void NextractFile(String var1);

    public native void NdoVerb(String var1);

    public native void Nremove();

    EmbeddedObject() throws NotesException {
    }

    EmbeddedObject(Document document, int n) throws NotesException {
        super(n, 16);
        if (document == null) {
            throw new NotesException(4406, JavaString.getString("missing_document_object"));
        }
        this.parent = document;
        document.AddEmbedded(this);
        this.objectId = n;
        this.tempFile = null;
    }

    void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.parent.RemoveEmbedded(this);
        this.InternalFinalize();
    }

    void InternalRecycle() throws NotesException {
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            this.parent.RemoveEmbedded(this);
            this.InternalRecycle();
            this.cleanupTempFile();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public int activate(boolean bl) throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            int n = this.Nactivate(bl);
            Object var4_4 = null;
            return n;
        }
    }

    public void extractFile(String string) throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            this.NextractFile(string);
            return;
        }
    }

    public void doVerb(String string) throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            this.NdoVerb(string);
            return;
        }
    }

    public void remove() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            this.Nremove();
            this.parent.RemoveEmbedded(this);
            this.finalize();
            return;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            String string = this.PropGetString(1440);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getClassName() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            String string = this.PropGetString(1441);
            Object var3_3 = null;
            return string;
        }
    }

    public String getSource() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            String string = this.PropGetString(1442);
            Object var3_3 = null;
            return string;
        }
    }

    public int getType() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            int n = this.PropGetInt(1443);
            Object var3_3 = null;
            return n;
        }
    }

    public int getFileSize() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            int n = this.PropGetInt(1444);
            Object var3_3 = null;
            return n;
        }
    }

    public lotus.domino.RichTextItem getParent() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            int n = this.PropGetAdt(1445);
            RichTextItem richTextItem = (RichTextItem)this.parent.FindOrCreateItem(n);
            Object var3_4 = null;
            return richTextItem;
        }
    }

    public Vector getVerbs() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1446);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public int getObject() throws NotesException {
        this.CheckObject();
        EmbeddedObject embeddedObject = this;
        synchronized (embeddedObject) {
            int n = this.PropGetInt(1447);
            Object var3_3 = null;
            return n;
        }
    }

    private File getTempFile() {
        if (this.tempFile == null) {
            int n = this.objectId;
            Integer n2 = new Integer(n);
            String string = "eo" + n2.toString() + "tm";
            File file = new File(string);
            while (file.exists()) {
                n2 = new Integer(n++);
                string = "eo" + n2.toString() + "tm";
                file = new File(string);
            }
            this.tempFile = file;
        }
        return this.tempFile;
    }

    private void cleanupTempFile() {
        try {
            if (this.tempFile != null) {
                if (this.tempFile.exists()) {
                    this.tempFile.delete();
                }
                this.tempFile = null;
                return;
            }
        }
        catch (Exception exception) {}
    }

    public Reader getReader() throws NotesException {
        try {
            File file = this.getTempFile();
            if (!file.exists()) {
                this.extractFile(file.getAbsolutePath());
            }
            return new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public InputSource getInputSource() throws NotesException {
        return NotesEntityResolver.newEntityInputSource(this.getReader(), this.parent, this.toString());
    }

    public InputStream getInputStream() throws NotesException {
        try {
            File file = this.getTempFile();
            if (!file.exists()) {
                this.extractFile(file.getAbsolutePath());
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private Session getSession() throws NotesException {
        return (Session)((Database)this.parent.getParentDatabase()).getParent();
    }

    public org.w3c.dom.Document parseXML(boolean bl) throws IOException, SAXException, NotesException {
        Parser parser = new Parser(bl);
        return parser.parse(this.getSession(), this.getInputSource());
    }

    public void transformXML(Object object, XSLTResultTarget xSLTResultTarget) throws IOException, SAXException, NotesException {
        Processor processor = new Processor();
        processor.process(this.getSession(), this.getInputSource(), object, xSLTResultTarget);
    }
}

