/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.local.Database;
import lotus.domino.local.DateTime;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Session;

public class Replication
extends NotesBase
implements lotus.domino.Replication {
    private static final int NOERROR = 0;
    private transient Database database;

    private native int Nsave();

    private native int Nreset();

    private native int NclearHistory();

    Replication() throws NotesException {
    }

    Replication(Database database, int n) throws NotesException {
        super(n, 28);
        if (database == null) {
            throw new NotesException(4405, JavaString.getString("missing_db_object"));
        }
        this.database = database;
        database.AddObject(this);
    }

    public synchronized void finalize() throws NotesException {
        try {
            try {
                this.database.RemoveObject(this);
            }
            catch (NotesException notesException) {
                System.out.println(notesException);
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    void InternalRecycle() throws NotesException {
        super.Recycle();
    }

    public synchronized void recycle() throws NotesException {
        try {
            this.database.RemoveObject(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            System.out.println(notesException);
            return;
        }
    }

    public int reset() throws NotesException {
        int n = 0;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.Nreset();
        }
        return n;
    }

    public int save() throws NotesException {
        int n = 0;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.Nsave();
        }
        return n;
    }

    public int clearHistory() throws NotesException {
        int n = 4395;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.NclearHistory();
        }
        return n;
    }

    public long getCutoffInterval() throws NotesException {
        long l = 0L;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            l = this.PropGetInt(1533);
        }
        return l;
    }

    public lotus.domino.DateTime getCutoffDate() throws NotesException {
        DateTime dateTime = null;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            lotus.domino.Session session = this.database.getParent();
            if (session instanceof Session) {
                dateTime = ((Session)session).FindOrCreateDateTime(this.PropGetDate(1534));
            }
        }
        return dateTime;
    }

    public boolean isDisabled() throws NotesException {
        boolean bl = false;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            bl = this.PropGetBool(1535);
        }
        return bl;
    }

    public boolean isIgnoreDeletes() throws NotesException {
        boolean bl = false;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            bl = this.PropGetBool(1536);
        }
        return bl;
    }

    public boolean isCutoffDelete() throws NotesException {
        boolean bl = false;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            bl = this.PropGetBool(1539);
        }
        return bl;
    }

    public boolean isAbstract() throws NotesException {
        boolean bl = false;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            bl = this.PropGetBool(1541);
        }
        return bl;
    }

    public boolean isIgnoreDestDeletes() throws NotesException {
        boolean bl = false;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            bl = this.PropGetBool(1544);
        }
        return bl;
    }

    public int getPriority() throws NotesException {
        int n = 1565;
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            n = this.PropGetInt(1546);
        }
        return n;
    }

    public void setCutoffInterval(long l) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetInt(1533, (int)l);
            return;
        }
    }

    public void setDisabled(boolean bl) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetBool(1535, bl);
            return;
        }
    }

    public void setIgnoreDeletes(boolean bl) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetBool(1536, bl);
            return;
        }
    }

    public void setCutoffDelete(boolean bl) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetBool(1539, bl);
            return;
        }
    }

    public void setAbstract(boolean bl) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetBool(1541, bl);
            return;
        }
    }

    public void setIgnoreDestDeletes(boolean bl) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetBool(1544, bl);
            return;
        }
    }

    public void setPriority(int n) throws NotesException {
        this.CheckObject();
        Replication replication = this;
        synchronized (replication) {
            this.PropSetInt(1546, n);
            return;
        }
    }
}

