/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.AgentBase;
import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.JavaString;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.local.AgentContext;
import lotus.domino.local.DateRange;
import lotus.domino.local.DateTime;
import lotus.domino.local.DbDirectory;
import lotus.domino.local.Document;
import lotus.domino.local.DocumentCollection;
import lotus.domino.local.International;
import lotus.domino.local.Log;
import lotus.domino.local.Newsletter;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Registration;
import lotus.domino.local.RichTextParagraphStyle;
import lotus.domino.local.RichTextStyle;

public class Session
extends NotesBase
implements lotus.domino.Session {
    private transient Vector dblist;
    private transient Vector objlist;
    private transient AgentContext agentcontext;
    transient int context_cookie;
    transient boolean webuser;
    private static transient int counter;
    static Vector sessions;

    private static native int NCreateSession(int var0);

    private static native int NCreateWebSession(String var0, String var1);

    private static native int NCreateSessionWithToken(String var0);

    private static native int NCreateSessionWithPasswd(String var0);

    private native String NgetSessionToken(String var1);

    private native Vector NEvaluate(String var1, Document var2);

    private native String NgetEnvironmentString(String var1, boolean var2);

    private native Object NgetEnvironmentValue(String var1, boolean var2);

    private native void NsetEnvironmentVar(String var1, Object var2, boolean var3);

    private native int[] NfreeTimeSearch(DateRange var1, int var2, Object var3, boolean var4);

    private native int NgetDbDirectory(String var1);

    private native int NgetDatabase(String var1, String var2, boolean var3);

    private native int NcreateDateTime(String var1);

    private native int NcreateLog(String var1);

    private native int NcreateNewsletter(DocumentCollection var1);

    private native int NcreateDateRange();

    private native int NcreateName(String var1, String var2);

    private native int NgetURLDatabase();

    private native int NcreateRegistration();

    private native int NcreateRTStyle();

    private native int NcreateRTPStyle();

    private native int NcreateOutline(lotus.domino.local.Database var1);

    private native String NGetNotesUrl();

    private native int Nresolve(String var1);

    private native int NgetBEDatabase(int var1);

    public static Session createSession() throws NotesException {
        try {
            Session session = (Session)AgentBase.getAgentSession();
            if (session != null) {
                return session;
            }
            int n = Session.NCreateSession(0);
            return Session.FindOrCreateSession(n, 0);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Session createSession(int n) throws NotesException {
        try {
            Session session = (Session)AgentBase.getAgentSession();
            if (session != null) {
                return session;
            }
            int n2 = Session.NCreateSession(n);
            return Session.FindOrCreateSession(n2, n);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Session createSession(String string, String string2) throws NotesException {
        try {
            Session session = (Session)AgentBase.getAgentSession();
            if (session != null) {
                throw new NotesException(4493, JavaString.getString("agent_session"));
            }
            int n = Session.NCreateWebSession(string, string2);
            session = Session.FindOrCreateSession(n, 0);
            session.webuser = true;
            return session;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Session createSession(String string) throws NotesException {
        try {
            Session session = (Session)AgentBase.getAgentSession();
            if (session != null) {
                throw new NotesException(4493, JavaString.getString("agent_session"));
            }
            int n = Session.NCreateSessionWithPasswd(string);
            return Session.FindOrCreateSession(n, 0);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Session createSessionWithToken(String string) throws NotesException {
        try {
            Session session = (Session)AgentBase.getAgentSession();
            if (session != null) {
                throw new NotesException(4493, JavaString.getString("agent_session"));
            }
            int n = Session.NCreateSessionWithToken(string);
            session = Session.FindOrCreateSession(n, 0);
            session.webuser = true;
            return session;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    static synchronized Session FindOrCreateSession(int n, int n2) throws NotesException {
        if (sessions == null) {
            sessions = new Vector(3, 3);
        }
        Vector vector = sessions;
        synchronized (vector) {
            Enumeration enumeration = sessions.elements();
            while (enumeration.hasMoreElements()) {
                Session session = (Session)enumeration.nextElement();
                if (!session.isEqual(n) || session.context_cookie != n2) continue;
                session.CheckObject();
                Session session2 = session;
                Object var5_6 = null;
                return session2;
            }
        }
        return new Session(n, n2);
    }

    public synchronized void endAgentContext() throws NotesException {
        if (this.cpp_object > 0) {
            try {
                this.InternalRecycle();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    Session(int n) throws NotesException {
        super(n, 1);
        Session.checkSecurity();
        this.dblist = new Vector(3, 3);
        this.objlist = new Vector(3, 3);
        this.context_cookie = 0;
        this.webuser = false;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
            return;
        }
    }

    Session(int n, int n2) throws NotesException {
        super(n, 1);
        Session.checkSecurity();
        this.dblist = new Vector(3, 3);
        this.objlist = new Vector(3, 3);
        this.context_cookie = n2;
        this.webuser = false;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
            return;
        }
    }

    private static void checkSecurity() {
        block6: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Class<?> clazz = securityManager.getClass();
                    Method method = clazz.getMethod("checkCanAccessDominoClasses", null);
                    method.invoke((Object)securityManager, null);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (!(throwable instanceof RuntimeException)) break block6;
                    throw (RuntimeException)throwable;
                }
            }
        }
    }

    public Base resolve(String string) throws NotesException {
        int n;
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            n = this.Nresolve(string);
        }
        if (n == 0) {
            return null;
        }
        int n2 = this.ObjectClass(n);
        if (n2 == 1) {
            return this;
        }
        if (n2 == 2) {
            return this.FindOrCreateDatabase(n);
        }
        if (n2 == 3) {
            int n3 = this.NgetBEDatabase(n);
            lotus.domino.local.Database database = this.FindOrCreateDatabase(n3);
            return database.FindOrCreateView(n);
        }
        if (n2 == 4) {
            int n4 = this.NgetBEDatabase(n);
            lotus.domino.local.Database database = this.FindOrCreateDatabase(n4);
            return database.FindOrCreateDocument(n);
        }
        if (n2 == 20) {
            int n5 = this.NgetBEDatabase(n);
            lotus.domino.local.Database database = this.FindOrCreateDatabase(n5);
            return database.FindOrCreateForm(n);
        }
        if (n2 == 9) {
            int n6 = this.NgetBEDatabase(n);
            lotus.domino.local.Database database = this.FindOrCreateDatabase(n6);
            return database.FindOrCreateAgent(n);
        }
        return null;
    }

    void InternalFinalize() throws NotesException {
        Vector vector;
        block28: {
            try {
                Enumeration enumeration;
                vector = this.dblist;
                synchronized (vector) {
                    enumeration = this.dblist.elements();
                    while (enumeration.hasMoreElements()) {
                        lotus.domino.local.Database database = (lotus.domino.local.Database)enumeration.nextElement();
                        super.baseDestroyObject(database);
                        database.InternalFinalize();
                    }
                }
                vector = this.objlist;
                synchronized (vector) {
                    enumeration = this.objlist.elements();
                    while (enumeration.hasMoreElements()) {
                        NotesBase notesBase = (NotesBase)enumeration.nextElement();
                        super.baseDestroyObject(notesBase);
                        notesBase.InternalFinalize();
                    }
                }
                Object var4_6 = null;
                if (this.dblist == null) break block28;
                vector = this.dblist;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var4_7 = null;
                if (this.dblist != null) {
                    vector2 = this.dblist;
                    synchronized (vector2) {
                        this.dblist.removeAllElements();
                        this.dblist = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                vector2 = sessions;
                synchronized (vector2) {
                    sessions.removeElement(this);
                }
                this.context_cookie = 0;
                super.finalize();
                throw throwable;
            }
            synchronized (vector) {
                this.dblist.removeAllElements();
                this.dblist = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        vector = sessions;
        synchronized (vector) {
            sessions.removeElement(this);
        }
        this.context_cookie = 0;
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.InternalFinalize();
    }

    void InternalRecycle() throws NotesException {
        Vector vector;
        block31: {
            try {
                try {
                    Enumeration enumeration;
                    vector = this.dblist;
                    synchronized (vector) {
                        enumeration = this.dblist.elements();
                        while (enumeration.hasMoreElements()) {
                            lotus.domino.local.Database database = (lotus.domino.local.Database)enumeration.nextElement();
                            database.InternalFinalize();
                        }
                    }
                    vector = this.objlist;
                    synchronized (vector) {
                        enumeration = this.objlist.elements();
                        while (enumeration.hasMoreElements()) {
                            NotesBase notesBase = (NotesBase)enumeration.nextElement();
                            notesBase.InternalFinalize();
                        }
                    }
                }
                catch (NotesException notesException) {
                }
                Object var5_6 = null;
                if (this.dblist == null) break block31;
                vector = this.dblist;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var5_7 = null;
                if (this.dblist != null) {
                    vector2 = this.dblist;
                    synchronized (vector2) {
                        this.dblist.removeAllElements();
                        this.dblist = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                vector2 = sessions;
                synchronized (vector2) {
                    sessions.removeElement(this);
                }
                super.Recycle();
                throw throwable;
            }
            synchronized (vector) {
                this.dblist.removeAllElements();
                this.dblist = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        vector = sessions;
        synchronized (vector) {
            sessions.removeElement(this);
        }
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            AgentContext agentContext = (AgentContext)this.getAgentContext();
            if (agentContext != null) {
                return;
            }
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    void AddDatabase(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.dblist;
        synchronized (vector) {
            this.dblist.addElement(object);
            return;
        }
    }

    void RemoveDatabase(Object object) throws NotesException {
        if (this.dblist != null) {
            Vector vector = this.dblist;
            synchronized (vector) {
                this.dblist.removeElement(object);
                return;
            }
        }
    }

    void AddObject(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            this.objlist.addElement(object);
            return;
        }
    }

    void RemoveObject(Object object) throws NotesException {
        if (this.objlist != null) {
            Vector vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeElement(object);
                return;
            }
        }
    }

    DbDirectory FindOrCreateDbDirectory(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DbDirectory) || !notesBase.isEqual(n)) continue;
                DbDirectory dbDirectory = (DbDirectory)notesBase;
                Object var5_6 = null;
                return dbDirectory;
            }
        }
        return new DbDirectory(this, n);
    }

    lotus.domino.local.Database FindOrCreateDatabase(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.dblist;
        synchronized (vector) {
            Enumeration enumeration = this.dblist.elements();
            while (enumeration.hasMoreElements()) {
                lotus.domino.local.Database database = (lotus.domino.local.Database)enumeration.nextElement();
                if (!database.isEqual(n)) continue;
                lotus.domino.local.Database database2 = database;
                Object var5_6 = null;
                return database2;
            }
        }
        return new lotus.domino.local.Database(this, n);
    }

    DateTime FindOrCreateDateTime(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DateTime) || !notesBase.isEqual(n)) continue;
                DateTime dateTime = (DateTime)notesBase;
                Object var5_6 = null;
                return dateTime;
            }
        }
        return new DateTime(this, n);
    }

    DateRange FindOrCreateDateRange(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DateRange) || !notesBase.isEqual(n)) continue;
                DateRange dateRange = (DateRange)notesBase;
                Object var5_6 = null;
                return dateRange;
            }
        }
        return new DateRange(this, n);
    }

    Log FindOrCreateLog(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Log) || !notesBase.isEqual(n)) continue;
                Log log = (Log)notesBase;
                Object var5_6 = null;
                return log;
            }
        }
        return new Log(this, n);
    }

    Newsletter FindOrCreateNewsletter(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Newsletter) || !notesBase.isEqual(n)) continue;
                Newsletter newsletter = (Newsletter)notesBase;
                Object var5_6 = null;
                return newsletter;
            }
        }
        return new Newsletter(this, n);
    }

    lotus.domino.local.Name FindOrCreateName(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof lotus.domino.local.Name) || !notesBase.isEqual(n)) continue;
                lotus.domino.local.Name name = (lotus.domino.local.Name)notesBase;
                Object var5_6 = null;
                return name;
            }
        }
        return new lotus.domino.local.Name(this, n);
    }

    RichTextStyle FindOrCreateRTStyle(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof RichTextStyle) || !notesBase.isEqual(n)) continue;
                RichTextStyle richTextStyle = (RichTextStyle)notesBase;
                Object var5_6 = null;
                return richTextStyle;
            }
        }
        return new RichTextStyle(this, n);
    }

    RichTextParagraphStyle FindOrCreateRTPStyle(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof RichTextParagraphStyle) || !notesBase.isEqual(n)) continue;
                RichTextParagraphStyle richTextParagraphStyle = (RichTextParagraphStyle)notesBase;
                Object var5_6 = null;
                return richTextParagraphStyle;
            }
        }
        return new RichTextParagraphStyle(this, n);
    }

    Registration FindOrCreateRegistration(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Registration) || !notesBase.isEqual(n)) continue;
                Registration registration = (Registration)notesBase;
                Object var5_6 = null;
                return registration;
            }
        }
        return new Registration(this, n);
    }

    NotesBase FindObject(int n) throws NotesException {
        NotesBase notesBase = null;
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                notesBase = (NotesBase)enumeration.nextElement();
                if (notesBase.isEqual(n)) break;
                notesBase = null;
            }
        }
        return notesBase;
    }

    public Vector evaluate(String string) throws NotesException {
        this.CheckObject();
        return this.evaluate(string, null);
    }

    public Vector evaluate(String string, lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Vector vector = this.NEvaluate(string, (Document)document);
            Object var5_5 = null;
            return vector;
        }
    }

    public Database getDatabase(String string, String string2) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            lotus.domino.local.Database database = this.FindOrCreateDatabase(this.NgetDatabase(string, string2, true));
            Object var5_5 = null;
            return database;
        }
    }

    public Database getDatabase(String string, String string2, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int n = this.NgetDatabase(string, string2, bl);
            if (n != 0) {
                lotus.domino.local.Database database = this.FindOrCreateDatabase(n);
                Object var6_8 = null;
                return database;
            }
            Database database = null;
            Object var6_9 = null;
            return database;
        }
    }

    public lotus.domino.DateTime createDateTime(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            if (string == null || string.length() == 0) {
                throw new NotesException(4045, JavaString.getString("invalid_date"));
            }
            DateTime dateTime = this.FindOrCreateDateTime(this.NcreateDateTime(string));
            Object var4_4 = null;
            return dateTime;
        }
    }

    public lotus.domino.DateTime createDateTime(Date date) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            if (date == null) {
                throw new NotesException(4045, JavaString.getString("invalid_date"));
            }
            DateTime dateTime = this.FindOrCreateDateTime(this.NcreateDateTime(""));
            dateTime.setLocalTime(date);
            DateTime dateTime2 = dateTime;
            Object var4_5 = null;
            return dateTime2;
        }
    }

    public lotus.domino.Log createLog(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Log log = this.FindOrCreateLog(this.NcreateLog(string));
            Object var4_4 = null;
            return log;
        }
    }

    public lotus.domino.Newsletter createNewsletter(lotus.domino.DocumentCollection documentCollection) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Newsletter newsletter = this.FindOrCreateNewsletter(this.NcreateNewsletter((DocumentCollection)documentCollection));
            Object var4_4 = null;
            return newsletter;
        }
    }

    public lotus.domino.DbDirectory getDbDirectory(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            DbDirectory dbDirectory = this.FindOrCreateDbDirectory(this.NgetDbDirectory(string));
            Object var4_4 = null;
            return dbDirectory;
        }
    }

    public lotus.domino.DateRange createDateRange() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            DateRange dateRange = this.FindOrCreateDateRange(this.NcreateDateRange());
            Object var3_3 = null;
            return dateRange;
        }
    }

    public lotus.domino.DateRange createDateRange(lotus.domino.DateTime dateTime, lotus.domino.DateTime dateTime2) throws NotesException {
        this.CheckObject();
        if (dateTime == null || dateTime2 == null) {
            throw new NotesException(4449, JavaString.getString("missing_datetime_object"));
        }
        DateRange dateRange = (DateRange)this.createDateRange();
        dateRange.setStartDateTime((DateTime)dateTime);
        dateRange.setEndDateTime((DateTime)dateTime2);
        return dateRange;
    }

    public lotus.domino.DateRange createDateRange(Date date, Date date2) throws NotesException {
        this.CheckObject();
        if (date == null || date2 == null) {
            throw new NotesException(4045, JavaString.getString("invalid_date"));
        }
        DateRange dateRange = (DateRange)this.createDateRange();
        dateRange.setStartDateTime(this.createDateTime(date));
        dateRange.setEndDateTime(this.createDateTime(date2));
        return dateRange;
    }

    public Name createName(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            lotus.domino.local.Name name = this.FindOrCreateName(this.NcreateName(string, null));
            Object var4_4 = null;
            return name;
        }
    }

    public Name createName(String string, String string2) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            lotus.domino.local.Name name = this.FindOrCreateName(this.NcreateName(string, string2));
            Object var5_5 = null;
            return name;
        }
    }

    public lotus.domino.RichTextStyle createRichTextStyle() throws NotesException {
        Session session = this;
        synchronized (session) {
            RichTextStyle richTextStyle = this.FindOrCreateRTStyle(this.NcreateRTStyle());
            Object var3_3 = null;
            return richTextStyle;
        }
    }

    public lotus.domino.RichTextParagraphStyle createRichTextParagraphStyle() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            RichTextParagraphStyle richTextParagraphStyle = this.FindOrCreateRTPStyle(this.NcreateRTPStyle());
            Object var3_3 = null;
            return richTextParagraphStyle;
        }
    }

    public String getEnvironmentString(String string) throws NotesException {
        this.CheckObject();
        return this.getEnvironmentString(string, false);
    }

    public String getEnvironmentString(String string, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string2 = this.NgetEnvironmentString(string, bl);
            Object var5_5 = null;
            return string2;
        }
    }

    public Object getEnvironmentValue(String string) throws NotesException {
        this.CheckObject();
        return this.getEnvironmentValue(string, false);
    }

    public Object getEnvironmentValue(String string, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Object object = this.NgetEnvironmentValue(string, bl);
            Object var5_5 = null;
            return object;
        }
    }

    public void setEnvironmentVar(String string, Object object) throws NotesException {
        this.CheckObject();
        this.setEnvironmentVar(string, object, false);
    }

    public void setEnvironmentVar(String string, Object object, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            this.NsetEnvironmentVar(string, object, bl);
            return;
        }
    }

    public Vector freeTimeSearch(lotus.domino.DateRange dateRange, int n, Object object, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            if (dateRange == null) {
                throw new NotesException(4445, JavaString.getString("missing_daterange_object"));
            }
            int[] nArray = this.NfreeTimeSearch((DateRange)dateRange, n, object, bl);
            Vector<DateRange> vector = null;
            if (nArray != null && nArray.length > 0) {
                vector = new Vector<DateRange>(nArray.length, 1);
                int n2 = 0;
                while (n2 < nArray.length) {
                    DateRange dateRange2 = this.FindOrCreateDateRange(nArray[n2]);
                    vector.addElement(dateRange2);
                    ++n2;
                }
            }
            Vector<DateRange> vector2 = vector;
            Object var7_11 = null;
            return vector2;
        }
    }

    public Database getURLDatabase() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            lotus.domino.local.Database database;
            lotus.domino.local.Database database2 = database = this.FindOrCreateDatabase(this.NgetURLDatabase());
            Object var3_4 = null;
            return database2;
        }
    }

    public lotus.domino.Registration createRegistration() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Registration registration;
            Registration registration2 = registration = this.FindOrCreateRegistration(this.NcreateRegistration());
            Object var3_4 = null;
            return registration2;
        }
    }

    public Vector getAddressBooks() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int[] nArray = this.PropGetObjArray(1198);
            if (nArray == null) {
                Vector vector = new Vector(0);
                Object var3_5 = null;
                return vector;
            }
            Vector<lotus.domino.local.Database> vector = new Vector<lotus.domino.local.Database>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                lotus.domino.local.Database database = this.FindOrCreateDatabase(nArray[n]);
                vector.addElement(database);
                ++n;
            }
            Vector<lotus.domino.local.Database> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public Vector getUserNameList() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int[] nArray = this.PropGetObjArray(2158);
            if (nArray == null) {
                Vector vector = new Vector(0);
                Object var3_5 = null;
                return vector;
            }
            Vector<lotus.domino.local.Name> vector = new Vector<lotus.domino.local.Name>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                lotus.domino.local.Name name = this.FindOrCreateName(nArray[n]);
                vector.addElement(name);
                ++n;
            }
            Vector<lotus.domino.local.Name> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public String getCommonUserName() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            if (this.webuser) {
                String string = this.PropGetString(1227);
                Object var3_4 = null;
                return string;
            }
            String string = this.PropGetString(1201);
            Object var3_5 = null;
            return string;
        }
    }

    public lotus.domino.International getInternational() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int n = this.PropGetAdt(1213);
            International international = (International)this.FindObject(n);
            if (international == null) {
                international = new International(this, n);
            }
            International international2 = international;
            Object var4_5 = null;
            return international2;
        }
    }

    public boolean isOnServer() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            boolean bl = this.PropGetBool(1196);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getNotesVersion() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1200);
            Object var3_3 = null;
            return string;
        }
    }

    public String getPlatform() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1191);
            Object var3_3 = null;
            return string;
        }
    }

    public String getUserName() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            if (this.webuser) {
                String string = this.PropGetString(1195);
                Object var3_4 = null;
                return string;
            }
            String string = this.PropGetString(1190);
            Object var3_5 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getUserName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public Name getUserNameObject() throws NotesException {
        this.CheckObject();
        String string = this.getUserName();
        if (string != null) {
            lotus.domino.local.Name name = (lotus.domino.local.Name)this.createName(string);
            return name;
        }
        return null;
    }

    public lotus.domino.AgentContext getAgentContext() throws NotesException {
        this.CheckObject();
        if (this.agentcontext == null) {
            Session session = this;
            synchronized (session) {
                int n = this.PropGetAdt(1901);
                if (n != 0) {
                    this.agentcontext = new AgentContext(this, n);
                }
            }
        }
        return this.agentcontext;
    }

    public String getServerName() throws NotesException {
        if (this.isOnServer()) {
            return this.PropGetString(1190);
        }
        return "";
    }

    public String getURL() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.NGetNotesUrl();
            Object var3_3 = null;
            return string;
        }
    }

    public boolean isConvertMime() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            boolean bl = this.PropGetBool(1226);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setConvertMime(boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            this.PropSetBool(1226, bl);
            return;
        }
    }

    public String getSessionToken() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.NgetSessionToken(null);
            Object var3_3 = null;
            return string;
        }
    }

    public String getSessionToken(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string2 = this.NgetSessionToken(string);
            Object var4_4 = null;
            return string2;
        }
    }

    public Object getCredentials() throws NotesException {
        return NotesFactory.getCredentials(this);
    }
}

