/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import lotus.domino.local.CollectionPos;
import lotus.domino.local.DateTime;
import lotus.domino.local.Document;
import lotus.domino.local.DocumentCollection;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Session;
import lotus.domino.local.ViewColumn;
import lotus.domino.local.ViewNavigator;

public class View
extends NotesBase
implements lotus.domino.View {
    transient lotus.domino.local.Database database;
    private transient Vector columns;
    private transient Vector objlist;

    private native void Nclear();

    private native int NFTSearch(String var1, int var2);

    private native int NgetChild(Document var1);

    private native int NgetDocumentByKey(Vector var1, boolean var2);

    private native int NgetAllDocumentsByKey(Vector var1, boolean var2);

    private native int NgetFirstDocument();

    private native int NgetLastDocument();

    private native int NgetNextDocument(Document var1);

    private native int NgetNextSibling(Document var1);

    private native int NgetNthDocument(int var1);

    private native int NgetParentDocument(Document var1);

    private native int NgetPrevDocument(Document var1);

    private native int NgetPrevSibling(Document var1);

    private native void Nrefresh();

    private native void Nremove();

    native int NgetOneViewEntry(CollectionPos var1, int var2, int var3, int var4, int var5, int var6);

    private native int NgetEntryByKey(Vector var1, boolean var2, CollectionPos var3);

    private native int NgetAllEntriesByKey(Vector var1, boolean var2);

    private native int NgetAllEntries();

    private native String NGetNotesUrl();

    private native int NcreateViewNav(int var1, Object var2, int var3);

    private native int NcreateViewNavCat(Vector var1);

    View() throws NotesException {
    }

    View(lotus.domino.local.Database database, int n) throws NotesException {
        super(n, 3);
        if (database == null) {
            throw new NotesException(4405, JavaString.getString("missing_db_object"));
        }
        this.database = database;
        this.columns = new Vector(3);
        this.objlist = new Vector(3);
        database.AddView(this);
    }

    void InternalFinalize() throws NotesException {
        Vector vector;
        block26: {
            try {
                try {
                    Enumeration enumeration;
                    vector = this.columns;
                    synchronized (vector) {
                        enumeration = this.columns.elements();
                        while (enumeration.hasMoreElements()) {
                            ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                            super.baseDestroyObject(viewColumn);
                        }
                    }
                    vector = this.objlist;
                    synchronized (vector) {
                        enumeration = this.objlist.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            super.baseDestroyObject((NotesBase)e);
                        }
                    }
                }
                catch (Exception exception) {
                }
                Object var5_6 = null;
                if (this.columns == null) break block26;
                vector = this.columns;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var5_7 = null;
                if (this.columns != null) {
                    vector2 = this.columns;
                    synchronized (vector2) {
                        this.columns.removeAllElements();
                        this.columns = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                super.finalize();
                throw throwable;
            }
            synchronized (vector) {
                this.columns.removeAllElements();
                this.columns = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveView(this);
        this.InternalFinalize();
    }

    void AddColumn(ViewColumn viewColumn) throws NotesException {
        this.CheckObject();
        Vector vector = this.columns;
        synchronized (vector) {
            this.columns.addElement(viewColumn);
            return;
        }
    }

    void RemoveColumn(ViewColumn viewColumn) throws NotesException {
        Vector vector = this.columns;
        synchronized (vector) {
            this.columns.removeElement(viewColumn);
            return;
        }
    }

    void AddObject(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            this.objlist.addElement(object);
            return;
        }
    }

    void RemoveObject(Object object) throws NotesException {
        if (this.objlist != null) {
            Vector vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeElement(object);
                return;
            }
        }
    }

    ViewColumn FindOrCreateColumn(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.columns;
        synchronized (vector) {
            Enumeration enumeration = this.columns.elements();
            while (enumeration.hasMoreElements()) {
                ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                if (!viewColumn.isEqual(n)) continue;
                ViewColumn viewColumn2 = viewColumn;
                Object var5_7 = null;
                return viewColumn2;
            }
            ViewColumn viewColumn = new ViewColumn(this, n);
            Object var5_8 = null;
            return viewColumn;
        }
    }

    void InternalRecycle() throws NotesException {
        Vector vector;
        block26: {
            try {
                try {
                    Enumeration enumeration;
                    this.database.RemoveView(this);
                    vector = this.columns;
                    synchronized (vector) {
                        enumeration = this.columns.elements();
                        while (enumeration.hasMoreElements()) {
                            ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                            viewColumn.InternalFinalize();
                        }
                    }
                    vector = this.objlist;
                    synchronized (vector) {
                        enumeration = this.objlist.elements();
                        while (enumeration.hasMoreElements()) {
                            NotesBase notesBase = (NotesBase)enumeration.nextElement();
                            notesBase.InternalFinalize();
                        }
                    }
                }
                catch (NotesException notesException) {
                }
                Object var5_6 = null;
                if (this.columns == null) break block26;
                vector = this.columns;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var5_7 = null;
                if (this.columns != null) {
                    vector2 = this.columns;
                    synchronized (vector2) {
                        this.columns.removeAllElements();
                        this.columns = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                super.Recycle();
                throw throwable;
            }
            synchronized (vector) {
                this.columns.removeAllElements();
                this.columns = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            this.database.RemoveView(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public void clear() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nclear();
            return;
        }
    }

    public int FTSearch(String string, int n) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n2 = this.NFTSearch(string, n);
            Object var5_5 = null;
            return n2;
        }
    }

    public int FTSearch(String string) throws NotesException {
        return this.FTSearch(string, 0);
    }

    public lotus.domino.Document getChild(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetChild((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getDocumentByKey(Vector vector) throws NotesException {
        return this.getDocumentByKey(vector, false);
    }

    public lotus.domino.Document getDocumentByKey(Vector vector, boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetDocumentByKey(vector, bl));
            Object var5_5 = null;
            return document;
        }
    }

    public lotus.domino.Document getDocumentByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getDocumentByKey(vector, false);
    }

    public lotus.domino.Document getDocumentByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getDocumentByKey(vector, bl);
    }

    public lotus.domino.DocumentCollection getAllDocumentsByKey(Vector vector) throws NotesException {
        return this.getAllDocumentsByKey(vector, false);
    }

    public lotus.domino.DocumentCollection getAllDocumentsByKey(Vector vector, boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DocumentCollection documentCollection = this.database.FindOrCreateDocCollection(this.NgetAllDocumentsByKey(vector, bl));
            Object var5_5 = null;
            return documentCollection;
        }
    }

    public lotus.domino.DocumentCollection getAllDocumentsByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllDocumentsByKey(vector, false);
    }

    public lotus.domino.DocumentCollection getAllDocumentsByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllDocumentsByKey(vector, bl);
    }

    public ViewEntry getEntryByKey(Vector vector) throws NotesException {
        return this.iGetEntryByKey(vector, false);
    }

    public ViewEntry getEntryByKey(Vector vector, boolean bl) throws NotesException {
        return this.iGetEntryByKey(vector, bl);
    }

    public ViewEntry getEntryByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.iGetEntryByKey(vector, false);
    }

    public ViewEntry getEntryByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.iGetEntryByKey(vector, bl);
    }

    ViewEntry iGetEntryByKey(Vector vector, boolean bl) throws NotesException {
        CollectionPos collectionPos = new CollectionPos();
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.NgetEntryByKey(vector, bl, collectionPos);
            if (n == 0) {
                ViewEntry viewEntry = null;
                Object var7_8 = null;
                return viewEntry;
            }
            lotus.domino.local.ViewEntry viewEntry = new lotus.domino.local.ViewEntry(this, n, collectionPos);
            Object var7_9 = null;
            return viewEntry;
        }
    }

    public ViewEntryCollection getAllEntriesByKey(Vector vector) throws NotesException {
        return this.getAllEntriesByKey(vector, false);
    }

    public ViewEntryCollection getAllEntriesByKey(Vector vector, boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            lotus.domino.local.ViewEntryCollection viewEntryCollection = new lotus.domino.local.ViewEntryCollection(this, this.NgetAllEntriesByKey(vector, bl));
            Object var5_5 = null;
            return viewEntryCollection;
        }
    }

    public ViewEntryCollection getAllEntriesByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllEntriesByKey(vector, false);
    }

    public ViewEntryCollection getAllEntriesByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllEntriesByKey(vector, bl);
    }

    public ViewEntryCollection getAllEntries() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            lotus.domino.local.ViewEntryCollection viewEntryCollection = new lotus.domino.local.ViewEntryCollection(this, this.NgetAllEntries());
            Object var3_3 = null;
            return viewEntryCollection;
        }
    }

    public lotus.domino.Document getFirstDocument() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetFirstDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public lotus.domino.Document getLastDocument() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetLastDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public lotus.domino.Document getNextDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextDocument((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getNextSibling(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextSibling((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getNthDocument(int n) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetNthDocument(n));
            Object var4_4 = null;
            return document;
        }
    }

    public lotus.domino.Document getParentDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetParentDocument((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getPrevDocument(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevDocument((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public lotus.domino.Document getPrevSibling(lotus.domino.Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            if (document == null) {
                throw new NotesException(4406, JavaString.getString("missing_document_object"));
            }
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevSibling((Document)document));
            Object var4_4 = null;
            return document2;
        }
    }

    public void refresh() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nrefresh();
            return;
        }
    }

    public void remove() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nremove();
            this.database.RemoveView(this);
            this.finalize();
            return;
        }
    }

    public lotus.domino.DateTime getCreated() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DateTime dateTime = ((Session)this.database.getParent()).FindOrCreateDateTime(this.PropGetDate(1282));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public lotus.domino.DateTime getLastModified() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DateTime dateTime = ((Session)this.database.getParent()).FindOrCreateDateTime(this.PropGetDate(1281));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            String string = this.PropGetString(1280);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getUniversalID() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            String string = this.PropGetString(1283);
            Object var3_3 = null;
            return string;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isDefaultView() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1285);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isFolder() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1287);
            Object var3_3 = null;
            return bl;
        }
    }

    public Vector getColumns() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int[] nArray = this.PropGetObjArray(1286);
            if (nArray.length == 0) {
                Vector vector = null;
                Object var3_5 = null;
                return vector;
            }
            Vector<ViewColumn> vector = new Vector<ViewColumn>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                ViewColumn viewColumn = this.FindOrCreateColumn(nArray[n]);
                vector.addElement(viewColumn);
                ++n;
            }
            Vector<ViewColumn> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public Vector getReaders() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1302);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public void setReaders(Vector vector) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetVector(1302, vector);
            return;
        }
    }

    public boolean isAutoUpdate() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1303);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setAutoUpdate(boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetBool(1303, bl);
            return;
        }
    }

    public Vector getAliases() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1304);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public boolean isCalendar() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1305);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isProtectReaders() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1309);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setProtectReaders(boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetBool(1309, bl);
            return;
        }
    }

    public boolean isModified() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1925);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isCategorized() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1927);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isPrivate() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1310);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isConflict() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1921);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isHierarchical() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1920);
            Object var3_3 = null;
            return bl;
        }
    }

    public int getColumnCount() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1928);
            Object var3_3 = null;
            return n;
        }
    }

    public int getBackgroundColor() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1926);
            Object var3_3 = null;
            return n;
        }
    }

    public int getRowLines() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1922);
            Object var3_3 = null;
            return n;
        }
    }

    public int getHeaderLines() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1923);
            Object var3_3 = null;
            return n;
        }
    }

    public int getSpacing() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1924);
            Object var3_3 = null;
            return n;
        }
    }

    public int getTopLevelEntryCount() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1929);
            Object var3_3 = null;
            return n;
        }
    }

    public lotus.domino.ViewColumn getColumn(int n) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            ViewColumn viewColumn;
            int[] nArray = this.PropGetObjArray(1286);
            if (nArray.length == 0) {
                lotus.domino.ViewColumn viewColumn2 = null;
                Object var4_6 = null;
                return viewColumn2;
            }
            if (n < 1 || n > nArray.length) {
                throw new NotesException(4396, JavaString.getString("invalid_view_column_number"));
            }
            ViewColumn viewColumn3 = viewColumn = this.FindOrCreateColumn(nArray[n - 1]);
            Object var4_7 = null;
            return viewColumn3;
        }
    }

    public Vector getColumnNames() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n = this.PropGetInt(1928);
            Vector<String> vector = new Vector<String>(n);
            int[] nArray = this.PropGetObjArray(1286);
            if (nArray.length == 0) {
                Vector<String> vector2 = vector;
                Object var4_7 = null;
                return vector2;
            }
            int n2 = 0;
            while (n2 < n) {
                ViewColumn viewColumn = this.FindOrCreateColumn(nArray[n2]);
                vector.addElement(viewColumn.getTitle());
                ++n2;
            }
            Vector<String> vector3 = vector;
            Object var4_8 = null;
            return vector3;
        }
    }

    public lotus.domino.ViewNavigator createViewNav() throws NotesException {
        this.CheckObject();
        return new ViewNavigator(this, this.NcreateViewNav(0, null, 30));
    }

    public lotus.domino.ViewNavigator createViewNav(int n) throws NotesException {
        return this.createViewNav();
    }

    public lotus.domino.ViewNavigator createViewNavMaxLevel(int n) throws NotesException {
        this.CheckObject();
        return new ViewNavigator(this, this.NcreateViewNav(0, null, n));
    }

    public lotus.domino.ViewNavigator createViewNavMaxLevel(int n, int n2) throws NotesException {
        return this.createViewNavMaxLevel(n);
    }

    public lotus.domino.ViewNavigator createViewNavFrom(Object object) throws NotesException {
        this.CheckObject();
        this.validateObjArg(object, false);
        return new ViewNavigator(this, this.NcreateViewNav(3, object, 30));
    }

    public lotus.domino.ViewNavigator createViewNavFrom(Object object, int n) throws NotesException {
        return this.createViewNavFrom(object);
    }

    public lotus.domino.ViewNavigator createViewNavFromChildren(Object object) throws NotesException {
        this.CheckObject();
        this.validateObjArg(object, false);
        return new ViewNavigator(this, this.NcreateViewNav(1, object, 30));
    }

    public lotus.domino.ViewNavigator createViewNavFromChildren(Object object, int n) throws NotesException {
        return this.createViewNavFromChildren(object);
    }

    public lotus.domino.ViewNavigator createViewNavFromDescendants(Object object) throws NotesException {
        this.CheckObject();
        this.validateObjArg(object, false);
        return new ViewNavigator(this, this.NcreateViewNav(2, object, 30));
    }

    public lotus.domino.ViewNavigator createViewNavFromDescendants(Object object, int n) throws NotesException {
        return this.createViewNavFromDescendants(object);
    }

    public lotus.domino.ViewNavigator createViewNavFromCategory(String string) throws NotesException {
        this.CheckObject();
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string);
        return new ViewNavigator(this, this.NcreateViewNavCat(vector));
    }

    public lotus.domino.ViewNavigator createViewNavFromCategory(String string, int n) throws NotesException {
        return this.createViewNavFromCategory(string);
    }

    public String getURL() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            String string = this.NGetNotesUrl();
            Object var3_3 = null;
            return string;
        }
    }
}

