/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.util;

public class Platform {
    protected static String osname;
    protected static String osver;
    protected static String osarch;
    protected static String prefix;
    protected static String suffix;
    protected static boolean fFound;

    public static String getPrefix() {
        if (fFound) {
            return prefix;
        }
        return null;
    }

    public static String getSuffix() {
        if (fFound) {
            return suffix;
        }
        return null;
    }

    public static String getLibName(String string) {
        if (fFound) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            String string2 = prefix == null ? "" : prefix;
            String string3 = suffix == null ? "" : suffix;
            return String.valueOf(string2) + string + string3;
        }
        return string;
    }

    public static String getName() {
        return osname;
    }

    public static String getVersion() {
        return osver;
    }

    public static String getArchitecture() {
        return osarch;
    }

    public static boolean isSupported() {
        return fFound;
    }

    static {
        fFound = true;
        osname = System.getProperty("os.name");
        osver = System.getProperty("os.version");
        osarch = System.getProperty("os.arch");
        if (osname.startsWith("Windows")) {
            if (osarch.equals("x86")) {
                prefix = "n";
            } else if (osarch.equals("alpha")) {
                prefix = "a";
            } else {
                fFound = false;
            }
        } else if (osname.equals("OS/2")) {
            prefix = "i";
        } else if (osname.equals("AIX")) {
            suffix = "_r";
        } else if (!(osname.equals("SunOS") || osname.equals("Solaris") || osname.equals("Mac OS") || osname.equals("Linux") || osname.equals("HP-UX") || osname.equals("HPUX") || osname.equals("OS/390") || osname.equals("z/OS"))) {
            if (osname.equals("OS/400")) {
                prefix = "lib";
            } else {
                fFound = false;
            }
        }
    }
}

