/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Enumeration;
import java.util.Vector;
import lotus.notes.ACLEntry;
import lotus.notes.Database;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;

public class ACL
extends NotesBase {
    private transient Database database;
    private transient Vector entrylist;

    private native int NgetFirstEntry();

    private native int NgetNextEntry(ACLEntry var1);

    private native int NgetEntry(String var1);

    private native void Nsave();

    private native void NrenameRole(String var1, String var2);

    private native void NaddRole(String var1);

    private native void NdeleteRole(String var1);

    private native int NcreateACLEntry(String var1, int var2);

    protected ACL() throws NotesException {
    }

    protected ACL(Database database, int n) throws NotesException {
        super(n, 13);
        if (database == null) {
            throw new NotesException(JavaString.getString("missing_db_object"));
        }
        this.database = database;
        this.entrylist = new Vector(3);
        database.AddObject(this);
    }

    protected void InternalFinalize() throws NotesException {
        try {
            try {
                Enumeration enumeration = this.entrylist.elements();
                while (enumeration.hasMoreElements()) {
                    ACLEntry aCLEntry = (ACLEntry)enumeration.nextElement();
                    super.DestroyObject(aCLEntry);
                }
            }
            catch (Exception exception) {
            }
            Object var3_3 = null;
            this.entrylist.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.entrylist.removeAllElements();
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public synchronized void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    protected void AddEntry(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.entrylist;
        synchronized (vector) {
            this.entrylist.addElement(object);
            return;
        }
    }

    protected void RemoveEntry(Object object) throws NotesException {
        Vector vector = this.entrylist;
        synchronized (vector) {
            this.entrylist.removeElement(object);
            return;
        }
    }

    ACLEntry FindOrCreateEntry(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.entrylist;
        synchronized (vector) {
            Enumeration enumeration = this.entrylist.elements();
            while (enumeration.hasMoreElements()) {
                ACLEntry aCLEntry = (ACLEntry)enumeration.nextElement();
                if (!aCLEntry.isEqual(n)) continue;
                ACLEntry aCLEntry2 = aCLEntry;
                Object var5_6 = null;
                return aCLEntry2;
            }
        }
        return new ACLEntry(this, n);
    }

    public synchronized void recycle() throws NotesException {
        try {
            try {
                this.database.RemoveObject(this);
                Enumeration enumeration = this.entrylist.elements();
                while (enumeration.hasMoreElements()) {
                    ACLEntry aCLEntry = (ACLEntry)enumeration.nextElement();
                    super.RecycleObject(aCLEntry);
                }
            }
            catch (NotesException notesException) {
            }
            Object var3_3 = null;
            this.entrylist.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.entrylist.removeAllElements();
            super.Recycle();
            throw throwable;
        }
        super.Recycle();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public ACLEntry getFirstEntry() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            ACLEntry aCLEntry = this.FindOrCreateEntry(this.NgetFirstEntry());
            Object var3_3 = null;
            return aCLEntry;
        }
    }

    public ACLEntry getNextEntry(ACLEntry aCLEntry) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            ACLEntry aCLEntry2 = this.FindOrCreateEntry(this.NgetNextEntry(aCLEntry));
            Object var4_4 = null;
            return aCLEntry2;
        }
    }

    public ACLEntry getEntry(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            ACLEntry aCLEntry = this.FindOrCreateEntry(this.NgetEntry(string));
            Object var4_4 = null;
            return aCLEntry;
        }
    }

    public void save() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.Nsave();
            return;
        }
    }

    public void renameRole(String string, String string2) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NrenameRole(string, string2);
            return;
        }
    }

    public void addRole(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NaddRole(string);
            return;
        }
    }

    public void deleteRole(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NdeleteRole(string);
            return;
        }
    }

    public ACLEntry createACLEntry(String string, int n) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            ACLEntry aCLEntry = this.FindOrCreateEntry(this.NcreateACLEntry(string, n));
            Object var5_5 = null;
            return aCLEntry;
        }
    }

    public Vector getRoles() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1400);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isUniformAccess() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            boolean bl = this.PropGetBool(1423);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setUniformAccess(boolean bl) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.PropSetBool(1423, bl);
            return;
        }
    }
}

