/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;

public class Agent
extends NotesBase {
    private transient Database database;

    private native int Nrun(boolean var1);

    private native void Nremove();

    private native void Nsave();

    protected Agent() throws NotesException {
    }

    protected Agent(Database database, int n) throws NotesException {
        super(n, 9);
        if (database == null) {
            throw new NotesException(JavaString.getString("missing_db_object"));
        }
        this.database = database;
        database.AddObject(this);
    }

    protected void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    public void recycle() throws NotesException {
        try {
            try {
                this.database.RemoveObject(this);
            }
            catch (NotesException notesException) {
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public void run() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nrun(false);
            return;
        }
    }

    public int runOnServer() throws NotesException {
        int n = 0;
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            n = this.Nrun(true);
        }
        return n;
    }

    public void remove() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nremove();
            this.database.RemoveObject(this);
            this.cpp_object = 0;
            this.finalize();
            return;
        }
    }

    public void save() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nsave();
            return;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1110);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getOwner() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1111);
            Object var3_3 = null;
            return string;
        }
    }

    public DateTime getLastRun() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            DateTime dateTime = this.database.getParent().FindOrCreateDateTime(this.PropGetDate(1112));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public boolean isEnabled() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1113);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setEnabled(boolean bl) throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.PropSetBool(1113, bl);
            return;
        }
    }

    public String getServerName() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1114);
            Object var3_3 = null;
            return string;
        }
    }

    public void setServerName(String string) throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.PropSetString(1114, string);
            return;
        }
    }

    public String getQuery() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1115);
            Object var3_3 = null;
            return string;
        }
    }

    public String getComment() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1116);
            Object var3_3 = null;
            return string;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isPublic() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1118);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getCommonOwner() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1119);
            Object var3_3 = null;
            return string;
        }
    }
}

