/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.Agent;
import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;
import lotus.notes.Session;

public class AgentContext
extends NotesBase {
    private transient Session session;
    private transient Document contextdoc;
    private transient Document saveddata;

    private native void NupdateProcessedDoc(Document var1);

    private native int NunprocessedFTSearch(String var1, int var2, int var3, int var4);

    private native int NunprocessedSearch(String var1, DateTime var2, int var3);

    public AgentContext() throws NotesException {
    }

    protected AgentContext(Session session, int n) throws NotesException {
        super(n, 23);
        this.session = session;
        session.AddObject(this);
    }

    protected void InternalFinalize() throws NotesException {
        this.saveddata = null;
        this.contextdoc = null;
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.session.RemoveObject(this);
        this.InternalFinalize();
    }

    public void updateProcessedDoc(Document document) throws NotesException {
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            this.NupdateProcessedDoc(document);
            return;
        }
    }

    public DocumentCollection unprocessedFTSearch(String string, int n) throws NotesException {
        this.CheckObject();
        Database database = this.getCurrentDatabase();
        if (database != null) {
            AgentContext agentContext = this;
            synchronized (agentContext) {
                DocumentCollection documentCollection = database.FindOrCreateDocCollection(this.NunprocessedFTSearch(string, n, 0, 0));
                Object var6_6 = null;
                return documentCollection;
            }
        }
        return null;
    }

    public DocumentCollection unprocessedFTSearch(String string, int n, int n2, int n3) throws NotesException {
        this.CheckObject();
        Database database = this.getCurrentDatabase();
        if (database != null) {
            AgentContext agentContext = this;
            synchronized (agentContext) {
                DocumentCollection documentCollection = database.FindOrCreateDocCollection(this.NunprocessedFTSearch(string, n, n2, n3));
                Object var8_8 = null;
                return documentCollection;
            }
        }
        return null;
    }

    public DocumentCollection unprocessedSearch(String string, DateTime dateTime, int n) throws NotesException {
        this.CheckObject();
        Database database = this.getCurrentDatabase();
        if (database != null) {
            AgentContext agentContext = this;
            synchronized (agentContext) {
                DocumentCollection documentCollection = database.FindOrCreateDocCollection(this.NunprocessedSearch(string, dateTime, n));
                Object var7_7 = null;
                return documentCollection;
            }
        }
        return null;
    }

    public String getEffectiveUserName() throws NotesException {
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            String string = this.PropGetString(1850);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getEffectiveUserName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public Agent getCurrentAgent() throws NotesException {
        Agent agent = null;
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            Database database;
            int n = this.PropGetAdt(1851);
            agent = (Agent)this.session.FindObject(n);
            if (agent == null && (database = this.getCurrentDatabase()) != null) {
                agent = new Agent(database, n);
            }
            Agent agent2 = agent;
            Object var4_6 = null;
            return agent2;
        }
    }

    public Database getCurrentDatabase() throws NotesException {
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            int n = this.PropGetAdt(1852);
            Database database = this.session.FindOrCreateDatabase(n);
            Object var3_4 = null;
            return database;
        }
    }

    public Document getDocumentContext() throws NotesException {
        this.CheckObject();
        if (this.contextdoc == null) {
            AgentContext agentContext = this;
            synchronized (agentContext) {
                int n = this.PropGetAdt(1853);
                if (n != 0) {
                    this.contextdoc = new Document(this.session, n);
                }
            }
        }
        return this.contextdoc;
    }

    public int getLastExitStatus() throws NotesException {
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            int n = this.PropGetInt(1854);
            Object var3_3 = null;
            return n;
        }
    }

    public DateTime getLastRun() throws NotesException {
        this.CheckObject();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            DateTime dateTime = this.session.FindOrCreateDateTime(this.PropGetDate(1855));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public Document getSavedData() throws NotesException {
        this.CheckObject();
        if (this.saveddata == null) {
            AgentContext agentContext = this;
            synchronized (agentContext) {
                int n = this.PropGetAdt(1856);
                Database database = this.getCurrentDatabase();
                this.saveddata = new Document(database, n);
            }
        }
        return this.saveddata;
    }

    public DocumentCollection getUnprocessedDocuments() throws NotesException {
        this.CheckObject();
        Database database = this.getCurrentDatabase();
        AgentContext agentContext = this;
        synchronized (agentContext) {
            int n = this.PropGetAdt(1857);
            DocumentCollection documentCollection = database.FindOrCreateDocCollection(n);
            Object var4_5 = null;
            return documentCollection;
        }
    }
}

