/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.Database;
import lotus.notes.DebugAgentBase;
import lotus.notes.Document;
import lotus.notes.NotesException;
import lotus.notes.NotesThread;
import lotus.notes.Session;
import lotus.notes.View;

public class AgentRunner
extends NotesThread {
    private static String dumpAgentContextFile = "AgentRunner.nsf";
    private static String argServer;
    private static String argDatabase;
    private static String argAgent;
    private String keyServer;
    private String keyDatabase;
    private String keyAgent;
    private String agentClassName;

    public static void main(String[] stringArray) throws Exception {
        AgentRunner agentRunner = new AgentRunner();
        if (stringArray.length > 3) {
            System.out.println("AgentRunner=> too many arguments");
            System.out.println("Usage: java AgentRunner <agent> [<database> [<server>]]");
            return;
        }
        if (stringArray.length == 0) {
            System.out.println("AgentRunner=> no arguments");
            System.out.println("Usage: java AgentRunner <agent> [<database> [<server>]]");
            return;
        }
        if (stringArray.length > 0) {
            argAgent = stringArray[0];
        }
        if (stringArray.length > 1) {
            argDatabase = stringArray[1];
        }
        if (stringArray.length > 2) {
            argServer = stringArray[2];
        }
        agentRunner.start();
    }

    public void runNotes() {
        try {
            if (this.getAgent()) {
                this.runAgent();
                return;
            }
            System.out.println("AgentRunner=>No AgentContext document found for:");
            System.out.println("   <agent=" + argAgent + ">");
            if (argDatabase != null) {
                System.out.println("   <database=" + argDatabase + ">");
            }
            if (argServer != null) {
                System.out.println("   <server=" + argServer + ">");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getAgent() throws NotesException {
        boolean bl = false;
        Session session = null;
        Database database = null;
        View view = null;
        Document document = null;
        try {
            session = Session.newInstance();
            database = session.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                throw new NotesException(0, "AgentRunner=>AgentContext database not found");
            }
            view = database.getView("($AgentContexts)");
            if (view == null) {
                throw new NotesException(0, "AgentRunner=>$AgentContexts view not found");
            }
            document = view.getFirstDocument();
            while (document != null) {
                this.keyAgent = document.getItemValueString("CurrentAgent");
                this.keyDatabase = document.getItemValueString("CurrentDatabase_FilePath");
                String string = document.getItemValueString("CurrentDatabase_Server");
                this.keyServer = string == null || string.equals("") ? "local" : string;
                if (argAgent.equalsIgnoreCase(this.keyAgent) && (argDatabase == null || argDatabase.equalsIgnoreCase(this.keyDatabase)) && (argServer == null || argServer.equalsIgnoreCase(this.keyServer))) {
                    this.agentClassName = document.getItemValueString("ClassName");
                    bl = true;
                    break;
                }
                document = view.getNextDocument(document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (document != null) {
            document.recycle();
        }
        if (view != null) {
            view.recycle();
        }
        if (database != null) {
            database.recycle();
        }
        return bl;
    }

    public void runAgent() {
        try {
            Class<?> clazz = Class.forName(this.agentClassName);
            DebugAgentBase debugAgentBase = (DebugAgentBase)clazz.newInstance();
            debugAgentBase.initAgentRunner(this.keyServer, this.keyDatabase, this.keyAgent);
            debugAgentBase.NotesMain();
            debugAgentBase.termAgentRunner();
            return;
        }
        catch (Exception exception) {
            System.out.println("AgentRunner=>Exception! " + this.agentClassName + ".class not found");
            return;
        }
    }
}

