/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.AgentSecurityManager;
import lotus.notes.JavaString;

public class AgentSecurityContext {
    private boolean m_restricted;
    private boolean m_file_read;
    private boolean m_file_write;
    private boolean m_net_access;
    private boolean m_class_loader;
    private boolean m_extern_exec;
    private boolean m_native_link;
    private boolean m_system_props;

    public AgentSecurityContext(ThreadGroup threadGroup, boolean bl) {
        this.m_restricted = bl;
        if (bl) {
            this.m_file_read = false;
            this.m_file_write = false;
            this.m_net_access = false;
            this.m_class_loader = false;
            this.m_extern_exec = false;
            this.m_native_link = false;
            this.m_system_props = false;
        } else {
            this.m_file_read = true;
            this.m_file_write = true;
            this.m_net_access = true;
            this.m_class_loader = true;
            this.m_extern_exec = true;
            this.m_native_link = true;
            this.m_system_props = true;
        }
        try {
            AgentSecurityManager agentSecurityManager = (AgentSecurityManager)System.getSecurityManager();
            if (agentSecurityManager != null) {
                agentSecurityManager.newSecurityContext(this, threadGroup);
                return;
            }
            throw new SecurityException(JavaString.getString("missing_security_manager"));
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    public final boolean readAllowed() {
        return this.m_file_read;
    }

    public final boolean writeAllowed() {
        return this.m_file_write;
    }

    public final boolean netAllowed() {
        return this.m_net_access;
    }

    public final boolean classLoaderAllowed() {
        return this.m_class_loader;
    }

    public final boolean execAllowed() {
        return this.m_extern_exec;
    }

    public final boolean linkAllowed() {
        return this.m_native_link;
    }

    public final boolean propAllowed() {
        return this.m_system_props;
    }
}

