/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.util.Hashtable;
import lotus.notes.AgentSecurityContext;
import lotus.notes.AgentThreadGroup;
import lotus.notes.JavaString;
import lotus.notes.SecurityContextException;

public class AgentSecurityManager
extends SecurityManager {
    private Hashtable ctx = new Hashtable();
    private Hashtable propkeys;
    private ThreadGroup utg;

    public AgentSecurityManager() {
        this.fillPropKeys();
        this.utg = Thread.currentThread().getThreadGroup();
        System.setSecurityManager(this);
        AgentSecurityContext agentSecurityContext = new AgentSecurityContext(this.utg, false);
        agentSecurityContext = new AgentSecurityContext(this.utg.getParent(), false);
    }

    public void checkAccept(String string, int n) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException(String.valueOf(string) + "," + n);
                }
            } else {
                throw new SecurityException(String.valueOf(string) + "," + n);
            }
        }
    }

    public void checkAccess(Thread thread) {
        if (this.classLoaderDepth() == 3) {
            if (thread != null) {
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.checkRelatedThreadGroup(threadGroup);
                return;
            }
            throw new NullPointerException();
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (this.classLoaderDepth() == 3) {
            this.checkRelatedThreadGroup(threadGroup);
        }
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkConnect(String string, int n) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException(String.valueOf(string) + "," + n);
                }
            } else {
                throw new SecurityException(String.valueOf(string) + "," + n);
            }
        }
    }

    public void checkConnect(String string, int n, Object object) {
        AgentSecurityContext agentSecurityContext = null;
        if (this.inClassLoader()) {
            try {
                agentSecurityContext = (AgentSecurityContext)object;
            }
            catch (ClassCastException classCastException) {}
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException(String.valueOf(string) + "," + n + "," + object.toString());
                }
            } else {
                throw new SecurityException(String.valueOf(string) + "," + n + "," + object.toString());
            }
        }
    }

    public void checkCreateClassLoader() {
        if (this.classLoaderDepth() == 2) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.classLoaderAllowed()) {
                    throw new SecurityException();
                }
            } else {
                throw new SecurityException();
            }
        }
    }

    public void checkDelete(String string) {
        if (this.classLoaderDepth() == 2) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.writeAllowed()) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public void checkExec(String string) {
        int n = this.classLoaderDepth();
        if (n == 2 || n == 3) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.execAllowed()) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public void checkExit(int n) {
        throw new SecurityException();
    }

    public void checkLink(String string) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
                if (agentSecurityContext != null) {
                    if (agentSecurityContext.linkAllowed()) break;
                    throw new SecurityException(string);
                }
                throw new SecurityException(string);
            }
        }
    }

    public void checkListen(int n) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException(String.valueOf(n));
                }
            } else {
                throw new SecurityException(String.valueOf(n));
            }
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
            throw new SecurityException(clazz.toString());
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException(inetAddress.toString());
                }
            } else {
                throw new SecurityException(inetAddress.toString());
            }
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.netAllowed()) {
                    throw new SecurityException();
                }
            } else {
                throw new SecurityException();
            }
        }
    }

    public void checkPackageAccess(String string) {
    }

    public void checkPackageDefinition(String string) {
        if (string.startsWith("lotus.notes")) {
            throw new SecurityException();
        }
    }

    public void checkPrintJobAccess() {
    }

    public void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new SecurityException();
        }
    }

    public void checkPropertyAccess(String string) {
        if (this.classLoaderDepth() == 2) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.propAllowed() && this.propkeys.get(string) == null) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.readAllowed() && !this.inClass("java.net.SocketInputStream")) {
                    throw new SecurityException(fileDescriptor.toString());
                }
            } else {
                throw new SecurityException();
            }
        }
    }

    public void checkRead(String string) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.readAllowed()) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public void checkRead(String string, Object object) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.readAllowed()) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public void checkSecurityAccess(String string) {
    }

    public void checkSetFactory() {
        AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
        if (agentSecurityContext != null) {
            if (!agentSecurityContext.netAllowed()) {
                throw new SecurityException();
            }
        } else {
            throw new SecurityException();
        }
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean checkTopLevelWindow(Object object) {
        return false;
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.writeAllowed() && !this.inClass("java.net.SocketInputStream")) {
                    throw new SecurityException(fileDescriptor.toString());
                }
            } else {
                throw new SecurityException(fileDescriptor.toString());
            }
        }
    }

    public void checkWrite(String string) {
        if (this.inClassLoader()) {
            AgentSecurityContext agentSecurityContext = (AgentSecurityContext)this.getSecurityContext();
            if (agentSecurityContext != null) {
                if (!agentSecurityContext.writeAllowed()) {
                    throw new SecurityException(string);
                }
            } else {
                throw new SecurityException(string);
            }
        }
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public Object getSecurityContext() {
        AgentSecurityContext agentSecurityContext = null;
        ThreadGroup threadGroup = this.getAgentThreadGroup();
        agentSecurityContext = (AgentSecurityContext)this.ctx.get(threadGroup);
        if (agentSecurityContext == null) {
            throw new SecurityContextException(threadGroup);
        }
        return agentSecurityContext;
    }

    private ThreadGroup getAgentThreadGroup() {
        return this.getAgentThreadGroup(Thread.currentThread().getThreadGroup());
    }

    /*
     * Unable to fully structure code
     */
    private ThreadGroup getAgentThreadGroup(ThreadGroup var1_1) {
        if (var1_1 != null) ** GOTO lbl4
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getParent();
lbl4:
            // 2 sources

            ** while (var1_1.getParent() != null && !(var1_1 instanceof AgentThreadGroup))
        }
lbl5:
        // 1 sources

        if (this.ctx.get(var1_1) == null) {
            throw new SecurityContextException(var1_1);
        }
        return var1_1;
    }

    private void checkRelatedThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        ThreadGroup threadGroup2 = this.getAgentThreadGroup();
        ThreadGroup threadGroup3 = this.getAgentThreadGroup(threadGroup);
        if (threadGroup2.getName().equals("system") || threadGroup3 == threadGroup2 && threadGroup3 != threadGroup) {
            return;
        }
        throw new SecurityException();
    }

    protected void newSecurityContext(AgentSecurityContext agentSecurityContext, ThreadGroup threadGroup) {
        AgentSecurityContext agentSecurityContext2 = (AgentSecurityContext)this.ctx.get(threadGroup);
        if (agentSecurityContext2 == null) {
            this.ctx.put(threadGroup, agentSecurityContext);
            return;
        }
        throw new SecurityException(JavaString.getString("security_exists"));
    }

    public void removeSecurityContext(ThreadGroup threadGroup) {
        Class<?>[] classArray = this.getClassContext();
        if (classArray.length >= 2 && classArray[1].getName().equals("lotus.domino.AgentLoader")) {
            this.ctx.remove(threadGroup);
            return;
        }
        throw new SecurityException(JavaString.getString("remove_security_context"));
    }

    private void fillPropKeys() {
        this.propkeys = new Hashtable();
        String string = "dummy";
        this.propkeys.put("awt.toolkit", string);
        this.propkeys.put("file.encoding", string);
        this.propkeys.put("file.encoding.pkg", string);
        this.propkeys.put("java.class.version", string);
        this.propkeys.put("java.vendor", string);
        this.propkeys.put("java.vendor.url", string);
        this.propkeys.put("java.version", string);
        this.propkeys.put("os.arch", string);
        this.propkeys.put("os.name", string);
        this.propkeys.put("os.version", string);
        this.propkeys.put("user.language", string);
        this.propkeys.put("user.timezone", string);
        this.propkeys.put("user.region", string);
        this.propkeys.put("lotus.notes.nativecreated", string);
    }
}

