/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

public final class AgentThreadGroup
extends ThreadGroup {
    private String agentName;
    private ThreadGroup userThreadGroup;
    private int activeNotesThreadCount;
    private int staticActiveNotesThreadCount;
    private Object m_ai;

    public AgentThreadGroup(String string, Object object) {
        super("ATG: " + string);
        this.agentName = string;
        this.userThreadGroup = new ThreadGroup(this, "UTG: " + string);
        this.m_ai = object;
    }

    public ThreadGroup getUserThreadGroup() {
        return this.userThreadGroup;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public int getActiveNotesThreadCount() {
        return this.activeNotesThreadCount;
    }

    public void bumpActiveNotesThreadCount(int n) {
        AgentThreadGroup agentThreadGroup = this;
        synchronized (agentThreadGroup) {
            this.activeNotesThreadCount += n;
            return;
        }
    }

    public int getStaticActiveNotesThreadCount() {
        return this.staticActiveNotesThreadCount;
    }

    public void bumpStaticActiveNotesThreadCount(int n) {
        AgentThreadGroup agentThreadGroup = this;
        synchronized (agentThreadGroup) {
            this.staticActiveNotesThreadCount += n;
            return;
        }
    }

    public Object getAgentInfo() {
        return this.m_ai;
    }
}

