/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;
import lotus.notes.Session;

public class DbDirectory
extends NotesBase {
    private transient Session session;
    public static final int REPLICA_CANDIDATE = 1245;
    public static final int TEMPLATE_CANDIDATE = 1246;
    public static final int DATABASE = 1247;
    public static final int TEMPLATE = 1248;

    private native int NgetFirstDatabase(int var1);

    private native int NgetNextDatabase();

    private native int NcreateDatabase(String var1, boolean var2);

    private native int NopenDatabase(String var1, boolean var2);

    private native int NopenDatabaseIfModified(String var1, DateTime var2);

    private static synchronized native int NopenMailDatabase(Session var0);

    private native int NopenDatabaseByReplicaID(String var1);

    protected DbDirectory() throws NotesException {
    }

    protected DbDirectory(Session session, int n) throws NotesException {
        super(n, 10);
        if (session == null) {
            throw new NotesException(JavaString.getString("missing_session_object"));
        }
        this.session = session;
        session.AddObject(this);
    }

    protected DbDirectory(Session session, int n, String string) throws NotesException {
        super(n, 10);
        if (session == null) {
            throw new NotesException(JavaString.getString("missing_session_object"));
        }
        this.session = session;
        session.AddObject(this);
    }

    protected void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.session.RemoveObject(this);
        this.InternalFinalize();
    }

    public void recycle() throws NotesException {
        try {
            try {
                this.session.RemoveObject(this);
            }
            catch (NotesException notesException) {
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.Recycle();
            throw throwable;
        }
        super.Recycle();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public Database getFirstDatabase(int n) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NgetFirstDatabase(n));
            Object var4_4 = null;
            return database;
        }
    }

    public Database getNextDatabase() throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NgetNextDatabase());
            Object var3_3 = null;
            return database;
        }
    }

    public Database createDatabase(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.createDatabase(string, true);
            Object var4_4 = null;
            return database;
        }
    }

    public Database createDatabase(String string, boolean bl) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NcreateDatabase(string, bl));
            Object var5_5 = null;
            return database;
        }
    }

    public Database openDatabase(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.openDatabase(string, false);
            Object var4_4 = null;
            return database;
        }
    }

    public Database openDatabase(String string, boolean bl) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NopenDatabase(string, bl));
            Object var5_5 = null;
            return database;
        }
    }

    public Database openDatabaseIfModified(String string, DateTime dateTime) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NopenDatabaseIfModified(string, dateTime));
            Object var5_5 = null;
            return database;
        }
    }

    public static Database openMailDatabase(Session session) throws NotesException {
        return session.FindOrCreateDatabase(DbDirectory.NopenMailDatabase(session));
    }

    public Database openDatabaseByReplicaID(String string) throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            Database database = this.session.FindOrCreateDatabase(this.NopenDatabaseByReplicaID(string));
            Object var4_4 = null;
            return database;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        DbDirectory dbDirectory = this;
        synchronized (dbDirectory) {
            String string = this.PropGetString(1240);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }
}

