/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.io.IOException;
import java.util.Vector;
import lotus.notes.Agent;
import lotus.notes.AgentContext;
import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.DebugDocumentCollection;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.Name;
import lotus.notes.NotesException;
import lotus.notes.Session;

public class DebugAgentContext
extends AgentContext {
    private Session s;
    private static String srchItem = "JavaAgentDebugSearchMarker";
    private static String srchValue = "JavaAgentDebugSearchMark";
    private static String srchFormula = "@IsAvailable(" + srchItem + ")";
    private static String srchQuery = "FIELD " + srchItem + " contains " + srchValue;
    private Database CurrentDatabase;
    private Agent CurrentAgent;
    private Document DocumentContext;
    private String EffectiveUserName;
    private int LastExitStatus;
    private DateTime LastRun;
    private Document SavedData;
    private DebugDocumentCollection UnprocessedDocuments;

    protected DebugAgentContext(Session session, AgentContext agentContext, Document document) throws NotesException, IOException, ClassNotFoundException {
        super(session, 1);
        this.CurrentDatabase = agentContext.getCurrentDatabase();
        document.appendItemValue("CurrentDatabase_FilePath", this.CurrentDatabase.getFilePath());
        Name name = session.createName(this.CurrentDatabase.getServer());
        document.appendItemValue("CurrentDatabase_Server", name.getAbbreviated());
        this.CurrentAgent = agentContext.getCurrentAgent();
        document.appendItemValue("CurrentAgent", this.CurrentAgent.getName());
        this.DocumentContext = agentContext.getDocumentContext();
        document.appendItemValue("DocumentContext", this.DocumentContext == null ? null : this.DocumentContext.getUniversalID());
        Name name2 = session.createName(agentContext.getEffectiveUserName());
        document.appendItemValue("EffectiveUserName", name2.getAbbreviated());
        document.appendItemValue("LastExitStatus", agentContext.getLastExitStatus());
        DateTime dateTime = agentContext.getLastRun();
        if (dateTime != null) {
            document.appendItemValue("LastRun", dateTime);
        }
        this.SavedData = agentContext.getSavedData();
        document.appendItemValue("SavedData", this.SavedData == null ? null : this.SavedData.getUniversalID());
        DocumentCollection documentCollection = agentContext.getUnprocessedDocuments();
        Vector<String> vector = new Vector<String>(20, 10);
        int n = 1;
        while (n <= documentCollection.getCount()) {
            Document document2 = documentCollection.getNthDocument(n);
            vector.addElement(document2.getNoteID());
            ++n;
        }
        document.appendItemValue("SelectedDocs", vector);
    }

    protected DebugAgentContext(Session session, Document document) throws NotesException, IOException, ClassNotFoundException {
        super(session, 1);
        Object object;
        this.s = session;
        this.CurrentDatabase = session.getDatabase(document.getItemValueString("CurrentDatabase_Server"), document.getItemValueString("CurrentDatabase_FilePath"));
        if (this.CurrentDatabase == null) {
            throw new NotesException("Could not restore CurrentDatabase from AgentContext document");
        }
        this.CurrentAgent = null;
        String string = document.getItemValueString("CurrentAgent");
        Vector vector = this.CurrentDatabase.getAgents();
        int n = 0;
        while (n < vector.size()) {
            object = (Agent)vector.elementAt(n);
            if (string.equals(((Agent)object).getName())) {
                this.CurrentAgent = object;
                break;
            }
            ++n;
        }
        if (this.CurrentAgent == null) {
            throw new NotesException("Could not restore CurrentAgent from AgentContext document");
        }
        object = document.getItemValueString("DocumentContext");
        if (object == null) {
            this.DocumentContext = null;
        } else {
            try {
                this.DocumentContext = this.CurrentDatabase.getDocumentByUNID((String)object);
            }
            catch (Exception exception) {
                throw new NotesException("Invalid UNID (AgentContext document - DocumentContext)");
            }
        }
        String string2 = document.getItemValueString("EffectiveUserName");
        if (string2 == null) {
            throw new NotesException("Could not restore EffectiveUserName from AgentContext document");
        }
        Name name = session.createName(string2);
        this.EffectiveUserName = name.getCanonical();
        this.LastExitStatus = document.getItemValueInteger("LastExitStatus");
        Vector vector2 = document.getItemValue("LastRun");
        this.LastRun = vector2.isEmpty() ? null : (DateTime)vector2.firstElement();
        String string3 = document.getItemValueString("SavedData");
        if (string3 == null) {
            this.SavedData = null;
        } else {
            try {
                this.SavedData = this.CurrentDatabase.getDocumentByUNID(string3);
            }
            catch (Exception exception) {
                throw new NotesException("Invalid UNID (AgentContext document - SavedData)");
            }
        }
        this.UnprocessedDocuments = new DebugDocumentCollection(this.CurrentDatabase, document, srchItem, srchValue, srchFormula);
        if (this.UnprocessedDocuments == null) {
            throw new NotesException("Could not restore UnprocessedDocuments from AgentContext document");
        }
    }

    public Agent getCurrentAgent() throws NotesException {
        return this.CurrentAgent;
    }

    public Database getCurrentDatabase() throws NotesException {
        return this.CurrentDatabase;
    }

    public Document getDocumentContext() throws NotesException {
        return this.DocumentContext;
    }

    public String getEffectiveUserName() throws NotesException {
        return this.EffectiveUserName;
    }

    public int getLastExitStatus() throws NotesException {
        return this.LastExitStatus;
    }

    public DateTime getLastRun() throws NotesException {
        return this.LastRun;
    }

    public Document getSavedData() throws NotesException {
        return this.SavedData;
    }

    public DocumentCollection getUnprocessedDocuments() throws NotesException {
        return this.UnprocessedDocuments;
    }

    public String toString() {
        String string;
        try {
            string = this.getEffectiveUserName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public DocumentCollection unprocessedFTSearch(String string, int n) throws NotesException {
        if (string == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchQuery + ") AND (" + string + ")";
        DocumentCollection documentCollection = this.CurrentDatabase.FTSearch(string2, n);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public DocumentCollection unprocessedFTSearch(String string, int n, int n2, int n3) throws NotesException {
        if (string == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchQuery + ") AND (" + string + ")";
        DocumentCollection documentCollection = this.CurrentDatabase.FTSearch(string2, n, n2, n3);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public DocumentCollection unprocessedSearch(String string, DateTime dateTime, int n) throws NotesException {
        if (string == null || dateTime == null || this.UnprocessedDocuments == null) {
            return null;
        }
        this.UnprocessedDocuments.stampAll(srchItem, srchValue);
        String string2 = "(" + srchFormula + ") & (" + string + ")";
        DocumentCollection documentCollection = this.CurrentDatabase.search(string2, dateTime, n);
        this.UnprocessedDocuments.unstampAll(srchItem);
        return documentCollection;
    }

    public void updateProcessedDoc(Document document) throws NotesException {
        this.UnprocessedDocuments.updateProcessedDoc(document);
    }
}

