/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Vector;
import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.Item;
import lotus.notes.NotesException;
import lotus.notes.Session;
import lotus.notes.View;

public class DebugDocumentCollection
extends DocumentCollection {
    private Document docAgentContext;
    private String srchItem;
    private String srchValue;
    private String srchFormula;
    private Vector selectedDocs = new Vector(20, 10);
    private Vector processedDocs = new Vector(20, 10);
    private Vector processedDateTimes = new Vector(20, 10);
    private boolean processedDocsInContext = false;
    private Vector unprocessedDocs = new Vector(20, 10);
    private boolean IsSorted;
    private Database Parent;
    private String Query;

    protected DebugDocumentCollection(Database database, Document document, String string, String string2, String string3) throws NotesException {
        super(database, 1);
        this.docAgentContext = document;
        this.srchItem = string;
        this.srchValue = string2;
        this.srchFormula = string3;
        this.selectedDocs = document.getItemValue("SelectedDocs");
        this.processedDocs = document.getItemValue("ProcessedDocs");
        this.processedDateTimes = document.getItemValue("ProcessedDateTimes");
        this.Parent = database;
        this.Query = null;
        Vector<String> vector = new Vector<String>(20, 10);
        String string4 = document.getItemValueString("AgentRunsOn");
        switch (string4.charAt(0)) {
            case '0': {
                DocumentCollection documentCollection = database.getAllDocuments();
                String string5 = document.getItemValueString("AgentSearchCriteria");
                if (string5 != null) {
                    documentCollection.FTSearch(document.getItemValueString("AgentSearchCriteria"), 0);
                }
                int n = 1;
                while (n <= documentCollection.getCount()) {
                    Document document2 = documentCollection.getNthDocument(n);
                    vector.addElement(document2.getNoteID());
                    ++n;
                }
                this.unprocessedDocs = vector;
                this.IsSorted = documentCollection.isSorted();
                return;
            }
            case '1': {
                Object object;
                this.processedDocsInContext = true;
                int n = 0;
                int n2 = this.processedDocs.size();
                while (n < n2) {
                    object = this.processedDateTimes.isEmpty() ? null : (DateTime)this.processedDateTimes.elementAt(n);
                    Document document3 = database.getDocumentByID((String)this.processedDocs.elementAt(n));
                    if (document3 == null || ((DateTime)object).timeDifference(document3.getLastModified()) < 0) {
                        this.processedDocs.removeElementAt(n);
                        this.processedDateTimes.removeElementAt(n);
                    } else {
                        ++n;
                    }
                    n2 = this.processedDocs.size();
                }
                DocumentCollection documentCollection = database.getAllDocuments();
                object = document.getItemValueString("AgentSearchCriteria");
                if (object != null) {
                    documentCollection.FTSearch(document.getItemValueString("AgentSearchCriteria"), 0);
                }
                int n3 = 1;
                while (n3 <= documentCollection.getCount()) {
                    Document document4 = documentCollection.getNthDocument(n3);
                    String string6 = document4.getNoteID();
                    if (!this.processedDocs.contains(string6)) {
                        vector.addElement(string6);
                    }
                    ++n3;
                }
                this.unprocessedDocs = vector;
                this.IsSorted = documentCollection.isSorted();
                this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
                while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
                    this.docAgentContext.removeItem("ProcessedDateTimes");
                }
                this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
                this.docAgentContext.save();
                return;
            }
            case '2': {
                String string7 = document.getItemValueString("AgentRunsOnView");
                View view = database.getView(string7);
                String string8 = document.getItemValueString("AgentSearchCriteria");
                if (string8 != null) {
                    view.FTSearch(string8, 0);
                }
                Document document5 = view.getFirstDocument();
                while (document5 != null) {
                    String string9 = document5.getNoteID();
                    if (this.selectedDocs.contains(string9)) {
                        vector.addElement(string9);
                    }
                    document5 = view.getNextDocument(document5);
                }
                this.unprocessedDocs = vector;
                this.IsSorted = false;
                return;
            }
            case '3': {
                String string10 = document.getItemValueString("AgentRunsOnView");
                View view = database.getView(string10);
                String string11 = document.getItemValueString("AgentSearchCriteria");
                if (string11 != null) {
                    view.FTSearch(string11, 0);
                }
                Document document6 = view.getFirstDocument();
                while (document6 != null) {
                    vector.addElement(document6.getNoteID());
                    document6 = view.getNextDocument(document6);
                }
                this.unprocessedDocs = vector;
                this.IsSorted = false;
                return;
            }
            case '4': {
                this.IsSorted = false;
                this.unprocessedDocs = document.getItemValue("SelectedDocs");
                String string12 = document.getItemValueString("AgentSearchCriteria");
                if (string12 == null) break;
                this.stampAll(this.srchItem, this.srchValue);
                DocumentCollection documentCollection = database.search(this.srchFormula);
                this.unstampAll(this.srchItem);
                documentCollection.FTSearch(string12, 0);
                this.unprocessedDocs.removeAllElements();
                int n = 1;
                while (n <= documentCollection.getCount()) {
                    Document document7 = documentCollection.getNthDocument(n);
                    this.unprocessedDocs.addElement(document7.getNoteID());
                    ++n;
                }
                this.IsSorted = documentCollection.isSorted();
                return;
            }
            case '5': {
                String string13 = document.getItemValueString("DocumentContext");
                Document document8 = database.getDocumentByUNID(string13);
                if (document8 != null) {
                    vector.addElement(document8.getNoteID());
                }
                this.unprocessedDocs = vector;
                this.IsSorted = false;
                return;
            }
            default: {
                throw new NotesException("Exception: undefined AgentContext state");
            }
        }
    }

    public int getCount() throws NotesException {
        return this.unprocessedDocs.size();
    }

    public boolean isSorted() throws NotesException {
        return this.IsSorted;
    }

    public Database getParent() throws NotesException {
        return this.Parent;
    }

    public String getQuery() throws NotesException {
        return this.Query;
    }

    public void FTSearch(String string, int n) throws NotesException {
        if (string == null || this.unprocessedDocs.size() < 1) {
            return;
        }
        this.stampAll(this.srchItem, this.srchValue);
        DocumentCollection documentCollection = this.Parent.search(this.srchFormula);
        this.unstampAll(this.srchItem);
        documentCollection.FTSearch(string, n);
        this.unprocessedDocs.removeAllElements();
        int n2 = 1;
        while (n2 <= documentCollection.getCount()) {
            Document document = documentCollection.getNthDocument(n2);
            this.unprocessedDocs.addElement(document.getNoteID());
            ++n2;
        }
        this.IsSorted = documentCollection.isSorted();
        this.Query = documentCollection.getQuery();
    }

    public Document getFirstDocument() throws NotesException {
        if (this.unprocessedDocs.size() >= 1) {
            return this.Parent.getDocumentByID((String)this.unprocessedDocs.firstElement());
        }
        return null;
    }

    public Document getLastDocument() throws NotesException {
        if (this.unprocessedDocs.size() >= 1) {
            return this.Parent.getDocumentByID((String)this.unprocessedDocs.lastElement());
        }
        return null;
    }

    public Document getNextDocument(Document document) throws NotesException {
        if (document == null) {
            return null;
        }
        String string = document.getNoteID();
        int n = 0;
        while (n < this.unprocessedDocs.size() - 1) {
            if (string.equals(this.unprocessedDocs.elementAt(n))) {
                return this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n + 1));
            }
            ++n;
        }
        return null;
    }

    public Document getNthDocument(int n) throws NotesException {
        int n2 = n - 1;
        if (n2 >= 0 && n2 < this.unprocessedDocs.size()) {
            return this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n2));
        }
        return null;
    }

    public Document getPrevDocument(Document document) throws NotesException {
        if (document == null) {
            return null;
        }
        String string = document.getNoteID();
        int n = this.unprocessedDocs.size() - 1;
        while (n > 0) {
            if (string.equals(this.unprocessedDocs.elementAt(n))) {
                return this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n - 1));
            }
            --n;
        }
        return null;
    }

    public void putAllInFolder(String string) throws NotesException {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.unprocessedDocs.size()) {
            Document document = this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n));
            document.putInFolder(string);
            ++n;
        }
    }

    public void removeAll(boolean bl) throws NotesException {
        String string = this.docAgentContext.getItemValueString("DocumentContext");
        boolean bl2 = false;
        int n = 0;
        int n2 = this.unprocessedDocs.size();
        while (n < n2) {
            Document document = this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n));
            if (document.getUniversalID() == string) {
                bl2 = true;
            }
            if (document.remove(bl)) {
                this.selectedDocs.removeElement((String)this.unprocessedDocs.elementAt(n));
                int n3 = this.processedDocs.indexOf((String)this.unprocessedDocs.elementAt(n));
                this.processedDocs.removeElementAt(n3);
                this.processedDateTimes.removeElementAt(n3);
                this.unprocessedDocs.removeElementAt(n);
                if (bl2) {
                    bl2 = false;
                    this.docAgentContext.replaceItemValue("DocumentContext", "");
                    this.docAgentContext.save();
                }
            } else {
                ++n;
            }
            n2 = this.unprocessedDocs.size();
        }
        this.docAgentContext.replaceItemValue("SelectedDocs", this.selectedDocs);
        this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
        while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
            this.docAgentContext.removeItem("ProcessedDateTimes");
        }
        this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
        this.docAgentContext.save();
    }

    public void removeAllFromFolder(String string) throws NotesException {
        if (string == null) {
            return;
        }
        View view = this.Parent.getView(string);
        if (view == null) {
            return;
        }
        int n = 0;
        while (n < this.unprocessedDocs.size()) {
            Document document = this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n));
            document.removeFromFolder(string);
            ++n;
        }
    }

    public void stampAll(String string, Object object) throws NotesException {
        if (string == null || object == null) {
            return;
        }
        int n = 0;
        while (n < this.unprocessedDocs.size()) {
            Class<?> clazz = object.getClass();
            boolean bl = clazz.getName() != "lotus.notes.RichTextItem";
            Document document = this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n));
            Item item = document.getFirstItem(string);
            bl = bl && (item == null || item.isSummary());
            item = document.replaceItemValue(string, object);
            item.setSummary(bl);
            document.save();
            ++n;
        }
    }

    public void updateAll() throws NotesException {
        if (this.processedDocsInContext) {
            int n = 0;
            while (n < this.unprocessedDocs.size()) {
                if (!this.processedDocs.contains(this.unprocessedDocs.elementAt(n))) {
                    this.processedDocs.addElement(this.unprocessedDocs.elementAt(n));
                    Session session = this.Parent.getParent();
                    DateTime dateTime = session.createDateTime("");
                    dateTime.setNow();
                    this.processedDateTimes.addElement(dateTime);
                }
                ++n;
            }
            this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
            while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
                this.docAgentContext.removeItem("ProcessedDateTimes");
            }
            this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
            this.docAgentContext.save();
        }
    }

    public void recycle() throws NotesException {
    }

    void updateProcessedDoc(Document document) throws NotesException {
        if (document == null) {
            return;
        }
        if (this.processedDocsInContext) {
            String string = document.getNoteID();
            if (!this.processedDocs.contains(string)) {
                this.processedDocs.addElement(string);
                Session session = this.Parent.getParent();
                DateTime dateTime = session.createDateTime("");
                dateTime.setNow();
                this.processedDateTimes.addElement(dateTime);
            }
            this.docAgentContext.replaceItemValue("ProcessedDocs", this.processedDocs);
            while (this.docAgentContext.hasItem("ProcessedDateTimes")) {
                this.docAgentContext.removeItem("ProcessedDateTimes");
            }
            this.docAgentContext.appendItemValue("ProcessedDateTimes", this.processedDateTimes);
            this.docAgentContext.save();
        }
    }

    void unstampAll(String string) throws NotesException {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.unprocessedDocs.size()) {
            Document document = this.Parent.getDocumentByID((String)this.unprocessedDocs.elementAt(n));
            document.removeItem(string);
            document.save();
            ++n;
        }
    }
}

