/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Vector;
import lotus.notes.AgentContext;
import lotus.notes.Database;
import lotus.notes.DateRange;
import lotus.notes.DateTime;
import lotus.notes.DbDirectory;
import lotus.notes.DebugAgentContext;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.International;
import lotus.notes.Log;
import lotus.notes.Name;
import lotus.notes.Newsletter;
import lotus.notes.NotesException;
import lotus.notes.Registration;
import lotus.notes.RichTextStyle;
import lotus.notes.Session;
import lotus.notes.View;

public class DebugSession
extends Session {
    private static String dumpAgentContextFile = "AgentRunner.nsf";
    private Session s;
    private String keySrv;
    private String keyDb;
    private String keyAgent;
    private Document doc;

    public DebugSession(AgentContext agentContext, String string) throws NotesException {
        super(1);
        this.dumpAgentContext(Session.newInstance(), agentContext, string);
    }

    public DebugSession(String string, String string2, String string3) throws NotesException {
        super(1);
        this.s = Session.newInstance();
        this.keySrv = string;
        this.keyDb = string2;
        this.keyAgent = string3;
    }

    public Vector getAddressBooks() throws NotesException {
        return this.s.getAddressBooks();
    }

    public AgentContext getAgentContext() throws NotesException {
        DebugAgentContext debugAgentContext;
        try {
            Database database = this.s.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                throw new NotesException("AgentContext database not found");
            }
            View view = database.getView("($AgentContexts)");
            if (view == null) {
                throw new NotesException("AgentContext view not found");
            }
            Vector<String> vector = new Vector<String>(2, 0);
            vector.addElement(String.valueOf(this.keySrv == "" || this.keySrv == "\u0000" ? "Local" : this.keySrv) + "!!" + this.keyDb);
            vector.addElement(this.keyAgent);
            this.doc = view.getDocumentByKey(vector, true);
            if (this.doc == null) {
                throw new NotesException("AgentContext document not found");
            }
            debugAgentContext = new DebugAgentContext(this.s, this.doc);
        }
        catch (Exception exception) {
            debugAgentContext = null;
            System.out.println(exception.getMessage());
        }
        return debugAgentContext;
    }

    public String getCommonUserName() throws NotesException {
        return this.s.getCommonUserName();
    }

    public International getInternational() throws NotesException {
        return this.s.getInternational();
    }

    public boolean isOnServer() throws NotesException {
        return this.s.isOnServer();
    }

    public String getNotesVersion() throws NotesException {
        return this.s.getNotesVersion();
    }

    public String getPlatform() throws NotesException {
        return this.s.getPlatform();
    }

    public String getUserName() throws NotesException {
        return this.s.getUserName();
    }

    public Name getUserNameObject() throws NotesException {
        return this.s.getUserNameObject();
    }

    public String toString() {
        return this.s.toString();
    }

    public DateRange createDateRange() throws NotesException {
        return this.s.createDateRange();
    }

    public DateRange createDateRange(DateTime dateTime, DateTime dateTime2) throws NotesException {
        return this.s.createDateRange(dateTime, dateTime2);
    }

    public DateTime createDateTime(String string) throws NotesException {
        return this.s.createDateTime(string);
    }

    public Log createLog(String string) throws NotesException {
        return this.s.createLog(string);
    }

    public Name createName(String string) throws NotesException {
        return this.s.createName(string);
    }

    public Newsletter createNewsletter(DocumentCollection documentCollection) throws NotesException {
        return this.s.createNewsletter(documentCollection);
    }

    public Registration createRegistration() throws NotesException {
        return this.s.createRegistration();
    }

    public RichTextStyle createRichTextStyle() throws NotesException {
        return this.s.createRichTextStyle();
    }

    public Vector evaluate(String string) throws NotesException {
        return this.s.evaluate(string);
    }

    public Vector evaluate(String string, Document document) throws NotesException {
        return this.s.evaluate(string, document);
    }

    public Vector freeTimeSearch(DateRange dateRange, int n, Object object, boolean bl) throws NotesException {
        return this.s.freeTimeSearch(dateRange, n, object, bl);
    }

    public Database getDatabase(String string, String string2) throws NotesException {
        return this.s.getDatabase(string, string2);
    }

    public DbDirectory getDbDirectory(String string) throws NotesException {
        return this.s.getDbDirectory(string);
    }

    public String getEnvironmentString(String string) throws NotesException {
        return this.s.getEnvironmentString(string);
    }

    public String getEnvironmentString(String string, boolean bl) throws NotesException {
        return this.s.getEnvironmentString(string, bl);
    }

    public Object getEnvironmentValue(String string) throws NotesException {
        return this.s.getEnvironmentValue(string);
    }

    public Object getEnvironmentValue(String string, boolean bl) throws NotesException {
        return this.s.getEnvironmentValue(string, bl);
    }

    public Database getURLDatabase() throws NotesException {
        return this.s.getURLDatabase();
    }

    public void setEnvironmentVar(String string, Object object) throws NotesException {
        this.s.setEnvironmentVar(string, object);
    }

    public void setEnvironmentVar(String string, Object object, boolean bl) throws NotesException {
        this.s.setEnvironmentVar(string, object, bl);
    }

    private void dumpAgentContext(Session session, AgentContext agentContext, String string) throws NotesException {
        try {
            Database database = session.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                throw new NotesException("AgentContext database not found");
            }
            this.doc = database.createDocument();
            this.doc.appendItemValue("Form", "AgentContext");
            this.doc.appendItemValue("ClassName", string);
            new DebugAgentContext(session, agentContext, this.doc);
            this.doc.save();
            this.doc.computeWithForm(false, false);
            this.doc.save();
            System.out.println("AgentContext dumped to file " + dumpAgentContextFile);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void stampAgentContextDoc() throws NotesException {
        try {
            DateTime dateTime = this.s.createDateTime("");
            dateTime.setNow();
            this.doc.removeItem("LastRun");
            this.doc.appendItemValue("LastRun", dateTime);
            this.doc.save();
            String string = this.doc.getItemValueString("CurrentDatabase_Server");
            if (string == null) {
                string = "Local";
            }
            string = String.valueOf(this.doc.getItemValueString("CurrentDatabase_FilePath")) + " " + string;
            string = String.valueOf(this.doc.getItemValueString("CurrentAgent")) + " " + string;
            System.out.println("AgentContext dumped to file " + dumpAgentContextFile + " for agent:");
            System.out.println("\t" + string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

