/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import lotus.notes.Database;
import lotus.notes.Document;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;

public class DocumentCollection
extends NotesBase {
    private transient Database database;

    private native int NgetFirstDocument();

    private native int NgetLastDocument();

    private native int NgetNextDocument(Document var1);

    private native int NgetPrevDocument(Document var1);

    private native int NgetNthDocument(int var1);

    private native void NFTSearch(String var1, int var2);

    private native void NremoveAll(boolean var1);

    private native void NupdateAll();

    private native void NstampAll(String var1, Object var2);

    private native void NputAllInFolder(String var1);

    private native void NremoveAllFromFolder(String var1);

    protected DocumentCollection() throws NotesException {
    }

    protected DocumentCollection(Database database, int n) throws NotesException {
        super(n, 11);
        if (database == null) {
            throw new NotesException(JavaString.getString("missing_db_object"));
        }
        this.database = database;
        database.AddObject(this);
    }

    protected void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    public void recycle() throws NotesException {
        try {
            try {
                this.database.RemoveObject(this);
            }
            catch (NotesException notesException) {
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.Recycle();
            throw throwable;
        }
        super.Recycle();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public Document getFirstDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetFirstDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public Document getLastDocument() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetLastDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public Document getNextDocument(Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextDocument(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getPrevDocument(Document document) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevDocument(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getNthDocument(int n) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.database.FindOrCreateDocument(this.NgetNthDocument(n));
            Object var4_4 = null;
            return document;
        }
    }

    public void FTSearch(String string, int n) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NFTSearch(string, n);
            return;
        }
    }

    public void removeAll(boolean bl) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            Document document = this.getFirstDocument();
            while (document != null) {
                Document document2 = this.getNextDocument(document);
                document.finalize();
                document = document2;
            }
            this.NremoveAll(bl);
            return;
        }
    }

    public void updateAll() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NupdateAll();
            return;
        }
    }

    public void stampAll(String string, Object object) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NstampAll(string, object);
            return;
        }
    }

    public void putAllInFolder(String string) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NputAllInFolder(string);
            return;
        }
    }

    public void removeAllFromFolder(String string) throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            this.NremoveAllFromFolder(string);
            return;
        }
    }

    public int getCount() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            int n = this.PropGetInt(1330);
            Object var3_3 = null;
            return n;
        }
    }

    public boolean isSorted() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            boolean bl = this.PropGetBool(1331);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getQuery() throws NotesException {
        this.CheckObject();
        DocumentCollection documentCollection = this;
        synchronized (documentCollection) {
            String string = this.PropGetString(1332);
            Object var3_3 = null;
            return string;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }
}

