/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Vector;
import lotus.notes.Database;
import lotus.notes.Document;
import lotus.notes.EmbeddedObject;
import lotus.notes.Item;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;
import lotus.notes.RichTextStyle;
import lotus.notes.View;

public class RichTextItem
extends Item {
    public static final int EMBED_OBJECTLINK = 1452;
    public static final int EMBED_OBJECT = 1453;
    public static final int EMBED_ATTACHMENT = 1454;

    private native void NaddNewLine(int var1, boolean var2);

    private native void NaddTab(int var1);

    private native void NappendDocLink(NotesBase var1, String var2);

    private native void NappendRTItem(RichTextItem var1);

    private native void NappendText(String var1);

    private native String NgetFormattedText(boolean var1, int var2, int var3);

    private native int NgetEmbeddedObject(String var1);

    private native int NembedObject(int var1, String var2, String var3, String var4);

    private native void NappendStyle(RichTextStyle var1);

    protected RichTextItem() throws NotesException {
    }

    protected RichTextItem(Document document, int n) throws NotesException {
        super(n, 6);
        if (document == null) {
            throw new NotesException(JavaString.getString("missing_document_object"));
        }
        this.parent = document;
        this.parent.AddItem(this);
    }

    public void finalize() throws NotesException {
        super.finalize();
    }

    public void recycle() throws NotesException {
        super.Recycle();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public void addNewLine(int n, boolean bl) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NaddNewLine(n, bl);
            return;
        }
    }

    public void addNewLine(int n) throws NotesException {
        this.addNewLine(n, true);
    }

    public void addNewLine() throws NotesException {
        this.addNewLine(1, true);
    }

    public void addTab(int n) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NaddTab(n);
            return;
        }
    }

    public void addTab() throws NotesException {
        this.addTab(1);
    }

    public void appendDocLink(Document document, String string) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NappendDocLink(document, string);
            return;
        }
    }

    public void appendDocLink(Document document) throws NotesException {
        this.appendDocLink(document, null);
    }

    public void appendDocLink(Database database, String string) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NappendDocLink(database, string);
            return;
        }
    }

    public void appendDocLink(Database database) throws NotesException {
        this.appendDocLink(database, null);
    }

    public void appendDocLink(View view, String string) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NappendDocLink(view, string);
            return;
        }
    }

    public void appendDocLink(View view) throws NotesException {
        this.appendDocLink(view, null);
    }

    public void appendRTItem(RichTextItem richTextItem) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem2 = this;
        synchronized (richTextItem2) {
            this.NappendRTItem(richTextItem);
            return;
        }
    }

    public void appendStyle(RichTextStyle richTextStyle) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NappendStyle(richTextStyle);
            return;
        }
    }

    public void appendText(String string) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            this.NappendText(string);
            return;
        }
    }

    public String getFormattedText(boolean bl, int n, int n2) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            String string = this.NgetFormattedText(bl, n, n2);
            Object var6_6 = null;
            return string;
        }
    }

    public EmbeddedObject getEmbeddedObject(String string) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            EmbeddedObject embeddedObject = this.parent.FindOrCreateEmbedded(this.NgetEmbeddedObject(string));
            Object var4_4 = null;
            return embeddedObject;
        }
    }

    public EmbeddedObject embedObject(int n, String string, String string2, String string3) throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            EmbeddedObject embeddedObject = this.parent.FindOrCreateEmbedded(this.NembedObject(n, string, string2, string3));
            Object var7_7 = null;
            return embeddedObject;
        }
    }

    public Vector getEmbeddedObjects() throws NotesException {
        this.CheckObject();
        RichTextItem richTextItem = this;
        synchronized (richTextItem) {
            int[] nArray = this.PropGetObjArray(1352);
            if (nArray == null || nArray.length == 0) {
                Vector vector = null;
                Object var3_5 = null;
                return vector;
            }
            Vector<EmbeddedObject> vector = new Vector<EmbeddedObject>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                EmbeddedObject embeddedObject = this.parent.FindOrCreateEmbedded(nArray[n]);
                vector.addElement(embeddedObject);
                ++n;
            }
            Vector<EmbeddedObject> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }
}

