/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Enumeration;
import java.util.Vector;
import lotus.notes.AgentContext;
import lotus.notes.Database;
import lotus.notes.DateRange;
import lotus.notes.DateTime;
import lotus.notes.DbDirectory;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.International;
import lotus.notes.Log;
import lotus.notes.Name;
import lotus.notes.Newsletter;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;
import lotus.notes.Registration;
import lotus.notes.RichTextStyle;

public class Session
extends NotesBase {
    private transient Vector dblist = new Vector(3, 3);
    private transient Vector objlist = new Vector(3, 3);
    private transient AgentContext agentcontext;
    protected transient int context_cookie;
    private static transient int counter;
    protected static Vector sessions;

    private static native int NCreateSession(int var0);

    private native Vector NEvaluate(String var1, Document var2);

    private native String NgetEnvironmentString(String var1, boolean var2);

    private native Object NgetEnvironmentValue(String var1, boolean var2);

    private native void NsetEnvironmentVar(String var1, Object var2, boolean var3);

    private native int[] NfreeTimeSearch(DateRange var1, int var2, Object var3, boolean var4);

    private native int NgetDbDirectory(String var1);

    private native int NgetDatabase(String var1, String var2);

    private native int NcreateDateTime(String var1);

    private native int NcreateLog(String var1);

    private native int NcreateNewsletter(DocumentCollection var1);

    private native int NcreateDateRange();

    private native int NcreateName(String var1);

    private native int NgetURLDatabase();

    private native void NendAgentContext();

    private native int NcreateRegistration();

    private native int NcreateRTStyle();

    public static Session newInstance() throws NotesException {
        try {
            int n = Session.NCreateSession(0);
            return Session.FindOrCreateSession(n, 0);
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Session newInstance(int n) throws NotesException {
        try {
            int n2 = Session.NCreateSession(n);
            return Session.FindOrCreateSession(n2, n);
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                throw (NotesException)exception;
            }
            exception.printStackTrace();
            return null;
        }
    }

    protected static synchronized Session FindOrCreateSession(int n, int n2) throws NotesException {
        if (sessions == null) {
            sessions = new Vector(3, 3);
        }
        Vector vector = sessions;
        synchronized (vector) {
            Enumeration enumeration = sessions.elements();
            while (enumeration.hasMoreElements()) {
                Session session = (Session)enumeration.nextElement();
                if (!session.isEqual(n) || session.context_cookie != n2) continue;
                session.CheckObject();
                Session session2 = session;
                Object var5_6 = null;
                return session2;
            }
        }
        return new Session(n, n2);
    }

    public synchronized void endAgentContext() {
        if (this.cpp_object > 0) {
            try {
                this.NendAgentContext();
                this.finalize();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    protected Session(int n) throws NotesException {
        super(n, 1);
        this.context_cookie = 0;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
            return;
        }
    }

    protected Session(int n, int n2) throws NotesException {
        super(n, 1);
        this.context_cookie = n2;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
            return;
        }
    }

    public void finalize() throws NotesException {
        Vector vector;
        block28: {
            try {
                Enumeration enumeration;
                vector = this.dblist;
                synchronized (vector) {
                    enumeration = this.dblist.elements();
                    while (enumeration.hasMoreElements()) {
                        Database database = (Database)enumeration.nextElement();
                        this.DestroyObject(database);
                        database.InternalFinalize();
                    }
                }
                vector = this.objlist;
                synchronized (vector) {
                    enumeration = this.objlist.elements();
                    while (enumeration.hasMoreElements()) {
                        NotesBase notesBase = (NotesBase)enumeration.nextElement();
                        this.DestroyObject(notesBase);
                        notesBase.InternalFinalize();
                    }
                }
                Object var4_6 = null;
                if (this.dblist == null) break block28;
                vector = this.dblist;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var4_7 = null;
                if (this.dblist != null) {
                    vector2 = this.dblist;
                    synchronized (vector2) {
                        this.dblist.removeAllElements();
                        this.dblist = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                vector2 = sessions;
                synchronized (vector2) {
                    sessions.removeElement(this);
                }
                this.cpp_object = 0;
                this.context_cookie = 0;
                super.finalize();
                throw throwable;
            }
            synchronized (vector) {
                this.dblist.removeAllElements();
                this.dblist = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        vector = sessions;
        synchronized (vector) {
            sessions.removeElement(this);
        }
        this.cpp_object = 0;
        this.context_cookie = 0;
        super.finalize();
    }

    protected void AddDatabase(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.dblist;
        synchronized (vector) {
            this.dblist.addElement(object);
            return;
        }
    }

    protected void RemoveDatabase(Object object) throws NotesException {
        if (this.dblist != null) {
            Vector vector = this.dblist;
            synchronized (vector) {
                this.dblist.removeElement(object);
                return;
            }
        }
    }

    protected void AddObject(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            this.objlist.addElement(object);
            return;
        }
    }

    protected void RemoveObject(Object object) throws NotesException {
        if (this.objlist != null) {
            Vector vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeElement(object);
                return;
            }
        }
    }

    protected DbDirectory FindOrCreateDbDirectory(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DbDirectory) || !notesBase.isEqual(n)) continue;
                DbDirectory dbDirectory = (DbDirectory)notesBase;
                Object var5_6 = null;
                return dbDirectory;
            }
        }
        return new DbDirectory(this, n);
    }

    protected Database FindOrCreateDatabase(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.dblist;
        synchronized (vector) {
            Enumeration enumeration = this.dblist.elements();
            while (enumeration.hasMoreElements()) {
                Database database = (Database)enumeration.nextElement();
                if (!database.isEqual(n)) continue;
                Database database2 = database;
                Object var5_6 = null;
                return database2;
            }
        }
        return new Database(this, n);
    }

    protected DateTime FindOrCreateDateTime(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DateTime) || !notesBase.isEqual(n)) continue;
                DateTime dateTime = (DateTime)notesBase;
                Object var5_6 = null;
                return dateTime;
            }
        }
        return new DateTime(this, n);
    }

    protected DateRange FindOrCreateDateRange(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DateRange) || !notesBase.isEqual(n)) continue;
                DateRange dateRange = (DateRange)notesBase;
                Object var5_6 = null;
                return dateRange;
            }
        }
        return new DateRange(this, n);
    }

    protected Log FindOrCreateLog(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Log) || !notesBase.isEqual(n)) continue;
                Log log = (Log)notesBase;
                Object var5_6 = null;
                return log;
            }
        }
        return new Log(this, n);
    }

    protected Newsletter FindOrCreateNewsletter(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Newsletter) || !notesBase.isEqual(n)) continue;
                Newsletter newsletter = (Newsletter)notesBase;
                Object var5_6 = null;
                return newsletter;
            }
        }
        return new Newsletter(this, n);
    }

    protected Name FindOrCreateName(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Name) || !notesBase.isEqual(n)) continue;
                Name name = (Name)notesBase;
                Object var5_6 = null;
                return name;
            }
        }
        return new Name(this, n);
    }

    protected RichTextStyle FindOrCreateRTStyle(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof RichTextStyle) || !notesBase.isEqual(n)) continue;
                RichTextStyle richTextStyle = (RichTextStyle)notesBase;
                Object var5_6 = null;
                return richTextStyle;
            }
        }
        return new RichTextStyle(this, n);
    }

    protected Registration FindOrCreateRegistration(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Registration) || !notesBase.isEqual(n)) continue;
                Registration registration = (Registration)notesBase;
                Object var5_6 = null;
                return registration;
            }
        }
        return new Registration(this, n);
    }

    protected NotesBase FindObject(int n) throws NotesException {
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!notesBase.isEqual(n)) continue;
                NotesBase notesBase2 = notesBase;
                Object var5_6 = null;
                return notesBase2;
            }
        }
        return null;
    }

    public Vector evaluate(String string) throws NotesException {
        this.CheckObject();
        return this.evaluate(string, null);
    }

    public Vector evaluate(String string, Document document) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Vector vector = this.NEvaluate(string, document);
            Object var5_5 = null;
            return vector;
        }
    }

    public Database getDatabase(String string, String string2) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Database database = this.FindOrCreateDatabase(this.NgetDatabase(string, string2));
            Object var5_5 = null;
            return database;
        }
    }

    public DateTime createDateTime(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            DateTime dateTime = this.FindOrCreateDateTime(this.NcreateDateTime(string));
            Object var4_4 = null;
            return dateTime;
        }
    }

    public Log createLog(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Log log = this.FindOrCreateLog(this.NcreateLog(string));
            Object var4_4 = null;
            return log;
        }
    }

    public Newsletter createNewsletter(DocumentCollection documentCollection) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Newsletter newsletter = this.FindOrCreateNewsletter(this.NcreateNewsletter(documentCollection));
            Object var4_4 = null;
            return newsletter;
        }
    }

    public DbDirectory getDbDirectory(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            DbDirectory dbDirectory = this.FindOrCreateDbDirectory(this.NgetDbDirectory(string));
            Object var4_4 = null;
            return dbDirectory;
        }
    }

    public DateRange createDateRange() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            DateRange dateRange = this.FindOrCreateDateRange(this.NcreateDateRange());
            Object var3_3 = null;
            return dateRange;
        }
    }

    public DateRange createDateRange(DateTime dateTime, DateTime dateTime2) throws NotesException {
        this.CheckObject();
        DateRange dateRange = this.createDateRange();
        dateRange.setStartDateTime(dateTime);
        dateRange.setEndDateTime(dateTime2);
        return dateRange;
    }

    public Name createName(String string) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Name name = this.FindOrCreateName(this.NcreateName(string));
            Object var4_4 = null;
            return name;
        }
    }

    public RichTextStyle createRichTextStyle() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            RichTextStyle richTextStyle = this.FindOrCreateRTStyle(this.NcreateRTStyle());
            Object var3_3 = null;
            return richTextStyle;
        }
    }

    public String getEnvironmentString(String string) throws NotesException {
        this.CheckObject();
        return this.getEnvironmentString(string, false);
    }

    public String getEnvironmentString(String string, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string2 = this.NgetEnvironmentString(string, bl);
            Object var5_5 = null;
            return string2;
        }
    }

    public Object getEnvironmentValue(String string) throws NotesException {
        this.CheckObject();
        return this.getEnvironmentValue(string, false);
    }

    public Object getEnvironmentValue(String string, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Object object = this.NgetEnvironmentValue(string, bl);
            Object var5_5 = null;
            return object;
        }
    }

    public void setEnvironmentVar(String string, Object object) throws NotesException {
        this.CheckObject();
        this.setEnvironmentVar(string, object, false);
    }

    public void setEnvironmentVar(String string, Object object, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            this.NsetEnvironmentVar(string, object, bl);
            return;
        }
    }

    public Vector freeTimeSearch(DateRange dateRange, int n, Object object, boolean bl) throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int[] nArray = this.NfreeTimeSearch(dateRange, n, object, bl);
            Vector<DateRange> vector = null;
            if (nArray != null && nArray.length > 0) {
                vector = new Vector<DateRange>(nArray.length, 1);
                int n2 = 0;
                while (n2 < nArray.length) {
                    DateRange dateRange2 = this.FindOrCreateDateRange(nArray[n2]);
                    vector.addElement(dateRange2);
                    ++n2;
                }
            }
            Vector<DateRange> vector2 = vector;
            Object var7_11 = null;
            return vector2;
        }
    }

    public Database getURLDatabase() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Database database;
            Database database2 = database = this.FindOrCreateDatabase(this.NgetURLDatabase());
            Object var3_4 = null;
            return database2;
        }
    }

    public Registration createRegistration() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            Registration registration;
            Registration registration2 = registration = this.FindOrCreateRegistration(this.NcreateRegistration());
            Object var3_4 = null;
            return registration2;
        }
    }

    public Vector getAddressBooks() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int[] nArray = this.PropGetObjArray(1198);
            if (nArray.length == 0) {
                Vector vector = null;
                Object var3_5 = null;
                return vector;
            }
            Vector<Database> vector = new Vector<Database>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                Database database = this.FindOrCreateDatabase(nArray[n]);
                vector.addElement(database);
                ++n;
            }
            Vector<Database> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public String getCommonUserName() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1201);
            Object var3_3 = null;
            return string;
        }
    }

    public International getInternational() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            int n = this.PropGetAdt(1213);
            International international = (International)this.FindObject(n);
            if (international == null) {
                international = new International(this, n);
            }
            International international2 = international;
            Object var4_5 = null;
            return international2;
        }
    }

    public boolean isOnServer() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            boolean bl = this.PropGetBool(1196);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getNotesVersion() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1200);
            Object var3_3 = null;
            return string;
        }
    }

    public String getPlatform() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1191);
            Object var3_3 = null;
            return string;
        }
    }

    public String getUserName() throws NotesException {
        this.CheckObject();
        Session session = this;
        synchronized (session) {
            String string = this.PropGetString(1190);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getUserName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public Name getUserNameObject() throws NotesException {
        this.CheckObject();
        String string = this.getUserName();
        if (string != null) {
            Name name = this.createName(string);
            return name;
        }
        return null;
    }

    public AgentContext getAgentContext() throws NotesException {
        this.CheckObject();
        if (this.agentcontext == null) {
            Session session = this;
            synchronized (session) {
                int n = this.PropGetAdt(1901);
                if (n != 0) {
                    this.agentcontext = new AgentContext(this, n);
                }
            }
        }
        return this.agentcontext;
    }
}

