/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes;

import java.util.Enumeration;
import java.util.Vector;
import lotus.notes.Database;
import lotus.notes.DateTime;
import lotus.notes.Document;
import lotus.notes.DocumentCollection;
import lotus.notes.JavaString;
import lotus.notes.NotesBase;
import lotus.notes.NotesException;
import lotus.notes.ViewColumn;

public class View
extends NotesBase {
    private transient Database database;
    private transient Vector columns;

    private native void Nclear();

    private native int NFTSearch(String var1, int var2);

    private native int NgetChild(Document var1);

    private native int NgetDocumentByKey(Vector var1, boolean var2);

    private native int NgetAllDocumentsByKey(Vector var1, boolean var2);

    private native int NgetFirstDocument();

    private native int NgetLastDocument();

    private native int NgetNextDocument(Document var1);

    private native int NgetNextSibling(Document var1);

    private native int NgetNthDocument(int var1);

    private native int NgetParentDocument(Document var1);

    private native int NgetPrevDocument(Document var1);

    private native int NgetPrevSibling(Document var1);

    private native void Nrefresh();

    private native void Nremove();

    protected View() throws NotesException {
    }

    protected View(Database database, int n) throws NotesException {
        super(n, 3);
        if (database == null) {
            throw new NotesException(JavaString.getString("missing_db_object"));
        }
        this.database = database;
        this.columns = new Vector(3);
        database.AddView(this);
    }

    protected void InternalFinalize() throws NotesException {
        try {
            try {
                Enumeration enumeration = this.columns.elements();
                while (enumeration.hasMoreElements()) {
                    ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                    super.DestroyObject(viewColumn);
                }
            }
            catch (Exception exception) {
            }
            Object var2_3 = null;
            this.columns.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.columns.removeAllElements();
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveView(this);
        this.InternalFinalize();
    }

    protected void AddColumn(ViewColumn viewColumn) throws NotesException {
        this.CheckObject();
        Vector vector = this.columns;
        synchronized (vector) {
            this.columns.addElement(viewColumn);
            return;
        }
    }

    protected void RemoveColumn(ViewColumn viewColumn) throws NotesException {
        Vector vector = this.columns;
        synchronized (vector) {
            this.columns.removeElement(viewColumn);
            return;
        }
    }

    protected ViewColumn FindOrCreateColumn(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.columns;
        synchronized (vector) {
            Enumeration enumeration = this.columns.elements();
            while (enumeration.hasMoreElements()) {
                ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                if (!viewColumn.isEqual(n)) continue;
                ViewColumn viewColumn2 = viewColumn;
                Object var5_7 = null;
                return viewColumn2;
            }
            ViewColumn viewColumn = new ViewColumn(this, n);
            Object var5_8 = null;
            return viewColumn;
        }
    }

    public void recycle() throws NotesException {
        try {
            try {
                this.database.RemoveView(this);
                Enumeration enumeration = this.columns.elements();
                while (enumeration.hasMoreElements()) {
                    ViewColumn viewColumn = (ViewColumn)enumeration.nextElement();
                    super.RecycleObject(viewColumn);
                }
            }
            catch (NotesException notesException) {
            }
            Object var2_3 = null;
            this.columns.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.columns.removeAllElements();
            super.Recycle();
            throw throwable;
        }
        super.Recycle();
    }

    public int GetCppObj() {
        return super.GetCppObj();
    }

    public void clear() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nclear();
            return;
        }
    }

    public int FTSearch(String string, int n) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int n2 = this.NFTSearch(string, n);
            Object var5_5 = null;
            return n2;
        }
    }

    public int FTSearch(String string) throws NotesException {
        return this.FTSearch(string, 0);
    }

    public Document getChild(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetChild(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getDocumentByKey(Vector vector) throws NotesException {
        return this.getDocumentByKey(vector, false);
    }

    public Document getDocumentByKey(Vector vector, boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetDocumentByKey(vector, bl));
            Object var5_5 = null;
            return document;
        }
    }

    public Document getDocumentByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getDocumentByKey(vector, false);
    }

    public Document getDocumentByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getDocumentByKey(vector, bl);
    }

    public DocumentCollection getAllDocumentsByKey(Vector vector) throws NotesException {
        return this.getAllDocumentsByKey(vector, false);
    }

    public DocumentCollection getAllDocumentsByKey(Vector vector, boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DocumentCollection documentCollection = this.database.FindOrCreateDocCollection(this.NgetAllDocumentsByKey(vector, bl));
            Object var5_5 = null;
            return documentCollection;
        }
    }

    public DocumentCollection getAllDocumentsByKey(Object object) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllDocumentsByKey(vector, false);
    }

    public DocumentCollection getAllDocumentsByKey(Object object, boolean bl) throws NotesException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.getAllDocumentsByKey(vector, bl);
    }

    public Document getFirstDocument() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetFirstDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public Document getLastDocument() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetLastDocument());
            Object var3_3 = null;
            return document;
        }
    }

    public Document getNextDocument(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextDocument(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getNextSibling(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetNextSibling(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getNthDocument(int n) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document = this.database.FindOrCreateDocument(this.NgetNthDocument(n));
            Object var4_4 = null;
            return document;
        }
    }

    public Document getParentDocument(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetParentDocument(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getPrevDocument(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevDocument(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public Document getPrevSibling(Document document) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Document document2 = this.database.FindOrCreateDocument(this.NgetPrevSibling(document));
            Object var4_4 = null;
            return document2;
        }
    }

    public void refresh() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nrefresh();
            return;
        }
    }

    public void remove() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.Nremove();
            this.database.RemoveView(this);
            this.cpp_object = 0;
            this.finalize();
            return;
        }
    }

    public DateTime getCreated() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DateTime dateTime = this.database.getParent().FindOrCreateDateTime(this.PropGetDate(1282));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public DateTime getLastModified() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            DateTime dateTime = this.database.getParent().FindOrCreateDateTime(this.PropGetDate(1281));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            String string = this.PropGetString(1280);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getUniversalID() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            String string = this.PropGetString(1283);
            Object var3_3 = null;
            return string;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isDefaultView() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1285);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isFolder() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1287);
            Object var3_3 = null;
            return bl;
        }
    }

    public Vector getColumns() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            int[] nArray = this.PropGetObjArray(1286);
            if (nArray.length == 0) {
                Vector vector = null;
                Object var3_5 = null;
                return vector;
            }
            Vector<ViewColumn> vector = new Vector<ViewColumn>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                ViewColumn viewColumn = this.FindOrCreateColumn(nArray[n]);
                vector.addElement(viewColumn);
                ++n;
            }
            Vector<ViewColumn> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public Vector getReaders() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1302);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public void setReaders(Vector vector) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetVector(1302, vector);
            return;
        }
    }

    public boolean isAutoUpdate() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1303);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setAutoUpdate(boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetBool(1303, bl);
            return;
        }
    }

    public Vector getAliases() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1304);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public boolean isCalendar() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1305);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isProtectReaders() throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            boolean bl = this.PropGetBool(1309);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setProtectReaders(boolean bl) throws NotesException {
        this.CheckObject();
        View view = this;
        synchronized (view) {
            this.PropSetBool(1309, bl);
            return;
        }
    }
}

