/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import java.util.Date;
import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.notes.addins.InternationalResources;
import lotus.notes.addins.JavaServerAddin;
import lotus.notes.addins.ispy.ISpyFatalException;
import lotus.notes.addins.ispy.MailPoller;
import lotus.notes.addins.ispy.TCPPoller;
import lotus.notes.internal.MessageQueue;

public class ISpy
extends JavaServerAddin {
    private InternationalResources international_string = new InternationalResources("lotus/notes/addins/ispy/ISpyResources");
    private String addin_name = this.international_string.getString("addin_name");
    private int newStatusLineHandle = -1;
    private MessageQueue msg_queue;
    private TCPPoller tcp_thread;
    private MailPoller mail_thread;
    private Session session;
    private int debug;
    private static final int MQ_DUPLICATE_ERROR = 1121;
    private final int ONE_MINUTE = 60000;
    protected static final String ispy_debug = "debug_ispy";

    public void stopAddin() {
        super.stopAddin();
        this.interrupt();
    }

    public static String updateErrString(NotesException notesException, String string) {
        if (notesException.text != null && notesException.text.length() > 0) {
            return String.valueOf(string) + ": " + notesException.text;
        }
        return string;
    }

    public static boolean openDB(Database database) throws NotesException {
        if (!database.isOpen()) {
            return database.open();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runNotes() {
        block36: {
            block35: {
                int n = 0;
                int n2 = 3000;
                try {
                    this.session = NotesFactory.createSession();
                }
                catch (NotesException notesException) {
                    String string = this.international_string.getString("error_create_session");
                    if (notesException.text != null && notesException.text.length() > 0) {
                        string = String.valueOf(string) + ": " + notesException.text;
                    }
                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string, 0);
                    return;
                }
                this.initDebug();
                try {
                    block40: {
                        try {
                            Runtime runtime = Runtime.getRuntime();
                            this.newStatusLineHandle = this.AddInCreateStatusLine(this.addin_name);
                            this.AddInSetStatusLine(this.newStatusLineHandle, this.international_string.getString("state_initializing"));
                            if (this.debug > 1) {
                                System.out.println("ISpy: Creating and opening message queue.");
                            }
                            this.msg_queue = new MessageQueue();
                            String string = "MQ$ISPY";
                            n = this.msg_queue.create(string, 10, 0);
                            if (n == 0) {
                                n = this.msg_queue.open(string.toString(), 0);
                                if (n != 0) {
                                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_mq_open"), 0);
                                    Object var4_6 = null;
                                    this.cleanUp();
                                    this.AddInLogMessageText(String.valueOf(this.addin_name) + " " + this.international_string.getString("state_terminated"), 0);
                                    return;
                                }
                            } else {
                                if (n == 1121) {
                                    this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_ispy_running"), 0);
                                    break block35;
                                }
                                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_mq_create_error"), 0);
                                break block36;
                            }
                            this.waitForStatsAndEvents();
                            this.session.recycle();
                            this.session = null;
                            if (this.debug > 1) {
                                System.out.println("ISpy: Starting TCPPoller and MailPoller.");
                            }
                            int n3 = 300000;
                            Date date = new Date();
                            date.setTime(System.currentTimeMillis() + (long)n3);
                            this.tcp_thread = new TCPPoller(this.international_string, this.debug);
                            this.mail_thread = new MailPoller(this.international_string, this.debug);
                            this.tcp_thread.start();
                            this.mail_thread.start();
                            while (true) {
                                if (this.tcp_thread.getState() != 0 || this.mail_thread.getState() != 0) {
                                    this.AddInSetStatusLine(this.newStatusLineHandle, this.international_string.getString("state_idle"));
                                    this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("state_initialization_complete"), 0);
                                    break;
                                }
                                Thread.sleep(1000L);
                            }
                            while (this.addInRunning()) {
                                Object var10_18;
                                block38: {
                                    block39: {
                                        block37: {
                                            try {
                                                this.OSPreemptOccasionally();
                                                if (this.msg_queue != null && this.msg_queue.isQuitPending()) {
                                                    var10_18 = null;
                                                    break block37;
                                                }
                                                if (this.msg_queue != null && this.msg_queue.getCount() > 0) {
                                                    StringBuffer stringBuffer = new StringBuffer(20);
                                                    this.msg_queue.get(stringBuffer, 20, 0, 0);
                                                    System.out.println("Got message = " + stringBuffer);
                                                }
                                                if (this.tcp_thread.getState() == 3 && this.mail_thread.getState() == 3) {
                                                    this.AddInSetStatusLine(this.newStatusLineHandle, this.international_string.getString("state_idle"));
                                                } else {
                                                    this.AddInSetStatusLine(this.newStatusLineHandle, this.international_string.getString("state_sending_probes"));
                                                }
                                                if (this.tcp_thread.isAlive() || this.mail_thread.isAlive()) break block38;
                                                break block39;
                                            }
                                            catch (Throwable throwable) {
                                                var10_18 = null;
                                                if (date.getTime() <= System.currentTimeMillis() && this.tcp_thread.getState() == 3 && this.mail_thread.getState() == 3) {
                                                    if (this.debug > 1) {
                                                        System.out.println(String.valueOf(new Date()) + " ISpy: Running garbage collector.");
                                                    }
                                                    runtime.runFinalization();
                                                    runtime.gc();
                                                    date.setTime(System.currentTimeMillis() + (long)n3);
                                                }
                                                Thread.sleep(n2);
                                                throw throwable;
                                            }
                                        }
                                        if (date.getTime() <= System.currentTimeMillis() && this.tcp_thread.getState() == 3 && this.mail_thread.getState() == 3) {
                                            if (this.debug > 1) {
                                                System.out.println(String.valueOf(new Date()) + " ISpy: Running garbage collector.");
                                            }
                                            runtime.runFinalization();
                                            runtime.gc();
                                            date.setTime(System.currentTimeMillis() + (long)n3);
                                        }
                                        Thread.sleep(n2);
                                        break;
                                    }
                                    var10_18 = null;
                                    if (date.getTime() <= System.currentTimeMillis() && this.tcp_thread.getState() == 3 && this.mail_thread.getState() == 3) {
                                        if (this.debug > 1) {
                                            System.out.println(String.valueOf(new Date()) + " ISpy: Running garbage collector.");
                                        }
                                        runtime.runFinalization();
                                        runtime.gc();
                                        date.setTime(System.currentTimeMillis() + (long)n3);
                                    }
                                    Thread.sleep(n2);
                                    break;
                                }
                                var10_18 = null;
                                if (date.getTime() <= System.currentTimeMillis() && this.tcp_thread.getState() == 3 && this.mail_thread.getState() == 3) {
                                    if (this.debug > 1) {
                                        System.out.println(String.valueOf(new Date()) + " ISpy: Running garbage collector.");
                                    }
                                    runtime.runFinalization();
                                    runtime.gc();
                                    date.setTime(System.currentTimeMillis() + (long)n3);
                                }
                                Thread.sleep(n2);
                            }
                        }
                        catch (NotesException notesException) {
                            if (notesException.text != null && notesException.text.length() > 0) {
                                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + notesException.text, 0);
                            }
                            if (this.debug > 0 || notesException.text == null || notesException.text.length() == 0) {
                                notesException.printStackTrace();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Exception exception) {
                            String string = exception.getMessage();
                            if (string != null && string.length() > 0) {
                                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string, 0);
                            }
                            if (this.debug <= 0 && string != null && string.length() != 0) break block40;
                            exception.printStackTrace();
                        }
                    }
                    Object var4_9 = null;
                    this.cleanUp();
                    this.AddInLogMessageText(String.valueOf(this.addin_name) + " " + this.international_string.getString("state_terminated"), 0);
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    this.cleanUp();
                    this.AddInLogMessageText(String.valueOf(this.addin_name) + " " + this.international_string.getString("state_terminated"), 0);
                    throw throwable;
                }
            }
            Object var4_7 = null;
            this.cleanUp();
            this.AddInLogMessageText(String.valueOf(this.addin_name) + " " + this.international_string.getString("state_terminated"), 0);
            return;
        }
        Object var4_8 = null;
        this.cleanUp();
        this.AddInLogMessageText(String.valueOf(this.addin_name) + " " + this.international_string.getString("state_terminated"), 0);
    }

    public static void main(String[] stringArray) {
        ISpy iSpy = new ISpy();
        iSpy.start();
    }

    private void initDebug() {
        String string = null;
        try {
            string = this.session.getEnvironmentString(ispy_debug, true);
        }
        catch (NotesException notesException) {
            this.debug = 0;
            String string2 = this.international_string.getString("error_get_dbg_flg");
            if (notesException.text != null && notesException.text.length() > 0) {
                string2 = String.valueOf(string2) + ": " + notesException.text;
            }
            this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string2, 0);
        }
        if (string != null && string.compareTo("") != 0) {
            try {
                this.debug = Integer.parseInt(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.debug = 0;
                String string3 = this.international_string.getString("error_invalid_dbg_flag");
                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string3, 0);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForStatsAndEvents() throws ISpyFatalException, NotesException, InterruptedException {
        Base base;
        block28: {
            block27: {
                block24: {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Checking for Stats and Events database.");
                    }
                    String string = null;
                    String string2 = this.international_string.getString("statistics_database_name");
                    int n = 30000;
                    base = null;
                    try {
                        View view;
                        boolean bl = false;
                        int n2 = 0;
                        while (true) {
                            block26: {
                                if (!this.addInRunning() || n2 >= 10 || bl) {
                                    if (!super.shouldTerminate()) break;
                                    Object var6_13 = null;
                                    if (base == null) return;
                                    break block24;
                                }
                                try {
                                    block25: {
                                        try {
                                            if (base == null) {
                                                base = this.session.getDatabase(null, string2);
                                            }
                                            if (base == null) break block25;
                                            if (!base.isOpen()) {
                                                if (base.open()) {
                                                    bl = true;
                                                }
                                                break block25;
                                            }
                                            bl = true;
                                        }
                                        catch (NotesException notesException) {
                                            string = notesException.text;
                                        }
                                    }
                                    view = null;
                                    if (bl) break block26;
                                }
                                catch (Throwable throwable) {
                                    view = null;
                                    if (bl) throw throwable;
                                    Thread.sleep(n);
                                    throw throwable;
                                }
                                Thread.sleep(n);
                            }
                            ++n2;
                        }
                        if (!bl) {
                            String string3 = this.international_string.getString("error_open_events_db");
                            if (string == null) throw new ISpyFatalException(string3);
                            if (string.length() <= 0) throw new ISpyFatalException(string3);
                            string3 = String.valueOf(string3) + ": " + string;
                            throw new ISpyFatalException(string3);
                        }
                        if (this.debug > 1) {
                            System.out.println("ISpy: Checking for mail and tcp probe views in Stats & Events data base.");
                        }
                        View view2 = null;
                        view = null;
                        int n3 = 0;
                        while (true) {
                            if (!this.addInRunning() || n3 >= 10 || view2 != null && view != null) {
                                if (!super.shouldTerminate()) break;
                                break block27;
                            }
                            try {
                                if (view2 == null) {
                                    view2 = base.getView("vaMailProbes");
                                }
                            }
                            catch (NotesException notesException) {
                                view2 = null;
                            }
                            try {
                                if (view == null) {
                                    view = base.getView("(vaTCPServices)");
                                }
                            }
                            catch (NotesException notesException) {
                                view = null;
                            }
                            if (view2 == null || view == null) {
                                Thread.sleep(n);
                            }
                            ++n3;
                        }
                        if (view2 == null || view == null) {
                            String string4 = this.international_string.getString("error_get_probe_views");
                            throw new ISpyFatalException(string4);
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {
                        Object var6_16 = null;
                        if (base == null) throw throwable;
                        base.recycle();
                        throw throwable;
                    }
                }
                base.recycle();
                return;
            }
            Object var6_14 = null;
            if (base == null) return;
            base.recycle();
            return;
        }
        Object var6_15 = null;
        if (base == null) return;
        base.recycle();
    }

    private void cleanUp() {
        int n;
        block38: {
            block37: {
                if (this.msg_queue != null) {
                    this.msg_queue.close(0);
                }
                if (this.newStatusLineHandle != -1) {
                    this.AddInSetStatusLine(this.newStatusLineHandle, String.valueOf(this.addin_name) + ": " + this.international_string.getString("state_terminating"));
                }
                if (this.tcp_thread != null) {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Stopping TCPPoller.");
                    }
                    this.tcp_thread.stopAddin();
                    this.tcp_thread.interrupt();
                }
                if (this.mail_thread != null) {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Stopping MailPoller.");
                    }
                    this.mail_thread.stopAddin();
                    this.mail_thread.interrupt();
                }
                if (this.tcp_thread != null) {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Waiting for TCPPoller to stop.");
                    }
                    try {
                        this.tcp_thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.debug <= 1) break block37;
                        System.out.println("ISpy: ERROR occured during JOIN with TCP Poller!");
                    }
                }
            }
            if (this.tcp_thread.isAlive()) {
                n = 0;
                if (this.debug > 1) {
                    System.out.println("ISpy: TCP Poller still alive!");
                }
                while (this.tcp_thread.isAlive()) {
                    try {
                        this.tcp_thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.debug > 1) {
                            System.out.println("ISpy: TCP Poller still going, attemp # " + n);
                        }
                        ++n;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            if (this.debug <= 1) continue;
                            System.out.println("Check for TCP Poller interrupted.");
                        }
                    }
                }
                if (this.debug > 1) {
                    System.out.println("ISpy: TCP Poller has stopped.");
                }
            } else if (this.debug > 1) {
                System.out.println("ISpy: TCP Poller has stopped.");
            }
            this.tcp_thread = null;
            if (this.mail_thread != null) {
                if (this.debug > 1) {
                    System.out.println("ISpy: Waiting for MailPoller to stop.");
                }
                try {
                    this.mail_thread.join();
                }
                catch (InterruptedException interruptedException) {
                    if (this.debug <= 1) break block38;
                    System.out.println("ISpy: ERROR occured during JOIN with Mail Poller!");
                }
            }
        }
        if (this.mail_thread.isAlive()) {
            n = 0;
            if (this.debug > 1) {
                System.out.println("ISpy: Mail Poller still alive!");
            }
            while (this.mail_thread.isAlive()) {
                try {
                    this.mail_thread.join();
                }
                catch (InterruptedException interruptedException) {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Mail Poller still going, attemp # " + n);
                    }
                    ++n;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        if (this.debug <= 1) continue;
                        System.out.println("Check for Mail Poller interrupted.");
                    }
                }
            }
            if (this.debug > 1) {
                System.out.println("ISpy: Mail Poller has stopped.");
            }
        } else if (this.debug > 1) {
            System.out.println("ISpy: Mail Poller has stopped.");
        }
        this.mail_thread = null;
        if (this.newStatusLineHandle != -1) {
            this.AddInDeleteStatusLine(this.newStatusLineHandle);
        }
    }
}

