/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.Log;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.notes.addins.InternationalResources;
import lotus.notes.addins.JavaServerAddin;
import lotus.notes.addins.ispy.ISpy;
import lotus.notes.addins.ispy.ISpyFatalException;
import lotus.notes.addins.ispy.MailProbeDoc;
import lotus.notes.addins.ispy.MailProbeID;
import lotus.notes.addins.ispy.NABUtils;
import lotus.notes.addins.ispy.util.ActiveList;
import lotus.notes.addins.ispy.util.Appointment;
import lotus.notes.addins.ispy.util.Schedule;

public class MailPoller
extends JavaServerAddin {
    public static final int INITIALIZING = 0;
    public static final int UPDATING_CONFIG = 1;
    public static final int PROBING = 2;
    public static final int IDLE = 3;
    private Session notes_session;
    private int state = 0;
    private InternationalResources international_string;
    private String STAT_EVENTS_DB_NAME;
    private String INBOX_VIEW_NAME;
    private String MAIL_IN_RECORD_DESC;
    private String MAIL_TEMPLATE;
    private Database stat_events_db;
    String this_server;
    private Date last_schedule_update_time;
    private String addin_name;
    private String mail_server;
    private String mail_file;
    private String from_name;
    private String mail_domain;
    private View mail_probes_view;
    private final int ONE_MINUTE = 60000;
    private Schedule probe_schedule = new Schedule();
    private static String EVENT_QUEUE_NAME;
    private Log event_handle;
    private ActiveList stat_list = new ActiveList();
    Vector probe_list = new Vector();
    private Date nextUpdate;
    private int UPDATE_INTERVAL = 180000;
    Date next_appointment;
    private boolean sent_event_error_messsage = false;
    private final String CREATE_MAIL_IN_DB_PROXY_ACTION = "64";
    private final String ADMIN_RQST_DB_NAME = "admin4.nsf";
    private final String ADMIN_RQST_FORM = "AdminRequest";
    private final String ADMIN_RQSTS_VIEW = "($Requests)";
    private final String PROXY_NAME_LIST_FIELD = "ProxyNameList";
    private final String PROXY_SERVER_FIELD = "ProxyServer";
    private final String PROXY_AUTHOR_FIELD = "ProxyAuthor";
    private final String PROXY_PROCESS_FIELD = "ProxyProcess";
    private final String PROXY_ACTION_FIELD = "ProxyAction";
    private final String PROXY_DB_SRC_FIELD = "ProxyDatabaseSourcePath";
    private final String PROXY_TXT_ITEM1_FIELD = "ProxyTextItem1";
    private final String PROXY_TXT_ITEM2_FIELD = "ProxyTextItem2";
    private final String ADMIN_TYPE_FIELD = "Type";
    private final String PROXY_SRC_SERVER_FIELD = "ProxySourceServer";
    private int debug;

    public MailPoller(InternationalResources internationalResources, int n) {
        this.international_string = internationalResources;
        this.debug = n;
        this.STAT_EVENTS_DB_NAME = internationalResources.getString("statistics_database_name");
        this.addin_name = internationalResources.getString("addin_name");
        this.INBOX_VIEW_NAME = internationalResources.getString("view_inbox");
        EVENT_QUEUE_NAME = internationalResources.getString("event_queue_name");
        this.MAIL_IN_RECORD_DESC = internationalResources.getString("mail_in_record_description");
        this.nextUpdate = new Date();
    }

    public synchronized int getState() {
        return this.state;
    }

    public void runNotes() {
        try {
            this.initialize();
        }
        catch (NotesException notesException) {
            this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_mailpoller_initialize"), 0);
            if (notesException.text != null && notesException.text.length() > 0) {
                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + notesException.text, 0);
            }
            if (this.debug > 0 || notesException.text == null || notesException.text.length() == 0) {
                notesException.printStackTrace();
            }
            return;
        }
        try {
            try {
                while (this.addInRunning()) {
                    Object var4_3;
                    try {
                        block28: {
                            try {
                                try {
                                    this.updateConfiguration();
                                }
                                catch (NotesException notesException) {
                                    throw new ISpyFatalException(notesException.text);
                                }
                                this.next_appointment = this.probe_schedule.getTimeOfNextAppointment();
                                if (this.next_appointment != null && this.next_appointment.getTime() < System.currentTimeMillis()) {
                                    this.setState(2);
                                    if (this.debug > 0) {
                                        System.out.println(String.valueOf(new Date()) + " ISpy: Starting mail probes...");
                                    }
                                    this.probe();
                                    this.processReturnedProbes();
                                }
                            }
                            catch (ISpyFatalException iSpyFatalException) {
                                super.stopAddin();
                                throw iSpyFatalException;
                            }
                            catch (NotesException notesException) {
                                if (notesException.text != null && notesException.text.length() > 0) {
                                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + notesException.text, 0);
                                }
                                if (this.debug > 0 || notesException.text == null || notesException.text.length() == 0) {
                                    notesException.printStackTrace();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                this.interrupt();
                            }
                            catch (Exception exception) {
                                String string = exception.getMessage();
                                if (string != null && string.length() > 0) {
                                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + exception.getMessage(), 0);
                                }
                                if (this.debug <= 0 && string != null && string.length() != 0) break block28;
                                exception.printStackTrace();
                            }
                        }
                        var4_3 = null;
                        this.cleanupDatabasesAndViews();
                        if (this.getState() == 2 && this.debug > 0) {
                            System.out.println(String.valueOf(new Date()) + " ISpy: ...MAIL probes complete.");
                        }
                        this.setState(3);
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        this.cleanupDatabasesAndViews();
                        if (this.getState() == 2 && this.debug > 0) {
                            System.out.println(String.valueOf(new Date()) + " ISpy: ...MAIL probes complete.");
                        }
                        this.setState(3);
                        this.sleep(this.next_appointment);
                        throw throwable;
                    }
                    this.sleep(this.next_appointment);
                }
            }
            catch (ISpyFatalException iSpyFatalException) {
                String string = iSpyFatalException.getMessage();
                if (string != null && string.compareTo("") != 0) {
                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string, 0);
                }
                if (this.debug > 0 || string == null || string.length() == 0) {
                    iSpyFatalException.printStackTrace();
                }
                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("mail_poller_fatal"), 0);
            }
            catch (InterruptedException interruptedException) {
            }
            Object var2_15 = null;
            Vector vector = this.stat_list.getList();
            this.deleteStats(vector);
            return;
        }
        catch (Throwable throwable) {
            Object var2_16 = null;
            Vector vector = this.stat_list.getList();
            this.deleteStats(vector);
            throw throwable;
        }
    }

    private void initialize() throws NotesException {
        Session session;
        block4: {
            session = null;
            try {
                session = NotesFactory.createSession();
            }
            catch (NotesException notesException) {
                notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_session"));
                throw notesException;
            }
            try {
                this.from_name = String.valueOf(this.addin_name) + " on " + session.getCommonUserName();
                this.this_server = session.getUserName();
                this.MAIL_TEMPLATE = session.getEnvironmentString("DefaultMailTemplate", true);
                if (this.MAIL_TEMPLATE != null && this.MAIL_TEMPLATE.length() != 0) break block4;
                this.MAIL_TEMPLATE = this.international_string.getString("mail_template");
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                session.recycle();
                throw throwable;
            }
        }
        Object var3_4 = null;
        session.recycle();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateConfiguration() throws NotesException, InterruptedException, ISpyFatalException {
        this.setState(1);
        try {
            this.notes_session = NotesFactory.createSession();
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_session"));
            throw notesException;
        }
        this.event_handle = this.notes_session.createLog("");
        if (this.nextUpdate.getTime() > System.currentTimeMillis()) return;
        if (this.debug > 1) {
            System.out.println(String.valueOf(new Date()) + " ISpy: MailPoller updating configuration.");
        }
        try {
            int n = 60000;
            int n2 = 11;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 1;
            while (true) {
                block12: {
                    Object var9_8;
                    if (!this.addInRunning() || n3 > n2 || bl) {
                        if (bl) break;
                        throw new ISpyFatalException(this.international_string.getString("error_init_mailin_db"));
                    }
                    try {
                        try {
                            bl = this.initializeMailInDb();
                        }
                        catch (NotesException notesException) {
                            bl2 = true;
                            throw new ISpyFatalException(notesException.text);
                        }
                        var9_8 = null;
                        if (bl || n3 >= n2 || bl2) break block12;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (bl) throw throwable;
                        if (n3 >= n2) throw throwable;
                        if (bl2) throw throwable;
                        Thread.sleep(n);
                        throw throwable;
                    }
                    Thread.sleep(n);
                }
                ++n3;
            }
            this.next_appointment = null;
            this.getDatabasesAndViews();
            this.initSchedule();
            return;
        }
        finally {
            Object var2_11 = null;
            this.nextUpdate.setTime(System.currentTimeMillis() + (long)this.UPDATE_INTERVAL);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSchedule() throws NotesException {
        try {
            Vector vector = null;
            Date date = new Date();
            DateTime dateTime = this.notes_session.createDateTime(this.notes_session.getInternational().getToday());
            dateTime.setNow();
            this.stat_list.reset();
            this.probe_schedule.reset();
            Document document = null;
            Document document2 = this.mail_probes_view.getFirstDocument();
            while (document2 != null) {
                block20: {
                    Object var7_7;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    try {
                                        Object object;
                                        if (this.shouldTerminate()) {
                                            var7_7 = null;
                                            break block16;
                                        }
                                        if (document2.getItemValueString("Disabled") != null) {
                                            break block17;
                                        }
                                        boolean bl = false;
                                        vector = document2.getItemValue("SourceServerName");
                                        Enumeration enumeration = vector.elements();
                                        while (enumeration.hasMoreElements()) {
                                            object = (String)enumeration.nextElement();
                                            if (((String)object).compareTo(this.this_server) != 0 && ((String)object).compareTo("*") != 0) continue;
                                            bl = true;
                                            break;
                                        }
                                        if (!bl) {
                                            break block18;
                                        }
                                        MailProbeDoc mailProbeDoc = new MailProbeDoc(document2, this.from_name, this.international_string);
                                        String string = mailProbeDoc.getStatisticName();
                                        if (this.last_schedule_update_time == null) {
                                            object = new Appointment(date, document2.getItemValueInteger("MailProbeInterval") * 60000, mailProbeDoc, string);
                                            this.probe_schedule.addAppointment((Appointment)object);
                                        } else if (this.last_schedule_update_time.before(document2.getLastModified().toJavaDate())) {
                                            object = this.probe_schedule.getAppointmentWithDescription(string, true);
                                            object = new Appointment(date, document2.getItemValueInteger("MailProbeInterval") * 60000, mailProbeDoc, string);
                                            this.probe_schedule.addAppointment((Appointment)object);
                                        } else {
                                            object = this.probe_schedule.getAppointmentWithDescription(string, false);
                                            if (object != null) {
                                                ((Appointment)object).activate();
                                            }
                                        }
                                        if (object == null) break block19;
                                        this.stat_list.addItem(string);
                                        break block19;
                                    }
                                    catch (Throwable throwable) {
                                        var7_7 = null;
                                        document = this.mail_probes_view.getNextDocument(document2);
                                        document2.recycle();
                                        throw throwable;
                                    }
                                }
                                document = this.mail_probes_view.getNextDocument(document2);
                                document2.recycle();
                                break;
                            }
                            var7_7 = null;
                            document = this.mail_probes_view.getNextDocument(document2);
                            document2.recycle();
                            break block20;
                        }
                        var7_7 = null;
                        document = this.mail_probes_view.getNextDocument(document2);
                        document2.recycle();
                        break block20;
                    }
                    var7_7 = null;
                    document = this.mail_probes_view.getNextDocument(document2);
                    document2.recycle();
                }
                document2 = document;
            }
            this.probe_schedule.removeInActive();
            if (this.debug > 1) {
                System.out.println("\nISpy: DUMPING MAIL PROBE APPOINTMENTS");
            }
            this.probe_schedule.dump(this.debug);
            Vector vector2 = this.stat_list.removeInActive();
            this.deleteStats(vector2);
            if (this.debug > 1) {
                System.out.println("\nISpy: DUMPING MAIL POLLER STAT LIST");
            }
            this.stat_list.dump(this.debug);
            this.last_schedule_update_time = dateTime.toJavaDate();
            return;
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_init_sched"));
            throw notesException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void probe() throws NotesException {
        String string = null;
        MailProbeDoc mailProbeDoc = null;
        MailProbeID mailProbeID = null;
        Appointment appointment = null;
        try {
            while (this.next_appointment != null) {
                if (this.next_appointment.getTime() >= System.currentTimeMillis()) return;
                if (this.shouldTerminate()) {
                    return;
                }
                appointment = (Appointment)this.probe_schedule.firstElement();
                mailProbeDoc = (MailProbeDoc)appointment.getData();
                string = mailProbeDoc.getTargetRecipient();
                long l = System.currentTimeMillis() + (long)(mailProbeDoc.getMailTimeout() * 60000);
                mailProbeID = new MailProbeID(mailProbeDoc.getStatisticName(), l);
                if (this.CreateAndSendMailTrace(string, this.from_name, this.international_string.getString("probe_body_text"), mailProbeID.getIDString()) != 0) {
                    Object[] objectArray = new Object[]{mailProbeDoc.getStatisticName()};
                    String string2 = MessageFormat.format(this.international_string.getString("error_create_send_mail_trace"), objectArray);
                    throw new NotesException(0, string2);
                }
                this.probe_list.addElement(mailProbeID.getIDString());
            }
            return;
            finally {
                Object var8_6 = null;
                string = null;
                mailProbeID = null;
                if (appointment != null) {
                    appointment.repeat();
                    this.probe_schedule.removeElementAt(0);
                    this.probe_schedule.addAppointment(appointment);
                    this.next_appointment = this.probe_schedule.getTimeOfNextAppointment();
                }
            }
        }
        catch (NotesException notesException) {
            this.next_appointment = null;
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_probing"));
            throw notesException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processReturnedProbes() throws InterruptedException, NotesException, ISpyFatalException {
        Document document;
        Database database = null;
        try {
            database = this.notes_session.getDatabase(null, this.mail_file);
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_get_mail_db"));
            throw new ISpyFatalException(notesException.text);
        }
        if (database == null) throw new ISpyFatalException(this.international_string.getString("error_get_mail_db"));
        if (!ISpy.openDB(database)) {
            throw new ISpyFatalException(this.international_string.getString("error_get_mail_db"));
        }
        View view = null;
        int n = 6;
        int n2 = 30000;
        int n3 = 1;
        while (true) {
            block22: {
                if (!this.addInRunning() || n3 > n || view != null) {
                    if (view != null) break;
                    throw new ISpyFatalException(this.international_string.getString("error_get_inbox_view"));
                }
                try {
                    try {
                        if (view == null) {
                            view = database.getView(this.INBOX_VIEW_NAME);
                        }
                    }
                    catch (NotesException notesException) {
                        view = null;
                    }
                    document = null;
                    if (view != null || n3 >= n) break block22;
                }
                catch (Throwable throwable) {
                    document = null;
                    if (view != null) throw throwable;
                    if (n3 >= n) throw throwable;
                    Thread.sleep(n2);
                    throw throwable;
                }
                Thread.sleep(n2);
            }
            ++n3;
        }
        try {
            block9: while (true) {
                String string;
                if (this.probe_list.size() <= 0) return;
                if (System.currentTimeMillis() >= this.next_appointment.getTime()) return;
                if (this.shouldTerminate()) {
                    return;
                }
                document = null;
                view.refresh();
                Document document2 = view.getFirstDocument();
                while (true) {
                    block23: {
                        Object object;
                        String string2;
                        block24: {
                            if (document2 == null || this.shouldTerminate()) break;
                            String string3 = document2.getItemValueString("Subject");
                            string = document2.getItemValueString("Form");
                            if (string3 == null || !this.probe_list.removeElement(string3)) break block23;
                            string2 = MailProbeID.extractStatisticName(string3);
                            if (string.compareTo(this.international_string.getString("probe_response_form")) != 0) break block24;
                            if (this.stat_list.isActive(string2)) {
                                object = document2.getItemValue("RouteTimes");
                                long l = this.calculateMailResponseTime((DateTime)((Vector)object).elementAt(0), document2.getFirstItem("DeliveredDate"));
                                this.StatUpdate(this.international_string.getString("facility_id"), string2, (short)0, (short)0, new Long(l));
                                ((Vector)object).removeAllElements();
                                if (this.debug > 2) {
                                    System.out.println("ISpy: Returned probe\nSubject:" + string3 + "\nresponse time:" + l);
                                }
                            }
                            break block23;
                        }
                        object = this.probe_schedule.getAppointmentWithDescription(string2, false);
                        if (object != null) {
                            this.logProbeError((MailProbeDoc)((Appointment)object).getData(), "error_probe_failed");
                        }
                    }
                    document = document2;
                    document2 = view.getNextDocument(document2);
                    document.remove(true);
                }
                int n4 = 0;
                while (true) {
                    if (n4 >= this.probe_list.size() || this.shouldTerminate()) {
                        Thread.sleep(5000L);
                        continue block9;
                    }
                    string = (String)this.probe_list.elementAt(n4);
                    long l = MailProbeID.extractProbeExpiryTime(string);
                    if (System.currentTimeMillis() > l) {
                        String string4 = MailProbeID.extractStatisticName(string);
                        Appointment appointment = this.probe_schedule.getAppointmentWithDescription(string4, false);
                        if (appointment != null) {
                            this.logProbeError((MailProbeDoc)appointment.getData(), "error_probe_timed_out");
                        }
                        this.probe_list.removeElementAt(n4);
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_mail_responses"));
            throw notesException;
        }
    }

    private void deleteStats(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.StatDelete(this.international_string.getString("facility_id"), string);
        }
    }

    private int calculateMailResponseTime(DateTime dateTime, Item item) {
        int n = -1;
        DateTime dateTime2 = null;
        try {
            dateTime2 = item.getDateTimeValue();
            n = dateTime2.timeDifference(dateTime);
            dateTime2.recycle();
            dateTime2 = null;
        }
        catch (NotesException notesException) {
            if (dateTime2 != null) {
                try {
                    dateTime2.recycle();
                }
                catch (Exception exception) {}
                dateTime2 = null;
            }
            n = -1;
        }
        return n;
    }

    private void getDatabasesAndViews() throws ISpyFatalException, InterruptedException {
        try {
            this.stat_events_db = this.notes_session.getDatabase(null, this.STAT_EVENTS_DB_NAME);
        }
        catch (NotesException notesException) {
            throw new ISpyFatalException(String.valueOf(this.international_string.getString("event_db_not_found")) + " = " + this.STAT_EVENTS_DB_NAME);
        }
        if (this.stat_events_db != null) {
            boolean bl = false;
            int n = 0;
            while (n < 3) {
                try {
                    if (ISpy.openDB(this.stat_events_db)) {
                        bl = true;
                        break;
                    }
                }
                catch (NotesException notesException) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("event_db_not_found") + "(" + n + ") = " + this.STAT_EVENTS_DB_NAME, 0);
                }
                ++n;
            }
            if (!bl) {
                throw new ISpyFatalException("");
            }
        } else {
            throw new ISpyFatalException(String.valueOf(this.international_string.getString("event_db_not_found")) + " = " + this.STAT_EVENTS_DB_NAME);
        }
        try {
            this.mail_probes_view = null;
            this.mail_probes_view = this.stat_events_db.getView("vaMailProbes");
        }
        catch (NotesException notesException) {}
        if (this.mail_probes_view == null) {
            throw new ISpyFatalException(String.valueOf(this.international_string.getString("no_view")) + " = [" + "vaMailProbes" + "]! " + this.international_string.getString("refresh_events_db"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initializeMailInDb() throws ISpyFatalException, NotesException, InterruptedException {
        boolean bl;
        Base base;
        Document document;
        Base base2;
        Database database;
        block28: {
            boolean bl2 = false;
            Base base3 = null;
            database = null;
            base2 = null;
            document = null;
            int n = 4003;
            try {
                document = NABUtils.getFirstDocumentFromAddressBook(this.notes_session, 2, this.from_name);
            }
            catch (NotesException notesException) {
                notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_mail_in_record"));
                throw notesException;
            }
            try {
                block27: {
                    block26: {
                        block29: {
                            if (document != null) break block29;
                            database = this.openAdminRequestsDb();
                            if (!this.outstandingAdminpRequest(database)) {
                                block25: {
                                    Object object;
                                    Document document2 = null;
                                    try {
                                        try {
                                            try {
                                                document2 = NABUtils.getFirstDocumentFromAddressBook(this.notes_session, 0, this.this_server);
                                            }
                                            catch (NotesException notesException) {
                                                notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_server_record"));
                                                throw notesException;
                                            }
                                            object = document2.getItemValueString("Domain");
                                            base = database.createDocument();
                                            Item item = base.appendItemValue("Form", "AdminRequest");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyNameList", this.from_name);
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyServer", "*");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyAuthor", this.this_server);
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyProcess", "Adminp");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyAction", "64");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyDatabaseSourcePath", "ispy50.nsf");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyTextItem1", this.MAIL_IN_RECORD_DESC);
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxyTextItem2", object);
                                            item.setSigned(true);
                                            item = base.appendItemValue("Type", "AdminRequest");
                                            item.setSigned(true);
                                            item = base.appendItemValue("ProxySourceServer", this.this_server);
                                            item.setSigned(true);
                                            base.sign();
                                        }
                                        catch (NotesException notesException) {
                                            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_adminp_rqst"));
                                            throw notesException;
                                        }
                                        Object var13_20 = null;
                                        if (document2 == null) break block25;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_21 = null;
                                        if (document2 == null) throw throwable;
                                        Database database2 = document2.getParentDatabase();
                                        database2.recycle();
                                        throw throwable;
                                    }
                                    object = document2.getParentDatabase();
                                    object.recycle();
                                }
                                if (!base.save()) {
                                    throw new NotesException(0, this.international_string.getString("error_create_adminp_rqst"));
                                }
                            }
                            break block27;
                        }
                        try {
                            this.mail_file = document.getItemValueString("MailFile");
                            base = this.notes_session.getDbDirectory(null);
                        }
                        catch (NotesException notesException) {
                            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_check_for_mailfile"));
                            throw notesException;
                        }
                        try {
                            base3 = base.openDatabase(this.mail_file);
                        }
                        catch (NotesException notesException) {
                            if (notesException.id == n) break block26;
                            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_check_for_mailfile"));
                            throw notesException;
                        }
                    }
                    try {
                        if (base3 == null) {
                            base2 = this.notes_session.getDatabase(null, this.MAIL_TEMPLATE);
                            if (ISpy.openDB((Database)base2)) {
                                base3 = base2.createFromTemplate(null, this.mail_file, true);
                                base3.setTitle(document.getItemValueString("FullName"));
                                bl2 = true;
                            }
                            break block27;
                        }
                        bl2 = true;
                    }
                    catch (NotesException notesException) {
                        notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_mail_file"));
                        throw notesException;
                    }
                }
                bl = document != null && bl2;
                Object var9_23 = null;
                if (base3 == null) break block28;
            }
            catch (Throwable throwable) {
                Object var9_24 = null;
                if (base3 != null) {
                    base3.recycle();
                }
                if (database != null) {
                    database.recycle();
                }
                if (base2 != null) {
                    base2.recycle();
                }
                if (document == null) throw throwable;
                Database database3 = document.getParentDatabase();
                database3.recycle();
                throw throwable;
            }
            base3.recycle();
        }
        if (database != null) {
            database.recycle();
        }
        if (base2 != null) {
            base2.recycle();
        }
        if (document == null) return bl;
        base = document.getParentDatabase();
        base.recycle();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Database openAdminRequestsDb() throws ISpyFatalException, InterruptedException {
        int n = 30000;
        Database database = null;
        String string = null;
        if (this.debug > 1) {
            System.out.println("ISpy: Checking for Adminstration Requests database.");
        }
        int n2 = 11;
        boolean bl = false;
        int n3 = 1;
        while (true) {
            block24: {
                Object var8_7;
                if (!this.addInRunning() || n3 > n2 || bl) {
                    if (super.shouldTerminate()) {
                        this.interrupt();
                    }
                    if (bl) break;
                    String string2 = this.international_string.getString("error_open_adminrq_db");
                    if (string != null && string.length() > 0) {
                        string2 = String.valueOf(string2) + ": " + string;
                    }
                    throw new ISpyFatalException(string2);
                }
                try {
                    block23: {
                        try {
                            if (database == null) {
                                database = this.notes_session.getDatabase(null, "admin4.nsf");
                            }
                            if (database == null) break block23;
                            if (!database.isOpen()) {
                                if (database.open()) {
                                    bl = true;
                                }
                                break block23;
                            }
                            bl = true;
                        }
                        catch (NotesException notesException) {
                            string = notesException.text;
                        }
                    }
                    var8_7 = null;
                    if (bl || n3 >= n2) break block24;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (!bl && n3 < n2) {
                        Thread.sleep(n);
                    }
                    throw throwable;
                }
                Thread.sleep(n);
            }
            ++n3;
        }
        if (this.debug > 1) {
            System.out.println("ISpy: Checking for ($Requests) view in the Administration Requests database.");
        }
        View view = null;
        int n4 = 1;
        while (true) {
            block25: {
                String string3;
                if (!this.addInRunning() || n4 > n2 || view != null) {
                    if (super.shouldTerminate()) {
                        this.interrupt();
                    }
                    if (view != null) break;
                    Object[] objectArray = new Object[]{"($Requests)"};
                    string3 = MessageFormat.format(this.international_string.getString("error_get_adminRequests_view"), objectArray);
                    throw new ISpyFatalException(string3);
                }
                try {
                    try {
                        if (view == null) {
                            view = database.getView("($Requests)");
                        }
                    }
                    catch (NotesException notesException) {
                        view = null;
                    }
                    string3 = null;
                    if (view != null || n4 >= n2) break block25;
                }
                catch (Throwable throwable) {
                    string3 = null;
                    if (view == null && n4 < n2) {
                        Thread.sleep(n);
                    }
                    throw throwable;
                }
                Thread.sleep(n);
            }
            ++n4;
        }
        return database;
    }

    private boolean outstandingAdminpRequest(Database database) throws NotesException {
        try {
            if (this.debug > 1) {
                System.out.println("ISpy: Begin outstandingAdminpRequest.");
            }
            String string = null;
            String string2 = null;
            Base base = null;
            View view = database.getView("($Requests)");
            Document document = view.getFirstDocument();
            while (document != null) {
                DocumentCollection documentCollection;
                if (base != null) {
                    base.recycle();
                }
                string = document.getItemValueString("ProxyAction");
                string2 = document.getItemValueString("ProxyAuthor");
                if (string.compareTo("64") == 0 && string2.compareTo(this.this_server) == 0 && (documentCollection = document.getResponses()).getCount() == 0) {
                    if (this.debug > 1) {
                        System.out.println("ISpy: Begin outstandingAdminpRequest - RESULT FOUND");
                    }
                    return true;
                }
                base = document;
                document = view.getNextDocument(document);
            }
            if (this.debug > 1) {
                System.out.println("ISpy: Begin outstandingAdminpRequest - RESULT NOT FOUND");
            }
            if (base != null) {
                base.recycle();
            }
            return false;
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_outstanding_adminp_rqst"));
            if (this.debug > 1) {
                System.out.println("ISpy: Begin outstandingAdminpRequest - RESULT ERROR");
            }
            throw notesException;
        }
    }

    private void sleep(Date date) throws InterruptedException {
        if (!this.shouldTerminate()) {
            long l = 0L;
            l = date == null ? this.nextUpdate.getTime() - System.currentTimeMillis() : (date.getTime() < this.nextUpdate.getTime() ? date.getTime() - System.currentTimeMillis() : this.nextUpdate.getTime() - System.currentTimeMillis());
            if (l < 0L) {
                l = 0L;
            }
            Thread.sleep(l);
        }
    }

    private void cleanupDatabasesAndViews() {
        try {
            if (this.notes_session != null) {
                this.notes_session.recycle();
                this.notes_session = null;
                return;
            }
        }
        catch (Exception exception) {}
    }

    private void logProbeError(MailProbeDoc mailProbeDoc, String string) {
        if (!this.stat_list.isActive(mailProbeDoc.getStatisticName()) || mailProbeDoc == null) {
            return;
        }
        boolean bl = false;
        this.StatUpdate(this.international_string.getString("facility_id"), mailProbeDoc.getStatisticName(), (short)0, (short)0, new Long(-1L));
        try {
            String string2 = String.valueOf(this.international_string.getString(string)) + " " + this.international_string.getString("facility_id") + "." + mailProbeDoc.getStatisticName() + " " + mailProbeDoc.getMonitorNumber();
            this.event_handle.logEvent(string2, EVENT_QUEUE_NAME, 3, mailProbeDoc.getSeverity());
            return;
        }
        catch (NotesException notesException) {
            if (!bl) {
                this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("logevent_failure"), 0);
            }
            return;
        }
    }

    private synchronized void setState(int n) {
        this.state = n;
    }
}

