/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.notes.addins.InternationalResources;

public final class MailProbeDoc {
    public static final String MAIL_PROBE_VIEW = "vaMailProbes";
    public static final String FORM_NAME = "fa_MailProbe";
    public static final String MAIL_PROBE_NAME = "MailProbeName";
    public static final String MAIL_TIMEOUT = "MailTimeOut";
    public static final String TARGET_RECIPIENT = "TargetRecipient";
    public static final String MAIL_PROBE_STATISTIC_NAME = "MailProbeStatisticName";
    public static final String MAIL_PROBE_INTERVAL = "MailProbeInterval";
    public static final String DISABLED_FLAG = "Disabled";
    public static final String EVENT_SEVERITY = "Severity";
    public static final String SOURCE_SERVER = "SourceServerName";
    public static final String ALL_SELF_MONITOR = "AllSelfMonitor";
    public static final String MONITOR_NUMBER = "MonitorNumber";
    private String probe_name;
    private int timeout;
    private String recipient;
    private String stat_name;
    private int severity;
    private String monitor_number;

    public MailProbeDoc(Document document, String string, InternationalResources internationalResources) throws NotesException {
        this.probe_name = document.getItemValueString(MAIL_PROBE_NAME);
        this.timeout = document.getItemValueInteger(MAIL_TIMEOUT);
        this.stat_name = document.getItemValueString(MAIL_PROBE_STATISTIC_NAME);
        Integer n = new Integer(document.getItemValueString(EVENT_SEVERITY));
        this.severity = n;
        if (document.getItemValueString(ALL_SELF_MONITOR) == null) {
            this.recipient = document.getItemValueString(TARGET_RECIPIENT);
            this.stat_name = document.getItemValueString(MAIL_PROBE_STATISTIC_NAME);
        } else {
            this.recipient = string;
            this.stat_name = new String();
            this.stat_name = String.valueOf(internationalResources.getString("stat_mail_str")) + "." + string + "." + internationalResources.getString("stat_response_time_str");
        }
        this.monitor_number = document.getItemValueString(MONITOR_NUMBER);
    }

    public String getMailProbeName() {
        return this.probe_name;
    }

    public int getMailTimeout() {
        return this.timeout;
    }

    public String getTargetRecipient() {
        return this.recipient;
    }

    public String getStatisticName() {
        return this.stat_name;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMonitorNumber() {
        return this.monitor_number;
    }
}

