/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Log;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.notes.addins.InternationalResources;
import lotus.notes.addins.JavaServerAddin;
import lotus.notes.addins.ispy.ISpy;
import lotus.notes.addins.ispy.ISpyFatalException;
import lotus.notes.addins.ispy.NABUtils;
import lotus.notes.addins.ispy.TCPProbeDoc;
import lotus.notes.addins.ispy.TCPSchedule;
import lotus.notes.addins.ispy.TCPServerTasks;
import lotus.notes.addins.ispy.net.portcheck.HostCheck;
import lotus.notes.addins.ispy.net.portcheck.HostCheckEvent;
import lotus.notes.addins.ispy.net.portcheck.PortCheck;
import lotus.notes.addins.ispy.net.portcheck.PortCheckEvent;
import lotus.notes.addins.ispy.util.ActiveList;
import lotus.notes.addins.ispy.util.Appointment;

public class TCPPoller
extends JavaServerAddin {
    public static final int INITIALIZING = 0;
    public static final int UPDATING_CONFIG = 1;
    public static final int PROBING = 2;
    public static final int IDLE = 3;
    private Session notes_session;
    private InternationalResources international_string;
    private View servers_view;
    private String STAT_EVENTS_DB_NAME;
    private final int ONE_MINUTE = 60000;
    private Database stat_events_db;
    private String addin_name;
    private String this_server;
    private String this_server_abbreviated_name;
    private String this_domain;
    private TCPProbeDoc current_doc;
    private int state = 0;
    public int debug;
    private Log event_handle;
    private TCPSchedule probe_schedule;
    private static String EVENT_QUEUE_NAME;
    private boolean sent_event_error_messsage = false;
    private Date nextUpdate;
    private int UPDATE_INTERVAL = 180000;
    private Date next_appointment;

    public TCPPoller(InternationalResources internationalResources, int n) {
        this.international_string = internationalResources;
        this.debug = n;
        this.STAT_EVENTS_DB_NAME = internationalResources.getString("statistics_database_name");
        this.addin_name = internationalResources.getString("addin_name");
        EVENT_QUEUE_NAME = internationalResources.getString("event_queue_name");
        this.nextUpdate = new Date();
    }

    public synchronized int getState() {
        return this.state;
    }

    public void runNotes() {
        try {
            this.initialize();
        }
        catch (NotesException notesException) {
            this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_tcppoller_initialize"), 0);
            if (notesException.text != null && notesException.text.length() > 0) {
                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + notesException.text, 0);
            }
            if (this.debug > 0 || notesException.text == null || notesException.text.length() == 0) {
                notesException.printStackTrace();
            }
            return;
        }
        try {
            Object object;
            try {
                while (this.addInRunning()) {
                    try {
                        block28: {
                            try {
                                try {
                                    this.updateConfiguration();
                                }
                                catch (NotesException notesException) {
                                    throw new ISpyFatalException(notesException.text);
                                }
                                this.next_appointment = this.probe_schedule.getTimeOfNextAppointment();
                                if (this.next_appointment != null && this.next_appointment.getTime() < System.currentTimeMillis()) {
                                    this.setState(2);
                                    if (this.debug > 0) {
                                        Date date = new Date();
                                        System.out.println(String.valueOf(date) + " ISpy: Starting IP probes...");
                                    }
                                    this.probe();
                                }
                            }
                            catch (ISpyFatalException iSpyFatalException) {
                                super.stopAddin();
                                throw iSpyFatalException;
                            }
                            catch (NotesException notesException) {
                                if (notesException.text != null && notesException.text.length() > 0) {
                                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + notesException.text, 0);
                                }
                                if (this.debug > 0 || notesException.text == null || notesException.text.length() == 0) {
                                    notesException.printStackTrace();
                                }
                            }
                            catch (Exception exception) {
                                String string = exception.getMessage();
                                if (string != null && string.length() > 0) {
                                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + exception.getMessage(), 0);
                                }
                                if (this.debug <= 0 && string != null && string.length() != 0) break block28;
                                exception.printStackTrace();
                            }
                        }
                        object = null;
                        this.cleanupDatabasesAndViews();
                        if (this.getState() == 2 && this.debug > 0) {
                            System.out.println(String.valueOf(new Date()) + " ISpy: ...IP probes complete.");
                        }
                        this.current_doc = null;
                        this.setState(3);
                    }
                    catch (Throwable throwable) {
                        object = null;
                        this.cleanupDatabasesAndViews();
                        if (this.getState() == 2 && this.debug > 0) {
                            System.out.println(String.valueOf(new Date()) + " ISpy: ...IP probes complete.");
                        }
                        this.current_doc = null;
                        this.setState(3);
                        this.sleep();
                        throw throwable;
                    }
                    this.sleep();
                }
            }
            catch (ISpyFatalException iSpyFatalException) {
                object = iSpyFatalException.getMessage();
                if (object != null && ((String)object).length() > 0) {
                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + (String)object, 0);
                }
                if (this.debug > 0 || object == null || ((String)object).length() == 0) {
                    iSpyFatalException.printStackTrace();
                }
                this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("tcp_poller_fatal"), 0);
            }
            catch (InterruptedException interruptedException) {
            }
            Object var2_15 = null;
            if (this.probe_schedule != null) {
                ActiveList activeList = this.probe_schedule.getStatList();
                object = activeList.getList();
                this.deleteStats((Vector)object);
            }
            return;
        }
        catch (Throwable throwable) {
            block29: {
                Object var2_16 = null;
                if (this.probe_schedule == null) break block29;
                ActiveList activeList = this.probe_schedule.getStatList();
                Vector vector = activeList.getList();
                this.deleteStats(vector);
            }
            throw throwable;
        }
    }

    private void deleteStats(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.StatDelete(this.international_string.getString("facility_id"), string);
        }
    }

    private synchronized void setState(int n) {
        this.state = n;
    }

    private void initialize() throws NotesException {
        Session session = null;
        try {
            session = NotesFactory.createSession();
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_session"));
            throw notesException;
        }
        try {
            this.this_server = session.getUserName();
            Name name = session.createName(this.this_server);
            this.this_server_abbreviated_name = name.getAbbreviated();
            TCPServerTasks tCPServerTasks = new TCPServerTasks(session);
            this.probe_schedule = new TCPSchedule(this.debug, this, this.this_server, this.international_string, tCPServerTasks);
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            session.recycle();
            throw throwable;
        }
        Object var3_6 = null;
        session.recycle();
    }

    private void updateConfiguration() throws NotesException {
        this.setState(1);
        try {
            this.notes_session = NotesFactory.createSession();
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_create_session"));
            throw notesException;
        }
        this.event_handle = this.notes_session.createLog("");
        if (this.nextUpdate.getTime() <= System.currentTimeMillis()) {
            if (this.debug > 1) {
                System.out.println(String.valueOf(new Date()) + " ISpy: TCPPoller updating configuration.");
            }
            Document document = null;
            try {
                document = this.getServerData();
                this.getDatabasesAndViews();
                this.next_appointment = null;
                this.probe_schedule.initialize(this.notes_session, this.servers_view, document, this.this_domain);
                return;
            }
            finally {
                Object var3_3 = null;
                if (document != null) {
                    Database database = document.getParentDatabase();
                    document.recycle();
                    database.recycle();
                }
                this.nextUpdate.setTime(System.currentTimeMillis() + (long)this.UPDATE_INTERVAL);
            }
        }
    }

    private Document getServerData() throws NotesException {
        Document document = null;
        try {
            document = NABUtils.getFirstDocumentFromAddressBook(this.notes_session, 0, this.this_server);
        }
        catch (NotesException notesException) {
            Object[] objectArray = new Object[]{this.this_server};
            String string = MessageFormat.format(this.international_string.getString("error_read_server_record"), objectArray);
            notesException.text = ISpy.updateErrString(notesException, string);
            throw notesException;
        }
        if (document == null) {
            Object[] objectArray = new Object[]{this.this_server};
            String string = MessageFormat.format(this.international_string.getString("no_server_record"), objectArray);
            throw new NotesException(0, string);
        }
        this.this_domain = document.getItemValueString("Domain");
        if (this.this_domain == null) {
            Object[] objectArray = new Object[]{this.this_server};
            String string = MessageFormat.format(this.international_string.getString("error_reading_domain"), objectArray);
            throw new NotesException(0, string);
        }
        return document;
    }

    private void getDatabasesAndViews() throws NotesException {
        try {
            this.stat_events_db = this.notes_session.getDatabase(null, this.STAT_EVENTS_DB_NAME);
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, String.valueOf(this.international_string.getString("event_db_not_found")) + " = " + this.STAT_EVENTS_DB_NAME);
            throw notesException;
        }
        if (this.stat_events_db != null) {
            boolean bl = false;
            int n = 0;
            while (n < 3) {
                try {
                    if (ISpy.openDB(this.stat_events_db)) {
                        bl = true;
                        break;
                    }
                }
                catch (NotesException notesException) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("event_db_not_found") + "(" + n + ") = " + this.STAT_EVENTS_DB_NAME, 0);
                }
                ++n;
            }
            if (!bl) {
                throw new NotesException(0, "");
            }
        } else {
            throw new NotesException(0, String.valueOf(this.international_string.getString("event_db_not_found")) + " = " + this.STAT_EVENTS_DB_NAME);
        }
        try {
            this.servers_view = null;
            this.servers_view = this.stat_events_db.getView("(vaTCPServices)");
        }
        catch (NotesException notesException) {}
        if (this.servers_view == null) {
            throw new NotesException(0, String.valueOf(this.international_string.getString("no_view")) + " = [" + "(vaTCPServices)" + "]! " + this.international_string.getString("refresh_events_db"));
        }
    }

    private void probe() throws NotesException {
        while (this.next_appointment != null && this.next_appointment.getTime() < System.currentTimeMillis() && !this.shouldTerminate()) {
            Object object;
            Appointment appointment = (Appointment)this.probe_schedule.firstElement();
            this.OSPreemptOccasionally();
            Vector vector = (Vector)appointment.getData();
            HostCheck hostCheck = (HostCheck)vector.elementAt(0);
            this.current_doc = (TCPProbeDoc)vector.elementAt(1);
            InetAddress inetAddress = this.current_doc.getIPAddress();
            int n = this.current_doc.getTimeout() * 1000;
            if (inetAddress != null) {
                hostCheck.start(n, inetAddress, n / 2);
                try {
                    hostCheck.join();
                    object = hostCheck.getResult();
                    this.checkResult((HostCheckEvent)object);
                }
                catch (InterruptedException interruptedException) {
                    hostCheck.abort();
                    try {
                        hostCheck.join();
                    }
                    catch (InterruptedException interruptedException2) {}
                }
            } else {
                object = this.current_doc.getTargetServer();
                Vector vector2 = hostCheck.getChecks();
                int n2 = vector2.size();
                int n3 = 0;
                while (n3 < n2) {
                    PortCheck portCheck = (PortCheck)vector2.elementAt(n3);
                    this.StatUpdate(this.international_string.getString("facility_id"), this.current_doc.getStatisticName(portCheck.getServiceAbbreviation()), (short)0, (short)0, new Long(-1L));
                    try {
                        this.event_handle.logEvent(String.valueOf(this.international_string.getString("error_server_no_ip_address")) + " = " + (String)object + " : " + this.international_string.getString("facility_id") + "." + this.current_doc.getStatisticName(portCheck.getServiceAbbreviation()), EVENT_QUEUE_NAME, TCPProbeDoc.getEventType(portCheck.getServiceAbbreviation()), this.current_doc.getSeverity());
                        this.sent_event_error_messsage = false;
                    }
                    catch (NotesException notesException) {
                        if (!this.sent_event_error_messsage) {
                            this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("logevent_failure"), 0);
                        }
                        this.sent_event_error_messsage = true;
                    }
                    ++n3;
                }
                this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("error_server_no_ip_address") + "= " + (String)object, 0);
            }
            inetAddress = null;
            appointment.repeat();
            this.probe_schedule.removeElementAt(0);
            this.probe_schedule.addAppointment(appointment);
            this.next_appointment = this.probe_schedule.getTimeOfNextAppointment();
        }
    }

    private void checkResult(HostCheckEvent hostCheckEvent) throws NotesException {
        if (this.current_doc == null) {
            return;
        }
        if (hostCheckEvent == null) {
            return;
        }
        Enumeration enumeration = hostCheckEvent.elements();
        while (enumeration.hasMoreElements()) {
            PortCheckEvent portCheckEvent = (PortCheckEvent)enumeration.nextElement();
            PortCheck portCheck = (PortCheck)portCheckEvent.getSource();
            Long l = portCheckEvent.status.bitset.get(1) && portCheckEvent.status.bitset.get(2) && portCheckEvent.status.bitset.get(3) ? new Long(portCheckEvent.closeMillis - portCheckEvent.openMillis) : new Long(-1L);
            this.StatUpdate(this.international_string.getString("facility_id"), this.current_doc.getStatisticName(portCheck.getServiceAbbreviation()), (short)0, (short)0, l);
            if (l.intValue() != -1) continue;
            try {
                int n = 7;
                int n2 = 2;
                if (this.current_doc != null) {
                    n = TCPProbeDoc.getEventType(portCheck.getServiceAbbreviation());
                    n2 = this.current_doc.getSeverity();
                }
                this.event_handle.logEvent(String.valueOf(this.international_string.getString("error_probe_timed_out")) + this.international_string.getString("facility_id") + "." + this.current_doc.getStatisticName(portCheck.getServiceAbbreviation()), EVENT_QUEUE_NAME, n, n2);
                this.sent_event_error_messsage = false;
            }
            catch (NotesException notesException) {
                if (!this.sent_event_error_messsage) {
                    this.AddInLogMessageText(String.valueOf(this.addin_name) + ": " + this.international_string.getString("logevent_failure"), 0);
                }
                this.sent_event_error_messsage = true;
            }
        }
    }

    private void sleep() throws InterruptedException {
        if (!this.shouldTerminate()) {
            long l = 0L;
            l = this.next_appointment == null ? this.nextUpdate.getTime() - System.currentTimeMillis() : (this.next_appointment.getTime() < this.nextUpdate.getTime() ? this.next_appointment.getTime() - System.currentTimeMillis() : this.nextUpdate.getTime() - System.currentTimeMillis());
            if (l < 0L) {
                l = 0L;
            }
            Thread.sleep(l);
        }
    }

    private void cleanupDatabasesAndViews() {
        try {
            if (this.notes_session != null) {
                this.notes_session.recycle();
                this.notes_session = null;
            }
            this.stat_events_db = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

