/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import java.net.InetAddress;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.notes.addins.InternationalResources;

public final class TCPProbeDoc {
    public static final String TCP_SERVICE_VIEW = "(vaTCPServices)";
    public static final String FORM_NAME = "fa_TCPServices";
    public static final String TARGET_SERVER = "TargetServerName";
    public static final String TCP_TIMEOUT = "TCPTimeOut";
    public static final String TCP_PROBE_INTERVAL = "TCPProbeInterval";
    public static final String HTTP_URL = "HTTPUrl";
    public static final String HTTP_URL_FETCH = "HTTPUrlFetch";
    public static final String NNTP_COMMAND_SEND = "NNTPCommandSend";
    public static final String NNTP_COMMAND = "NNTPCommand";
    public static final String NNTP_PARAMETERS = "NNTPParameters";
    public static final String NNTP_GROUP = "NNTPGroup";
    public static final String DISABLED_FLAG = "Disabled";
    public static final String EVENT_SEVERITY = "Severity";
    public static final String SOURCE_SERVER = "SourceServerName";
    public static final String ALL_SELF_MONITOR = "AllSelfMonitor";
    public static final String MONITOR_NUMBER = "MonitorNumber";
    public static final String SERVICES = "Services";
    public static final String ALL_SERVICES = "AllServices";
    public static final String ALL_TARGET_SERVERS = "AllTargetServers";
    public static final String DNS_SVC = "DNS";
    public static final String FTP_SVC = "FTP";
    public static final String HTTP_SVC = "HTTP";
    public static final String IMAP_SVC = "IMAP";
    public static final String LDAP_SVC = "LDAP";
    public static final String NNTP_SVC = "NNTP";
    public static final String POP3_SVC = "POP3";
    public static final String SMTP_SVC = "SMTP";
    public static final String[] LIST_OF_SERVICES = new String[]{new String("DNS"), new String("FTP"), new String("HTTP"), new String("IMAP"), new String("LDAP"), new String("NNTP"), new String("POP3"), new String("SMTP")};
    public static final int[] EVENT_TYPES = new int[]{11, 20, 18, 3, 3, 19, 3, 3};
    private String target_server;
    private int timeout;
    private int probe_interval;
    private int severity;
    private String http_url;
    private String http_url_fetch;
    private String nntp_cmd_send;
    private String nntp_cmd;
    private String nntp_paramaters;
    private String nntp_group;
    private String monitor_number;
    private Vector services;
    private String self_monitor;
    private String all_services;
    private InetAddress ipAddress;
    String stat_resp_time_str;

    public TCPProbeDoc(Document document, String string, InternationalResources internationalResources) throws NotesException {
        this.timeout = document.getItemValueInteger(TCP_TIMEOUT);
        this.probe_interval = document.getItemValueInteger(TCP_PROBE_INTERVAL);
        Integer n = new Integer(document.getItemValueString(EVENT_SEVERITY));
        this.severity = n;
        this.http_url_fetch = document.getItemValueString(HTTP_URL_FETCH);
        if (this.http_url_fetch.compareTo("1") == 0) {
            this.http_url = document.getItemValueString(HTTP_URL);
        }
        this.nntp_cmd_send = document.getItemValueString(NNTP_COMMAND_SEND);
        if (this.nntp_cmd_send.compareTo("1") == 0) {
            this.nntp_cmd = document.getItemValueString(NNTP_COMMAND);
            this.nntp_paramaters = document.getItemValueString(NNTP_PARAMETERS);
            this.nntp_group = document.getItemValueString(NNTP_GROUP);
        }
        this.monitor_number = document.getItemValueString(MONITOR_NUMBER);
        this.self_monitor = document.getItemValueString(ALL_SELF_MONITOR);
        this.all_services = document.getItemValueString(ALL_SERVICES);
        if (this.allServices()) {
            this.services = new Vector();
            int n2 = 0;
            while (n2 < LIST_OF_SERVICES.length) {
                this.services.addElement(LIST_OF_SERVICES[n2]);
                ++n2;
            }
        } else {
            this.services = document.getItemValue(SERVICES);
        }
        this.target_server = string;
        this.stat_resp_time_str = internationalResources.getString("stat_response_time_str");
    }

    public String getStatisticName(int n) {
        String string = new String();
        string = String.valueOf(LIST_OF_SERVICES[n]) + "." + this.target_server + "." + this.monitor_number + "." + this.stat_resp_time_str;
        return string;
    }

    public String getStatisticName(String string) {
        String string2 = new String();
        string2 = String.valueOf(string) + "." + this.target_server + "." + this.monitor_number + "." + this.stat_resp_time_str;
        return string2;
    }

    public boolean isServiceEnabled(String string) {
        return this.services.contains(string);
    }

    public boolean isServiceEnabled(int n) {
        return this.isServiceEnabled(LIST_OF_SERVICES[n]);
    }

    public String getTargetServer() {
        return this.target_server;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProbeInterval() {
        return this.probe_interval;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getHttpUrl() {
        return this.http_url;
    }

    public String getNntpCommand() {
        return this.nntp_cmd;
    }

    public String getNntpParameters() {
        return this.nntp_paramaters;
    }

    public String getNntpGroup() {
        return this.nntp_group;
    }

    public String getMonitorNumber() {
        return this.monitor_number;
    }

    public Vector getServices() {
        return this.services;
    }

    public boolean selfMonitor() {
        return this.self_monitor != null;
    }

    public boolean allServices() {
        return this.all_services != null && this.all_services.compareTo("1") == 0;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.target_server);
        stringBuffer.append(" ");
        stringBuffer.append(this.monitor_number);
        return stringBuffer.toString();
    }

    public static String getDescription(String string, Document document) throws NotesException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" ");
        String string2 = document.getItemValueString(MONITOR_NUMBER);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static int getEventType(String string) {
        try {
            int n = TCPProbeDoc.getServiceIdx(string);
            return EVENT_TYPES[n];
        }
        catch (NotesException notesException) {
            return 7;
        }
    }

    private static int getServiceIdx(String string) throws NotesException {
        int n = 0;
        while (n < LIST_OF_SERVICES.length) {
            if (string.compareTo(LIST_OF_SERVICES[n]) == 0) {
                return n;
            }
            ++n;
        }
        throw new NotesException(0, "");
    }

    public void setIPAddress(InetAddress inetAddress) {
        this.ipAddress = inetAddress;
    }

    public InetAddress getIPAddress() {
        return this.ipAddress;
    }
}

