/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.notes.addins.InternationalResources;
import lotus.notes.addins.JavaServerAddin;
import lotus.notes.addins.ispy.ISpy;
import lotus.notes.addins.ispy.NABUtils;
import lotus.notes.addins.ispy.TCPProbeDoc;
import lotus.notes.addins.ispy.TCPServerTasks;
import lotus.notes.addins.ispy.net.portcheck.HTTPCheck;
import lotus.notes.addins.ispy.net.portcheck.HostCheck;
import lotus.notes.addins.ispy.net.portcheck.IMAP4Check;
import lotus.notes.addins.ispy.net.portcheck.LDAPCheck;
import lotus.notes.addins.ispy.net.portcheck.NNTPCheck;
import lotus.notes.addins.ispy.net.portcheck.POP3Check;
import lotus.notes.addins.ispy.net.portcheck.PortCheck;
import lotus.notes.addins.ispy.net.portcheck.SMTPCheck;
import lotus.notes.addins.ispy.util.ActiveList;
import lotus.notes.addins.ispy.util.Appointment;
import lotus.notes.addins.ispy.util.Schedule;

public class TCPSchedule
extends Schedule {
    private int debug;
    private ActiveList stat_list = new ActiveList();
    private JavaServerAddin poller;
    private String this_server;
    private Date last_schedule_update_time;
    private InternationalResources international_string;
    private Session notes_session;
    private final int ONE_MINUTE = 60000;
    private String addin_name;
    private final int NOERROR = 0;
    private TCPServerTasks tcp_server_tasks;
    private InetAddress http_proxy_host;
    private int http_proxy_port = 8080;
    private Vector no_proxy_list;

    public TCPSchedule(int n, JavaServerAddin javaServerAddin, String string, InternationalResources internationalResources, TCPServerTasks tCPServerTasks) {
        this.debug = n;
        this.poller = javaServerAddin;
        this.this_server = string;
        this.international_string = internationalResources;
        this.addin_name = internationalResources.getString("addin_name");
        this.tcp_server_tasks = tCPServerTasks;
    }

    public ActiveList getStatList() {
        return this.stat_list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Session session, View view, Document document, String string) throws NotesException {
        this.notes_session = session;
        this.getHttpProxyData(document);
        try {
            Enumeration enumeration;
            Vector vector = null;
            Date date = new Date();
            DateTime dateTime = session.createDateTime(session.getInternational().getToday());
            dateTime.setNow();
            this.stat_list.reset();
            this.reset();
            Vector vector2 = this.getServersInDomain(string);
            Document document2 = null;
            Document document3 = view.getFirstDocument();
            while (document3 != null) {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    try {
                                        if (this.poller.shouldTerminate()) {
                                            enumeration = null;
                                            break block16;
                                        }
                                        if (document3.getItemValueString("Disabled") != null) {
                                            break block17;
                                        }
                                        boolean bl = false;
                                        vector = document3.getItemValue("SourceServerName");
                                        Enumeration enumeration2 = vector.elements();
                                        while (enumeration2.hasMoreElements()) {
                                            String string2 = (String)enumeration2.nextElement();
                                            if (string2.compareTo(this.this_server) != 0 && string2.compareTo("*") != 0) continue;
                                            bl = true;
                                            break;
                                        }
                                        if (!bl) {
                                            break block18;
                                        }
                                        if (this.last_schedule_update_time == null) {
                                            this.createAppointments(document3, vector2, date);
                                            break block19;
                                        }
                                        if (this.last_schedule_update_time.before(document3.getLastModified().toJavaDate())) {
                                            this.createAppointments(document3, vector2, date);
                                            break block19;
                                        } else {
                                            this.activateAppointments(document3, vector2, date);
                                        }
                                        break block19;
                                    }
                                    catch (Throwable throwable) {
                                        enumeration = null;
                                        document2 = view.getNextDocument(document3);
                                        document3.recycle();
                                        throw throwable;
                                    }
                                }
                                document2 = view.getNextDocument(document3);
                                document3.recycle();
                                break;
                            }
                            enumeration = null;
                            document2 = view.getNextDocument(document3);
                            document3.recycle();
                            break block20;
                        }
                        enumeration = null;
                        document2 = view.getNextDocument(document3);
                        document3.recycle();
                        break block20;
                    }
                    enumeration = null;
                    document2 = view.getNextDocument(document3);
                    document3.recycle();
                }
                document3 = document2;
            }
            this.removeInActive();
            if (this.debug > 1) {
                System.out.println("\nISpy: DUMPING TCP PROBE APPOINTMENTS");
            }
            this.dump(this.debug);
            Vector vector3 = this.stat_list.removeInActive();
            enumeration = vector3.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    if (this.debug > 1) {
                        System.out.println("\nISpy: DUMPING TCP POLLER STAT LIST");
                    }
                    this.stat_list.dump(this.debug);
                    this.last_schedule_update_time = dateTime.toJavaDate();
                    return;
                }
                String string3 = (String)enumeration.nextElement();
                this.poller.StatDelete(this.international_string.getString("facility_id"), string3);
            }
        }
        catch (NotesException notesException) {
            notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_init_tcp_sched"));
            throw notesException;
        }
    }

    private void getHttpProxyData(Document document) throws NotesException {
        block6: {
            try {
                String string = document.getItemValueString("Proxy_HTTP");
                if (string == null) break block6;
                int n = string.indexOf(":");
                try {
                    if (n != -1) {
                        this.http_proxy_host = InetAddress.getByName(string.substring(0, n));
                        this.http_proxy_port = Integer.parseInt(string.substring(n + 1));
                    } else {
                        this.http_proxy_host = InetAddress.getByName(string);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.http_proxy_host = null;
                }
                this.no_proxy_list = document.getItemValue("No_Proxy");
                return;
            }
            catch (NotesException notesException) {
                notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_getting_http_proxy"));
                throw notesException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getServersInDomain(String string) throws NotesException {
        Vector vector = null;
        Vector<String> vector2 = new Vector<String>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(20);
        Enumeration enumeration = null;
        try {
            block20: {
                try {
                    Throwable throwable3;
                    block26: {
                        Database database;
                        block21: {
                            vector = this.notes_session.getAddressBooks();
                            enumeration = vector.elements();
                            if (!enumeration.hasMoreElements()) break block20;
                            database = null;
                            try {
                                database = (Database)enumeration.nextElement();
                                if (!ISpy.openDB(database)) break block21;
                                View view = database.getView("($ServersLookup)");
                                Document document = null;
                                Document document2 = view.getFirstDocument();
                                while (document2 != null) {
                                    block27: {
                                        Object var15_11;
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        try {
                                                            if (this.poller.shouldTerminate()) {
                                                                var15_11 = null;
                                                                break block22;
                                                            }
                                                            String string2 = document2.getItemValueString("Domain");
                                                            if (string2 == null) {
                                                                break block23;
                                                            }
                                                            if (string2.compareTo(string) != 0) {
                                                                break block24;
                                                            }
                                                            String string3 = document2.getItemValueString("ServerName");
                                                            if (string3 == null || hashtable.containsKey(document2.getUniversalID())) break block25;
                                                            hashtable.put(document2.getUniversalID(), "");
                                                            vector2.addElement(string3);
                                                            break block25;
                                                        }
                                                        catch (Throwable throwable2) {
                                                            var15_11 = null;
                                                            document = view.getNextDocument(document2);
                                                            throw throwable2;
                                                        }
                                                    }
                                                    document = view.getNextDocument(document2);
                                                    break;
                                                }
                                                var15_11 = null;
                                                document = view.getNextDocument(document2);
                                                break block27;
                                            }
                                            var15_11 = null;
                                            document = view.getNextDocument(document2);
                                            break block27;
                                        }
                                        var15_11 = null;
                                        document = view.getNextDocument(document2);
                                    }
                                    document2 = document;
                                }
                            }
                            catch (Throwable throwable3) {
                                Object var10_16 = null;
                                if (database == null) break block26;
                                database.recycle();
                                break block26;
                            }
                        }
                        Object var10_15 = null;
                        if (database != null) {
                            database.recycle();
                        }
                        while (enumeration.hasMoreElements()) {
                            ((Database)enumeration.nextElement()).recycle();
                        }
                        break block20;
                    }
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            throw throwable3;
                        }
                        ((Database)enumeration.nextElement()).recycle();
                    }
                }
                catch (NotesException notesException) {
                    notesException.text = ISpy.updateErrString(notesException, this.international_string.getString("error_svrs_in_domain"));
                    throw notesException;
                }
            }
            Object var7_18 = null;
            if (enumeration == null) return vector2;
        }
        catch (Throwable throwable) {
            Object var7_19 = null;
            if (enumeration == null) throw throwable;
        }
        while (true) {
            if (!enumeration.hasMoreElements()) {
                return vector2;
            }
            ((Database)enumeration.nextElement()).recycle();
        }
        while (true) {
            if (!enumeration.hasMoreElements()) {
                throw throwable;
            }
            ((Database)enumeration.nextElement()).recycle();
        }
    }

    private void createAppointments(Document document, Vector vector, Date date) throws NotesException {
        Vector vector2 = this.determineTargets(document, vector);
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                TCPProbeDoc tCPProbeDoc = new TCPProbeDoc(document, string, this.international_string);
                String string2 = tCPProbeDoc.getDescription();
                Appointment appointment = this.getAppointmentWithDescription(string2, true);
                appointment = this.createTCPProbeAppointment(tCPProbeDoc, date);
                if (appointment != null) {
                    this.addAppointment(appointment);
                    this.updateStatList(appointment);
                }
                ++n;
            }
        }
    }

    private void activateAppointments(Document document, Vector vector, Date date) throws NotesException {
        block14: {
            Appointment appointment = null;
            Vector vector2 = this.determineTargets(document, vector);
            if (vector2 == null) break block14;
            int n = 0;
            while (n < vector2.size()) {
                block16: {
                    Object object;
                    String string;
                    block15: {
                        Object var11_10;
                        Object object2;
                        block13: {
                            string = (String)vector2.elementAt(n);
                            String string2 = TCPProbeDoc.getDescription(string, document);
                            appointment = this.getAppointmentWithDescription(string2, false);
                            if (appointment == null) break block15;
                            object = null;
                            try {
                                object = NABUtils.getFirstDocumentFromAddressBook(this.notes_session, 0, string);
                                if (object != null) {
                                    object2 = object.getLastModified().toJavaDate();
                                    if (this.last_schedule_update_time != null && this.last_schedule_update_time.before((Date)object2)) {
                                        TCPProbeDoc tCPProbeDoc = new TCPProbeDoc(document, string, this.international_string);
                                        appointment = this.createTCPProbeAppointment(tCPProbeDoc, date);
                                        if (appointment != null) {
                                            this.addAppointment(appointment);
                                            this.updateStatList(appointment);
                                        }
                                    } else {
                                        appointment.activate();
                                        this.updateStatList(appointment);
                                    }
                                    break block13;
                                }
                                appointment.activate();
                                this.updateStatList(appointment);
                            }
                            catch (Throwable throwable) {
                                var11_10 = null;
                                if (object != null) {
                                    try {
                                        object2 = object.getParentDatabase();
                                        object.recycle();
                                        object = null;
                                        object2.recycle();
                                        object2 = null;
                                    }
                                    catch (NotesException notesException) {}
                                }
                                throw throwable;
                            }
                        }
                        var11_10 = null;
                        if (object != null) {
                            try {
                                object2 = object.getParentDatabase();
                                object.recycle();
                                object = null;
                                object2.recycle();
                                object2 = null;
                            }
                            catch (NotesException notesException) {}
                        }
                        break block16;
                    }
                    object = new TCPProbeDoc(document, string, this.international_string);
                    appointment = this.createTCPProbeAppointment((TCPProbeDoc)object, date);
                    if (appointment != null) {
                        this.addAppointment(appointment);
                        this.updateStatList(appointment);
                    }
                }
                ++n;
            }
        }
    }

    private Vector determineTargets(Document document, Vector vector) throws NotesException {
        Vector<String> vector2 = null;
        String string = document.getItemValueString("AllSelfMonitor");
        String string2 = document.getItemValueString("AllTargetServers");
        if (string != null && string.compareTo("1") == 0) {
            vector2 = new Vector<String>(1);
            vector2.addElement(this.this_server);
        } else {
            vector2 = string2 != null && string2.compareTo("1") == 0 ? vector : document.getItemValue("TargetServerName");
        }
        return vector2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Appointment createTCPProbeAppointment(TCPProbeDoc tCPProbeDoc, Date date) {
        Object object;
        Appointment appointment = null;
        Document document = null;
        String string = null;
        try {
            block17: {
                try {
                    Object object2;
                    object = new HostCheck();
                    string = tCPProbeDoc.getTargetServer();
                    document = NABUtils.getFirstDocumentFromAddressBook(this.notes_session, 0, string);
                    InetAddress inetAddress = this.getIPAddress(document, string);
                    tCPProbeDoc.setIPAddress(inetAddress);
                    if (inetAddress == null) {
                        throw new NotesException(0, this.international_string.getString("error_server_no_ip_address"));
                    }
                    int n = 0;
                    while (n < TCPProbeDoc.LIST_OF_SERVICES.length) {
                        PortCheck portCheck;
                        if (this.isServiceEnabled(n, tCPProbeDoc, document) && (portCheck = (PortCheck)HostCheck.PORTCHECKHASHTABLE.get(object2 = TCPProbeDoc.LIST_OF_SERVICES[n])) != null) {
                            PortCheck portCheck2 = (PortCheck)portCheck.clone();
                            if (portCheck2 instanceof HTTPCheck) {
                                ((HTTPCheck)portCheck2).setPath(tCPProbeDoc.getHttpUrl());
                                if (this.http_proxy_host != null && inetAddress != null && this.useProxy(inetAddress, this.no_proxy_list)) {
                                    ((HTTPCheck)portCheck2).setProxy(this.http_proxy_host, this.http_proxy_port);
                                }
                            }
                            if (portCheck2 instanceof NNTPCheck) {
                                ((NNTPCheck)portCheck2).setCommand(tCPProbeDoc.getNntpCommand(), tCPProbeDoc.getNntpGroup(), tCPProbeDoc.getNntpParameters());
                            }
                            if ((portCheck2 = this.checkPortSettings(document, portCheck2)) != null) {
                                ((HostCheck)object).add(portCheck2);
                            }
                        }
                        ++n;
                    }
                    if (((HostCheck)object).getChecks().size() > 0) {
                        object2 = new Vector<HostCheck>();
                        ((Vector)object2).addElement(object);
                        ((Vector)object2).addElement(tCPProbeDoc);
                        appointment = new Appointment(date, tCPProbeDoc.getProbeInterval() * 60000, object2, tCPProbeDoc.getDescription());
                    }
                }
                catch (NotesException notesException) {
                    String string2 = this.international_string.getString("error_create_tcp_apptmnt");
                    Object[] objectArray = new Object[]{tCPProbeDoc.getMonitorNumber(), string};
                    String string3 = MessageFormat.format(string2, objectArray);
                    if (notesException.text != null && notesException.text.length() > 0) {
                        this.poller.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string3 + ": " + notesException.text, 0);
                    } else {
                        this.poller.AddInLogErrorText(String.valueOf(this.addin_name) + ": " + string3, 0);
                    }
                    if (this.debug <= 0) break block17;
                    notesException.printStackTrace();
                }
            }
            Object var7_17 = null;
            if (document == null) return appointment;
        }
        catch (Throwable throwable) {
            Object var7_18 = null;
            if (document == null) throw throwable;
            try {
                Database database = document.getParentDatabase();
                document.recycle();
                document = null;
                database.recycle();
                database = null;
                throw throwable;
            }
            catch (NotesException notesException) {}
            throw throwable;
        }
        try {
            object = document.getParentDatabase();
            document.recycle();
            document = null;
            object.recycle();
            object = null;
            return appointment;
        }
        catch (NotesException notesException) {}
        return appointment;
    }

    private boolean isServiceEnabled(int n, TCPProbeDoc tCPProbeDoc, Document document) {
        String string = TCPProbeDoc.LIST_OF_SERVICES[n];
        String string2 = tCPProbeDoc.getTargetServer();
        if (document != null) {
            if (string2.compareTo(this.this_server) == 0) {
                if (tCPProbeDoc.allServices()) {
                    if (string.compareTo("SMTP") != 0) {
                        return this.tcp_server_tasks.contains(string);
                    }
                    return true;
                }
                return tCPProbeDoc.isServiceEnabled(string);
            }
            if (tCPProbeDoc.allServices()) {
                if (string.compareTo("FTP") == 0 || string.compareTo("DNS") == 0) {
                    return false;
                }
                return tCPProbeDoc.isServiceEnabled(string);
            }
            return tCPProbeDoc.isServiceEnabled(string);
        }
        return tCPProbeDoc.isServiceEnabled(string);
    }

    private void updateStatList(Appointment appointment) {
        try {
            Vector vector = (Vector)appointment.getData();
            Vector vector2 = ((HostCheck)vector.elementAt(0)).getChecks();
            TCPProbeDoc tCPProbeDoc = (TCPProbeDoc)vector.elementAt(1);
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                PortCheck portCheck = (PortCheck)vector2.elementAt(n2);
                this.stat_list.addItem(tCPProbeDoc.getStatisticName(portCheck.getServiceAbbreviation()));
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private boolean useProxy(InetAddress inetAddress, Vector vector) {
        boolean bl = true;
        String string = null;
        String string2 = null;
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[0] = inetAddress.getHostName();
        stringArray[1] = inetAddress.getHostAddress();
        while (n < 2 && bl) {
            Vector vector2 = this.separateDomainElements(stringArray[n]);
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector3 = this.separateDomainElements((String)vector.elementAt(n2));
                boolean bl2 = true;
                int n3 = 0;
                while (n3 < vector3.size()) {
                    if (n3 == vector2.size()) break;
                    string = ((String)vector2.elementAt(n3)).toLowerCase();
                    string2 = ((String)vector3.elementAt(n3)).toLowerCase();
                    if (string2.compareTo(string) != 0 && string2.compareTo("*") != 0) {
                        bl2 = false;
                        break;
                    }
                    ++n3;
                }
                if (bl2) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            ++n;
        }
        return bl;
    }

    private Vector separateDomainElements(String string) {
        int n = -1;
        Vector<String> vector = new Vector<String>(4);
        String string2 = string;
        do {
            if ((n = string2.lastIndexOf(".")) != -1) {
                vector.addElement(string2.substring(n + 1));
                string2 = string2.substring(0, n);
                continue;
            }
            if (string2.length() <= 0) continue;
            vector.addElement(string2);
            string2 = null;
        } while (string2 != null);
        return vector;
    }

    private PortCheck checkPortSettings(Document document, PortCheck portCheck) {
        int n = 0;
        try {
            if (document != null) {
                if (portCheck instanceof HTTPCheck) {
                    if (document.getItemValueString("HTTP_NormalMode").compareTo("1") == 0) {
                        n = document.getItemValueInteger("HTTP_Port");
                        if (n != 0) {
                            if (((HTTPCheck)portCheck).getProxy() != null) {
                                ((HTTPCheck)portCheck).setDestPort(n);
                            } else {
                                portCheck.setPort(n);
                            }
                        }
                    } else {
                        portCheck = null;
                    }
                }
                if (portCheck instanceof NNTPCheck) {
                    if (document.getItemValueString("NNTP_PortStatus").compareTo("1") == 0) {
                        n = document.getItemValueInteger("NNTP_Port");
                        if (n != 0) {
                            portCheck.setPort(n);
                        }
                    } else {
                        portCheck = null;
                    }
                }
                if (portCheck instanceof LDAPCheck) {
                    if (document.getItemValueString("LDAP_PortStatus").compareTo("1") == 0) {
                        n = document.getItemValueInteger("LDAP_Port");
                        if (n != 0) {
                            portCheck.setPort(n);
                        }
                    } else {
                        portCheck = null;
                    }
                }
                if (portCheck instanceof POP3Check) {
                    if (document.getItemValueString("POP3_PortStatus").compareTo("1") == 0) {
                        n = document.getItemValueInteger("POP3_Port");
                        if (n != 0) {
                            portCheck.setPort(n);
                        }
                    } else {
                        portCheck = null;
                    }
                }
                if (portCheck instanceof IMAP4Check) {
                    if (document.getItemValueString("IMAP_PortStatus").compareTo("1") == 0) {
                        n = document.getItemValueInteger("IMAP_Port");
                        if (n != 0) {
                            portCheck.setPort(n);
                        }
                    } else {
                        portCheck = null;
                    }
                }
                if (portCheck instanceof SMTPCheck) {
                    if (document.getItemValueString("SMTP_PortStatus").compareTo("1") == 0 && document.getItemValueString("SMTPListenerEnabled").compareTo("1") == 0) {
                        n = document.getItemValueInteger("SMTP_Port");
                        if (n != 0) {
                            portCheck.setPort(n);
                        }
                    } else {
                        portCheck = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            portCheck = null;
        }
        return portCheck;
    }

    /*
     * Unable to fully structure code
     */
    private InetAddress getIPAddress(Document var1_1, String var2_2) {
        block7: {
            var3_3 = null;
            try {
                var3_3 = InetAddress.getByName(var2_2);
                break block7;
            }
            catch (UnknownHostException v0) {
                if (var1_1 == null) break block7;
                try {
                    var4_4 = var1_1.getItemValue("NetAddresses");
                }
                catch (NotesException v1) {
                    var4_4 = null;
                }
                if (var4_4 == null) break block7;
                var5_5 = 0;
                ** while (var5_5 < var4_4.size())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3 = InetAddress.getByName((String)var4_4.elementAt(var5_5));
                    break;
                }
                catch (UnknownHostException v2) {
                    var3_3 = null;
                    ++var5_5;
                }
                continue;
            }
        }
        return var3_3;
    }
}

