/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import lotus.notes.addins.ispy.net.Connection;

public class BinaryConnection
extends Connection {
    public static final int INPUT_STREAM = 1;
    public static final int OUTPUT_STREAM = 2;
    private static final int MASK_BYTE = 255;
    private BufferedInputStream m_in;
    private BufferedOutputStream m_out;

    public static void toUnsigned16(int n, byte[] byArray, int n2) throws IOException {
        byArray[n2] = (byte)(n / 256);
        byArray[n2 + 1] = (byte)(n % 256);
    }

    public static int parseUnsigned16(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) * 256;
        int n3 = byArray[n + 1] & 0xFF;
        return n2 + n3;
    }

    public static String toHexString(byte[] byArray) {
        return BinaryConnection.toHexString(byArray, 0);
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(3 * (byArray.length - n));
        int n2 = n;
        while (n2 < byArray.length) {
            if (n2 > n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Integer.toHexString(byArray[n2] & 0xFF));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void open(InetAddress inetAddress, int n, int n2, int n3) throws IOException {
        Socket socket = super.open(inetAddress, n, n2);
        if ((n3 & 1) != 0) {
            this.m_in = new BufferedInputStream(socket.getInputStream());
            if (this.m_in == null) {
                throw new IOException("BinaryConnection.open() BufferedInputStream == null");
            }
        }
        if ((n3 & 2) != 0) {
            this.m_out = new BufferedOutputStream(socket.getOutputStream());
            if (this.m_out == null) {
                throw new IOException("BinaryConnection.open() BufferedOutputStream == null");
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.m_out.write(byArray);
    }

    public void writeUnsigned16(int n) throws IOException {
        byte[] byArray = new byte[2];
        BinaryConnection.toUnsigned16(n, byArray, 0);
        this.m_out.write(byArray);
    }

    public void flush() throws IOException {
        this.m_out.flush();
    }

    public int available() throws IOException {
        return this.m_in.available();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_in.read(byArray, n, n2);
    }

    public int readUnsigned16() throws IOException {
        byte[] byArray = new byte[2];
        this.m_in.read(byArray, 0, 2);
        return BinaryConnection.parseUnsigned16(byArray, 0);
    }
}

