/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import lotus.notes.addins.ispy.net.Connection;

public class TextConnection
extends Connection {
    public static final String CLIENT_PREFIX = "C:";
    public static final String SERVER_PREFIX = "S:";
    public static final int CLIENT_PREFIX_LENGTH = "C:".length();
    public static final int SERVER_PREFIX_LENGTH = "S:".length();
    public static final String CRLF = "\r\n";
    protected Vector m_transactions = new Vector(10);
    private BufferedReader m_in;
    private PrintWriter m_out;

    public void open(InetAddress inetAddress, int n, int n2, int n3) throws IOException {
        Socket socket = super.open(inetAddress, n, n2);
        if ((n3 & 1) != 0) {
            this.m_in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (this.m_in == null) {
                throw new IOException("PortCheck.open() BufferedReader == null");
            }
        }
        if ((n3 & 2) != 0) {
            this.m_out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            if (this.m_out == null) {
                throw new IOException("PortCheck.open() PrintWriter == null");
            }
        }
    }

    public String readLine() throws IOException {
        String string = this.m_in.readLine();
        this.m_transactions.addElement(SERVER_PREFIX + string);
        return string;
    }

    public void println(String string) throws IOException {
        this.m_transactions.addElement(CLIENT_PREFIX + string);
        this.m_out.print(string);
        this.m_out.print(CRLF);
    }

    public void println() throws IOException {
        this.m_transactions.addElement(CLIENT_PREFIX);
        this.m_out.print(CRLF);
    }

    public void print(String string) throws IOException {
        this.m_transactions.addElement(CLIENT_PREFIX);
        this.m_out.print(string);
    }

    public void flush() throws IOException {
        this.m_out.flush();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_transactions.size() * 20);
        int n = 0;
        while (n < this.m_transactions.size()) {
            stringBuffer.append(this.m_transactions.elementAt(n));
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean test(PrintStream printStream) {
        int n = 7;
        TextConnection textConnection = new TextConnection();
        printStream.println(textConnection.getClass().getName());
        try {
            String string = "Hello World";
            String string2 = null;
            printStream.print(".open(InetAddress, int, int) - ");
            textConnection.open(InetAddress.getLocalHost(), n, 1000, 3);
            printStream.println(true);
            printStream.print(".println(String) - ");
            textConnection.println(string);
            printStream.println(true);
            printStream.print(".flush() - ");
            textConnection.flush();
            printStream.println(true);
            printStream.print(".readLine() - ");
            string2 = textConnection.readLine();
            printStream.println(true);
            printStream.print(".close() - ");
            textConnection.close();
            printStream.println(true);
            return string.equals(string2);
        }
        catch (IOException iOException) {
            printStream.println(false);
            printStream.println("Exception: " + iOException.getMessage());
            return false;
        }
    }
}

