/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy.net.dns;

import java.io.PrintStream;
import lotus.notes.addins.ispy.net.BinaryConnection;

public class DNSHeader {
    public static final int BYTE_SIZE = 12;
    public static final int OPCODE_QUERY = 0;
    public static final int OPCODE_IQUERY = 1;
    public static final int OPCODE_STATUS = 2;
    public static final boolean QR_QUERY = false;
    public static final boolean QR_RESPONSE = true;
    public static final int RCODE_NOERROR = 0;
    public static final int RCODE_FORMATERROR = 1;
    public static final int RCODE_SERVERFAILURE = 2;
    public static final int RCODE_NAMEERROR = 3;
    public static final int RCODE_NOTIMPLEMENTED = 4;
    public static final int RCODE_REFUSED = 5;
    private static final int MASK_BYTE = 255;
    private static final byte BIT_QR = -128;
    private static final byte BIT_OPCODE = 8;
    private static final byte MASK_OPCODE = 120;
    private static final byte BIT_AA = 4;
    private static final byte BIT_TC = 2;
    private static final byte BIT_RD = 1;
    private static final byte BIT_RA = -128;
    private static final byte BIT_RCODE = 1;
    private static final byte MASK_RCODE = 15;
    private int m_id;
    private boolean m_qr = false;
    private int m_opcode = 0;
    private boolean m_aa = false;
    private boolean m_tc = false;
    private boolean m_rd = false;
    private boolean m_ra = false;
    private int m_rcode = 0;
    private int m_qdcount;
    private int m_ancount;
    private int m_nscount;
    private int m_arcount;

    public DNSHeader() {
    }

    public DNSHeader(int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n3, int n4, int n5, int n6, int n7) {
        this.m_id = n;
        this.m_qr = bl;
        this.m_opcode = n2;
        this.m_aa = bl2;
        this.m_tc = bl3;
        this.m_rd = bl4;
        this.m_ra = bl5;
        this.m_rcode = n3;
        this.m_qdcount = n4;
        this.m_ancount = n5;
        this.m_nscount = n6;
        this.m_arcount = n7;
    }

    public DNSHeader(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) * 256;
        int n3 = byArray[n + 1] & 0xFF;
        this.m_id = n2 + n3;
        this.m_qr = (byArray[n + 2] & 0xFFFFFF80) != 0;
        this.m_aa = (byArray[n + 2] & 4) != 0;
        this.m_tc = (byArray[n + 2] & 2) != 0;
        this.m_rd = (byArray[n + 2] & 1) != 0;
        this.m_opcode = (byArray[n + 2] & 0x78) / 8;
        this.m_ra = (byArray[n + 3] & 0xFFFFFF80) != 0;
        this.m_rcode = byArray[n + 3] & 0xF;
        n2 = (byArray[n + 4] & 0xFF) * 256;
        n3 = byArray[n + 5] & 0xFF;
        this.m_qdcount = n2 + n3;
        n2 = (byArray[n + 6] & 0xFF) * 256;
        n3 = byArray[n + 7] & 0xFF;
        this.m_ancount = n2 + n3;
        n2 = (byArray[n + 8] & 0xFF) * 256;
        n3 = byArray[n + 9] & 0xFF;
        this.m_nscount = n2 + n3;
        n2 = (byArray[n + 10] & 0xFF) * 256;
        n3 = byArray[n + 11] & 0xFF;
        this.m_arcount = n2 + n3;
    }

    public void setId(char c) {
        this.m_id = c;
    }

    public void setQr(boolean bl) {
        this.m_qr = bl;
    }

    public void setOpcode(int n) {
        this.m_opcode = n;
    }

    public void setAa(boolean bl) {
        this.m_aa = bl;
    }

    public void setTc(boolean bl) {
        this.m_tc = bl;
    }

    public void setRd(boolean bl) {
        this.m_rd = bl;
    }

    public void setRa(boolean bl) {
        this.m_ra = bl;
    }

    public void setRcode(int n) {
        this.m_rcode = n;
    }

    public void setQdcount(int n) {
        this.m_qdcount = n;
    }

    public void setAncount(int n) {
        this.m_ancount = n;
    }

    public void setNscount(int n) {
        this.m_nscount = n;
    }

    public void setArcount(int n) {
        this.m_arcount = n;
    }

    public int getId() {
        return this.m_id;
    }

    public boolean getQr() {
        return this.m_qr;
    }

    public int getOpcode() {
        return this.m_opcode;
    }

    public boolean getAa() {
        return this.m_aa;
    }

    public boolean getTc() {
        return this.m_tc;
    }

    public boolean getRd() {
        return this.m_rd;
    }

    public boolean getRa() {
        return this.m_ra;
    }

    public int getRcode() {
        return this.m_rcode;
    }

    public int getQdcount() {
        return this.m_qdcount;
    }

    public int getAncount() {
        return this.m_ancount;
    }

    public int getNscount() {
        return this.m_nscount;
    }

    public int getArcount() {
        return this.m_arcount;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[12];
        byArray[0] = (byte)(this.m_id / 256);
        byArray[1] = (byte)(this.m_id % 256);
        byArray[2] = (byte)(this.m_opcode * 8);
        if (this.m_qr) {
            byArray[2] = (byte)(byArray[2] | 0xFFFFFF80);
        }
        if (this.m_aa) {
            byArray[2] = (byte)(byArray[2] | 4);
        }
        if (this.m_tc) {
            byArray[2] = (byte)(byArray[2] | 2);
        }
        if (this.m_rd) {
            byArray[2] = (byte)(byArray[2] | 1);
        }
        byArray[3] = (byte)this.m_rcode;
        if (this.m_ra) {
            byArray[3] = (byte)(byArray[3] | 0xFFFFFF80);
        }
        byArray[4] = (byte)(this.m_qdcount / 256);
        byArray[5] = (byte)(this.m_qdcount % 256);
        byArray[6] = (byte)(this.m_ancount / 256);
        byArray[7] = (byte)(this.m_ancount % 256);
        byArray[8] = (byte)(this.m_nscount / 256);
        byArray[9] = (byte)(this.m_nscount % 256);
        byArray[10] = (byte)(this.m_arcount / 256);
        byArray[11] = (byte)(this.m_arcount % 256);
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("ID=");
        stringBuffer.append(Integer.toString(this.m_id));
        stringBuffer.append("\nQR=");
        if (this.m_qr) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append('0');
        }
        stringBuffer.append("\nOPCODE=");
        stringBuffer.append(Integer.toString(this.m_opcode));
        stringBuffer.append("\nAA=");
        if (this.m_aa) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append('0');
        }
        stringBuffer.append("\nTC=");
        if (this.m_tc) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append('0');
        }
        stringBuffer.append("\nRD=");
        if (this.m_rd) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append('0');
        }
        stringBuffer.append("\nRA=");
        if (this.m_ra) {
            stringBuffer.append('1');
        } else {
            stringBuffer.append('0');
        }
        stringBuffer.append("\nRCODE=");
        stringBuffer.append(Integer.toString(this.m_rcode));
        stringBuffer.append("\nQDCOUNT=");
        stringBuffer.append(Integer.toString(this.m_qdcount));
        stringBuffer.append("\nANCOUNT=");
        stringBuffer.append(Integer.toString(this.m_ancount));
        stringBuffer.append("\nNSCOUNT=");
        stringBuffer.append(Integer.toString(this.m_nscount));
        stringBuffer.append("\nARCOUNT=");
        stringBuffer.append(Integer.toString(this.m_arcount));
        return stringBuffer.toString();
    }

    public String toHexString() {
        byte[] byArray = this.toByteArray();
        return BinaryConnection.toHexString(byArray);
    }

    public static boolean test(PrintStream printStream) {
        DNSHeader dNSHeader = new DNSHeader();
        printStream.println(dNSHeader.getClass().getName());
        boolean bl = true;
        printStream.print(".toString() - ");
        String string = "ID=0\nQR=0\nOPCODE=0\nAA=0\nTC=0\nRD=0\nRA=0\nRCODE=0\nQDCOUNT=0\nANCOUNT=0\nNSCOUNT=0\nARCOUNT=0";
        if (!string.equals(dNSHeader.toString())) {
            printStream.println("FAILED - " + dNSHeader.toString());
            bl = false;
        } else {
            printStream.println("PASSED");
        }
        printStream.print(".set*() - ");
        DNSHeader dNSHeader2 = dNSHeader;
        char c = '\u03e8';
        dNSHeader2.setId(c);
        dNSHeader2.setOpcode(1);
        dNSHeader2.setTc(true);
        dNSHeader2.setRcode(5);
        c = (char)(c + '\u0001');
        dNSHeader2.setQdcount(c);
        c = (char)(c + '\u0001');
        dNSHeader2.setAncount(c);
        c = (char)(c + '\u0001');
        dNSHeader2.setNscount(c);
        c = (char)(c + '\u0001');
        dNSHeader2.setArcount(c);
        String string2 = "ID=1000\nQR=0\nOPCODE=1\nAA=0\nTC=1\nRD=0\nRA=0\nRCODE=5\nQDCOUNT=1001\nANCOUNT=1002\nNSCOUNT=1003\nARCOUNT=1004";
        if (!string2.equals(dNSHeader2.toString())) {
            printStream.println("FAILED - " + dNSHeader2.toString());
            bl = false;
        } else {
            printStream.println("PASSED");
        }
        printStream.print(".toByteArray() - ");
        byte[] byArray = dNSHeader2.toByteArray();
        byte[] byArray2 = new byte[]{3, -24, 10, 5, 3, -23, 3, -22, 3, -21, 3, -20};
        boolean bl2 = true;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                bl2 = false;
            }
            ++n;
        }
        if (!bl2) {
            printStream.println("FAILED");
        } else {
            printStream.println("PASSED");
        }
        printStream.print(".DNSHeader(byte[], int) - ");
        DNSHeader dNSHeader3 = new DNSHeader(byArray, 0);
        if (!string2.equals(dNSHeader3.toString())) {
            printStream.println("FAILED - " + dNSHeader3.toString());
            bl = false;
        } else {
            printStream.println("PASSED");
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        DNSHeader.test(System.out);
    }
}

