/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy.net.dns;

import java.io.PrintStream;
import lotus.notes.addins.ispy.net.BinaryConnection;

public class DNSNameTypeClass {
    public static final int RRTYPE_A = 1;
    public static final int RRTYPE_NS = 2;
    public static final int RRTYPE_MD = 3;
    public static final int RRTYPE_MF = 4;
    public static final int RRTYPE_CNAME = 5;
    public static final int RRCLASS_IN = 1;
    public static final int RRCLASS_CS = 2;
    public static final int RRCLASS_CH = 3;
    public static final int RRCLASS_HS = 4;
    public static final int RRCLASS_WILD = 255;
    private String m_dname;
    private int m_rrtype;
    private int m_rrclass;

    public DNSNameTypeClass(String string, int n, int n2) {
        this.m_dname = string;
        this.m_rrtype = n;
        this.m_rrclass = n2;
    }

    public synchronized byte[] toByteArray() {
        int n = this.m_dname.length();
        byte[] byArray = new byte[1 + n + 1 + 2 + 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_dname.indexOf(46);
        if (n4 == -1) {
            n4 = n;
        }
        while (n3 < n) {
            byArray[n2] = (byte)(n4 - n3);
            ++n2;
            int n5 = n3;
            while (n5 < n4) {
                byArray[n2] = (byte)this.m_dname.charAt(n5);
                ++n2;
                ++n5;
            }
            n3 = n4 + 1;
            if ((n4 = this.m_dname.indexOf(46, n3)) != -1) continue;
            n4 = n;
        }
        byArray[n2] = 0;
        byArray[++n2] = (byte)(this.m_rrtype / 256);
        byArray[++n2] = (byte)(this.m_rrtype % 256);
        byArray[++n2] = (byte)(this.m_rrclass / 256);
        byArray[++n2] = (byte)(this.m_rrclass % 256);
        ++n2;
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 + this.m_dname.length() + 6 + 5 + 7 + 5);
        stringBuffer.append("NAME=");
        stringBuffer.append(this.m_dname);
        stringBuffer.append("\nTYPE=");
        stringBuffer.append(Integer.toString(this.m_rrtype));
        stringBuffer.append("\nCLASS=");
        stringBuffer.append(Integer.toString(this.m_rrclass));
        return stringBuffer.toString();
    }

    public String toHexString() {
        byte[] byArray = this.toByteArray();
        return BinaryConnection.toHexString(byArray);
    }

    public static boolean test(PrintStream printStream) {
        boolean bl;
        boolean bl2 = true;
        DNSNameTypeClass dNSNameTypeClass = new DNSNameTypeClass("lotus.com", 1, 1);
        printStream.println(dNSNameTypeClass.getClass().getName());
        printStream.print(".toString() - ");
        String string = "NAME=lotus.com\nTYPE=1\nCLASS=1";
        if (!string.equals(dNSNameTypeClass.toString())) {
            printStream.println("FAILED - " + dNSNameTypeClass.toString());
            bl2 = false;
        } else {
            printStream.println("PASSED");
        }
        printStream.print(".toByteArray() - ");
        byte[] byArray = dNSNameTypeClass.toByteArray();
        byte[] byArray2 = new byte[15];
        byArray2[0] = 5;
        byArray2[1] = 108;
        byArray2[2] = 111;
        byArray2[3] = 116;
        byArray2[4] = 117;
        byArray2[5] = 115;
        byArray2[6] = 3;
        byArray2[7] = 99;
        byArray2[8] = 111;
        byArray2[9] = 109;
        byArray2[12] = 1;
        byArray2[14] = 1;
        byte[] byArray3 = byArray2;
        boolean bl3 = bl = byArray.length == byArray3.length;
        if (bl) {
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray3[n]) {
                    bl = false;
                }
                ++n;
            }
        }
        if (!bl) {
            printStream.println("FAILED - " + dNSNameTypeClass.toHexString());
        } else {
            printStream.println("PASSED");
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        DNSNameTypeClass.test(System.out);
    }
}

