/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.addins.ispy.net.portcheck;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import lotus.notes.addins.ispy.net.portcheck.DAYTIMECheck;
import lotus.notes.addins.ispy.net.portcheck.DNSCheck;
import lotus.notes.addins.ispy.net.portcheck.ECHOCheck;
import lotus.notes.addins.ispy.net.portcheck.FINGERCheck;
import lotus.notes.addins.ispy.net.portcheck.FTPCheck;
import lotus.notes.addins.ispy.net.portcheck.HTTPCheck;
import lotus.notes.addins.ispy.net.portcheck.HostCheckEvent;
import lotus.notes.addins.ispy.net.portcheck.IMAP4Check;
import lotus.notes.addins.ispy.net.portcheck.LDAPCheck;
import lotus.notes.addins.ispy.net.portcheck.NNTPCheck;
import lotus.notes.addins.ispy.net.portcheck.POP3Check;
import lotus.notes.addins.ispy.net.portcheck.PortCheck;
import lotus.notes.addins.ispy.net.portcheck.PortCheckEvent;
import lotus.notes.addins.ispy.net.portcheck.PortCheckListener;
import lotus.notes.addins.ispy.net.portcheck.SMTPCheck;
import lotus.notes.addins.ispy.net.portcheck.TELNETCheck;

public class HostCheck
implements Runnable,
PortCheckListener {
    public static PortCheck[] PORTCHECKARRAY = new PortCheck[]{new DAYTIMECheck(), new DNSCheck(), new ECHOCheck(), new FINGERCheck(), new FTPCheck(), new HTTPCheck(), new IMAP4Check(), new LDAPCheck(), new NNTPCheck(), new POP3Check(), new SMTPCheck(), new TELNETCheck()};
    public static final Hashtable PORTCHECKHASHTABLE = new Hashtable(PORTCHECKARRAY.length);
    public static final HostCheck HOSTCHECK = new HostCheck();
    private Vector m_checks = new Vector(12);
    private Thread m_thread;
    protected int m_timeoutMillis = -1;
    protected InetAddress m_host;
    protected int m_slowMillis = -1;
    private HostCheckEvent m_result;
    private int m_state = 0;
    private static final int RUNNING = 0;
    private static final int WAITING = 1;
    private static final int STOPPING = 2;

    public InetAddress getHost() {
        return this.m_host;
    }

    public void add(PortCheck portCheck) {
        this.m_checks.addElement(portCheck);
    }

    public void start(int n, InetAddress inetAddress, int n2) {
        this.m_timeoutMillis = n;
        this.m_host = inetAddress;
        this.m_slowMillis = n2;
        this.m_thread = new Thread(this);
        this.setState(0);
        this.m_thread.start();
    }

    public synchronized void abort() {
        this.setState(2);
        this.notify();
    }

    public void run() {
        this.m_result = new HostCheckEvent(this, this.m_checks.size());
        long l = System.currentTimeMillis();
        this.waitForResults();
        int n = this.m_checks.size();
        int n2 = 0;
        while (n2 < n) {
            PortCheck portCheck = (PortCheck)this.m_checks.elementAt(n2);
            portCheck.abort();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            PortCheck portCheck = (PortCheck)this.m_checks.elementAt(n3);
            try {
                portCheck.join();
            }
            catch (InterruptedException interruptedException) {}
            if (!this.m_result.contains(portCheck)) {
                PortCheckEvent portCheckEvent = PortCheckEvent.getTimeout(portCheck, l, this.m_timeoutMillis);
                this.m_result.add(portCheckEvent);
            }
            ++n3;
        }
    }

    public HostCheckEvent getResult() {
        return this.m_result;
    }

    public synchronized void checkResult(PortCheckEvent portCheckEvent) {
        if (this.m_state == 1) {
            this.m_result.add(portCheckEvent);
            if (this.m_result.size() >= this.m_checks.size()) {
                this.notify();
            }
        }
    }

    public Object clone() {
        HostCheck hostCheck = new HostCheck();
        hostCheck.m_checks = (Vector)this.m_checks.clone();
        return hostCheck;
    }

    public Vector getChecks() {
        return (Vector)this.m_checks.clone();
    }

    public void join() throws InterruptedException {
        if (this.m_thread != null) {
            this.m_thread.join();
        }
    }

    private synchronized void setState(int n) {
        this.m_state = n;
    }

    private synchronized void waitForResults() {
        if (this.m_state == 2) {
            return;
        }
        int n = this.m_checks.size();
        int n2 = 0;
        while (n2 < n) {
            PortCheck portCheck = (PortCheck)this.m_checks.elementAt(n2);
            portCheck.start(this, this.m_host, this.m_slowMillis);
            ++n2;
        }
        this.setState(1);
        try {
            this.wait(this.m_timeoutMillis);
        }
        catch (InterruptedException interruptedException) {}
        if (this.m_state != 2) {
            this.setState(0);
        }
    }

    static {
        int n = 0;
        while (n < PORTCHECKARRAY.length) {
            PortCheck portCheck = PORTCHECKARRAY[n];
            PORTCHECKHASHTABLE.put(portCheck.getServiceAbbreviation(), portCheck);
            HOSTCHECK.add(portCheck);
            ++n;
        }
    }
}

