/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.reports;

import java.io.File;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.AgentBase;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.util.Platform;
import lotus.notes.apps.reports.InternationalResources;
import lotus.notes.apps.reports.RepChart;
import lotus.notes.apps.reports.RepDef;
import lotus.notes.apps.reports.RepQuery;

public class RepAgent
extends AgentBase {
    private String debug;
    private InternationalResources international_string;
    public Session mSession;
    public AgentContext mContext;

    native String NdoReport(String var1, int var2, String var3, String var4, String var5);

    native String NgetTempPath();

    native void NputChartInDoc(String var1, int var2, String var3, String var4);

    public void NotesMain() {
        try {
            this.international_string = new InternationalResources("lotus/notes/apps/reports/ReportsResources");
            this.mSession = this.getSession();
            this.mContext = this.mSession.getAgentContext();
            this.debug = this.mSession.getEnvironmentString(this.international_string.getString("ini_debug_string"), true);
            if (this.debug != null && this.debug.length() == 0) {
                this.debug = null;
            }
            this.makeReports();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void makeReports() {
        int n;
        DocumentCollection documentCollection;
        Database database;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            database = this.mContext.getCurrentDatabase();
            documentCollection = this.mContext.getUnprocessedDocuments();
            string = database.getServer();
            string2 = database.getFilePath();
            string3 = this.international_string.getString("mtstore_db");
            n = documentCollection.getCount();
            if (this.debug != null) {
                System.out.println("Username = " + this.mContext.getEffectiveUserName());
            }
            if (this.debug != null) {
                System.out.println("Agent Name = " + this.mContext.getCurrentAgent().getName());
            }
            if (this.debug != null) {
                System.out.println("Documents to process = " + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n2 = 1;
        while (n2 <= n) {
            block48: {
                try {
                    int n3;
                    Object object;
                    String string5;
                    Object object2;
                    if (this.debug != null) {
                        System.out.println("Processing document #" + n2);
                    }
                    Object object3 = documentCollection.getNthDocument(n2);
                    this.mContext.updateProcessedDoc((Document)object3);
                    String string6 = object3.getItemValueString("ReportGenInterval");
                    if (string6 == null) break block48;
                    if (string6.compareTo("ka_Once") != 0) {
                        if (this.debug != null) {
                            System.out.println("Scheduled report.");
                        }
                        if (this.mContext.getCurrentAgent().getName().indexOf("aaWebOneTimeReportAgent") != -1) break block48;
                        object2 = database.createDocument();
                        object3.copyAllItems((Document)object2, true);
                        object3 = object2;
                    } else {
                        if (this.debug != null) {
                            System.out.println("One-time report.");
                        }
                        object2 = this.mSession.getEnvironmentString("ReportRequestID", false);
                        if (this.debug != null) {
                            System.out.println("ini_id = " + (String)object2);
                        }
                        string5 = object3.getItemValueString("ReportRequestID");
                        if (this.debug != null) {
                            System.out.println("doc_id = " + string5);
                        }
                        if (object2 != null && ((String)object2).compareTo(string5) != 0) {
                            if (this.debug != null) {
                                System.out.println("This document was created by someone else.");
                            }
                            break block48;
                        }
                    }
                    object3.replaceItemValue("Type", "ka_Response");
                    object3.save(true);
                    object2 = new RepQuery(this, (Document)object3, database);
                    if (this.debug != null) {
                        System.out.println("new ReqQuery =" + ((RepQuery)object2).toString());
                    }
                    if (object2 != null && ((RepQuery)object2).getReportId() != null) {
                        string5 = null;
                        object = null;
                        n3 = 1;
                        if (this.debug != null) {
                            System.out.println("BEFORE: issueRequest");
                        }
                        try {
                            string5 = this.issueRequest((RepQuery)object2, (Document)object3, string, string2, string3);
                        }
                        catch (Exception exception) {
                            n3 = 0;
                            object = exception.getMessage();
                        }
                        string4 = object3.getUniversalID();
                        object3.recycle();
                        object3 = database.getDocumentByUNID(string4);
                        if (this.debug != null) {
                            System.out.println("AFTER : issueRequest");
                        }
                        if (n3 != 0) {
                            if (string5 != null && string5.length() > 0) {
                                if (this.debug != null) {
                                    System.out.println("BEFORE: makeRowsFromCsv");
                                }
                                Vector vector = this.makeRowsFromCsv(string5);
                                if (this.debug != null) {
                                    System.out.println("AFTER : makeRowsFromCsv");
                                }
                                if (((RepQuery)object2).getReportId() != null && ((RepQuery)object2).getReportId() != 11) {
                                    if (this.debug != null) {
                                        System.out.println("BEFORE: makeChart");
                                    }
                                    try {
                                        this.makeChart((RepQuery)object2, (Document)object3, vector, string, string2);
                                        string4 = object3.getUniversalID();
                                        object3.recycle();
                                        object3 = database.getDocumentByUNID(string4);
                                    }
                                    catch (Exception exception) {
                                        object = exception.getMessage();
                                        if (object != null) {
                                            if (this.debug != null) {
                                                System.out.println("Error returned from makeChart = " + (String)object);
                                                exception.printStackTrace();
                                            }
                                            try {
                                                object3.replaceItemValue("ReportChart", this.international_string.getString((String)object));
                                            }
                                            catch (MissingResourceException missingResourceException) {
                                                object3.replaceItemValue("ReportChart", this.international_string.getString("error_gif_failed"));
                                            }
                                            object3.save(true);
                                        }
                                        object3.replaceItemValue("ReportChart", this.international_string.getString("error_request_failed"));
                                        object3.save(true);
                                    }
                                    if (this.debug != null) {
                                        System.out.println("AFTER : makeChart");
                                    }
                                }
                            } else {
                                object3.replaceItemValue("ReportChart", this.international_string.getString("no_responses"));
                                object3.save(true);
                            }
                        } else if (object != null) {
                            object3.replaceItemValue("ReportChart", this.international_string.getString((String)object));
                            object3.save(true);
                        } else {
                            object3.replaceItemValue("ReportChart", this.international_string.getString("error_request_failed"));
                            object3.save(true);
                        }
                    }
                    object3.save(true);
                    string5 = object3.getItemValueString("ResultDisposition");
                    if (string5.compareTo("ka_Saved") == 0) break block48;
                    object = object3.getItemValue("MailRecipient");
                    if (this.debug != null) {
                        n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            if (this.debug != null) {
                                System.out.println("Send mail message to " + (String)((Vector)object).elementAt(n3));
                            }
                            ++n3;
                        }
                    }
                    try {
                        RepDef repDef = RepDef.getDef(((RepQuery)object2).getReportId());
                        object3.appendItemValue("Subject", repDef.getDisplayName());
                        object3.replaceItemValue("Form", "faReportOutput");
                        object3.send(true, (Vector)object);
                        if (string5.compareTo("ka_Mailed") == 0) {
                            object3.remove(true);
                            if (this.debug != null) {
                                System.out.println("Deleted Scheduled report that was mailed.");
                            }
                        }
                    }
                    catch (NotesException notesException) {
                        if (this.debug != null) {
                            System.out.println("Mailing of report failed.");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
    }

    Vector makeRowsFromCsv(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            Vector<String> vector2 = new Vector<String>();
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                vector2.addElement(string3);
            }
            vector.addElement(vector2);
        }
        return vector;
    }

    public String issueRequest(RepQuery repQuery, Document document, String string, String string2, String string3) throws Exception {
        String string4 = null;
        try {
            int n = Integer.parseInt(document.getNoteID(), 16);
            string4 = this.NdoReport(repQuery.toString(), n, string, string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception();
        }
        return string4;
    }

    public void makeChart(RepQuery repQuery, Document document, Vector vector, String string, String string2) throws Exception {
        String string3;
        RepChart repChart;
        int n = repQuery.getReportId();
        RepDef repDef = RepDef.getDef(n);
        String string4 = "error_windowing_not_active";
        Vector vector2 = this.getColumnFrom(repDef.getChartLabelCol(), vector);
        Vector vector3 = this.getColumnFrom(repDef.getChartValueCol(), vector);
        if (this.debug != null) {
            System.out.println("BEFORE: new RepChart");
        }
        try {
            repChart = new RepChart(repDef, vector2, vector3);
        }
        catch (InternalError internalError) {
            if (this.debug != null) {
                internalError.printStackTrace();
            }
            throw new Exception(string4);
        }
        if (repChart == null || !repChart.isValid()) {
            return;
        }
        if (this.debug != null) {
            System.out.println("AFTER : new RepChart");
        }
        if (!(string3 = this.NgetTempPath()).endsWith(File.separator)) {
            string3 = new String(String.valueOf(string3) + File.separator);
        }
        if (this.debug != null) {
            System.out.println("BEFORE: writeAsTempGif");
        }
        String string5 = repChart.writeAsTempGif(string3);
        if (this.debug != null) {
            System.out.println("AFTER : writeAsTempGif");
        }
        int n2 = Integer.parseInt(document.getNoteID(), 16);
        if (this.debug != null) {
            System.out.println("BEFORE: NputChartInDoc");
        }
        if (this.debug != null) {
            System.out.println("File = " + string5);
        }
        this.NputChartInDoc(string5, n2, string, string2);
        if (this.debug != null) {
            System.out.println("AFTER : NputChartInDoc");
        }
        repChart.cleanUp();
        repChart = null;
    }

    public Vector getColumnFrom(int n, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = "";
            Vector vector3 = (Vector)enumeration.nextElement();
            if (vector3 != null && n < vector3.size()) {
                string = (String)vector3.elementAt(n);
            }
            vector2.addElement(string);
        }
        return vector2;
    }

    static {
        String string = "wmsgtrc";
        String string2 = Platform.getLibName(string);
        System.loadLibrary(string2);
    }
}

