/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.reports;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import lotus.notes.apps.reports.InternationalResources;
import lotus.notes.apps.reports.RepDef;

public class RepChart {
    public static final int cNoChart = 0;
    public static final int cPieChart = 1;
    public static final int cBarChart = 2;
    public static final int cAllItems = -1;
    public static final int cMinChartItems = 10;
    public static final boolean cUseLegend = true;
    public static final boolean cNoLegend = false;
    public static final boolean cUseAxis = true;
    public static final boolean cNoAxis = false;
    public static final String cRectShape = "RECT";
    public static final String cPolyShape = "POLYGON";
    public static final String cCircleShape = "CIRCLE";
    public static final int cPieChartSize = 250;
    public static final int cPieChartLeftMargin = 100;
    public static final int cBarChartHeight = 250;
    public static final int cBarChartWidth = 500;
    public static final int cBarChartLeftMargin = 10;
    public static final int cLegendExtra = 180;
    public static final int cAxisExtra = 40;
    public static final int cColorKeyBoxSize = 20;
    public static final int cChartHorizMargin = 10;
    public static final int cChartVertMargin = 2;
    public static final int cBarVertMarginPct = 20;
    public static final int cBarMaxHeight = 246;
    public static final int cGridDivisions = 10;
    public static final int cGridLabelSpace = 10;
    public static final int cGridFontSize = 10;
    public static final int cGridFontStyle = 0;
    public static final String cGridFontFace = "Ariel";
    private String cBadChartError;
    public static final String cGifExt = ".gif";
    private InternationalResources international_string;
    private static Vector sRowColors = new Vector();
    private static Vector sBarColors;
    protected int mChartType;
    protected int mChartWidth;
    protected int mChartHeight;
    protected int mAxisHeight;
    protected int mChartItemMax;
    protected boolean mUseLegend;
    protected boolean mUseAxis;
    protected int mAxisWidth;
    protected String mAxisDelims;
    protected Vector mLabels;
    protected Vector mValues;
    protected String mChartSpec = "";
    protected Vector mColorKeyBoxSpecs = new Vector();
    protected Vector mColorKeyHexStrings = new Vector();
    protected Vector mAreaCoords = new Vector();
    protected String mAreaShape = new String("RECT");
    protected int mCycleCount;
    protected Image mImage;
    Frame mImageWin;

    public static void writeImageAsGif(Image image, String string) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            Class.forName("Acme.JPM.Encoders.GifEncoder");
            fileOutputStream = new FileOutputStream(string);
            GifEncoder gifEncoder = new GifEncoder(image, (OutputStream)fileOutputStream);
            gifEncoder.encode();
            fileOutputStream.close();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            File file = new File(string);
            file.delete();
            throw new Exception("no_acme_package");
        }
    }

    public int getChartType() {
        return this.mChartType;
    }

    public int getChartWidth() {
        return this.mChartWidth;
    }

    public int getChartHeight() {
        return this.mChartHeight;
    }

    public int getChartItemMax() {
        return this.mChartItemMax;
    }

    public boolean useLegend() {
        return this.mUseLegend;
    }

    public boolean useAxis() {
        return this.mUseAxis;
    }

    public int axisWidth() {
        return this.mAxisWidth;
    }

    public String axisDelims() {
        return this.mAxisDelims;
    }

    public Vector getLabels() {
        return this.mLabels;
    }

    public Vector getValues() {
        return this.mValues;
    }

    public Vector getColorKeyBoxSpecs() {
        return this.mColorKeyBoxSpecs;
    }

    public Vector getColorKeyHexStrings() {
        return this.mColorKeyHexStrings;
    }

    public Vector getAreaCoords() {
        return this.mAreaCoords;
    }

    public String getAreaShape() {
        return this.mAreaShape;
    }

    public Image getImage() {
        return this.mImage;
    }

    public RepChart(RepDef repDef, Vector vector, Vector vector2) throws Exception {
        this.international_string = new InternationalResources("lotus/notes/apps/reports/ReportsResources");
        this.mChartType = repDef.getChartType();
        this.mUseLegend = repDef.useLegend();
        this.mUseAxis = repDef.useAxis();
        this.mAxisWidth = repDef.getAxisWidth();
        this.mAxisDelims = repDef.getAxisDelims();
        this.mLabels = vector;
        this.mValues = vector2;
        repDef.getChartItemMax();
        this.mChartItemMax = this.mChartItemMax == -1 ? vector2.size() : this.mChartItemMax;
        this.mChartItemMax = Math.max(this.mChartItemMax, 10);
        this.mImageWin = new Frame();
        this.mImageWin.addNotify();
        this.mAxisHeight = 0;
        switch (this.mChartType) {
            case 1: {
                this.mChartWidth = 250 + (this.mUseLegend ? 0 : 180);
                this.mChartHeight = 250 + (this.mUseLegend ? 0 : 180);
                break;
            }
            case 2: {
                this.mChartWidth = 500 + (this.mUseLegend ? 0 : 180);
                this.mChartHeight = 250;
                if (!this.mUseAxis) break;
                this.mAxisHeight = 40;
                break;
            }
        }
        this.makeColorKeyHexStrings();
        this.makeChart();
    }

    public void writeAsGif(String string) throws Exception {
        if (this.mImage == null) {
            return;
        }
        RepChart.writeImageAsGif(this.mImage, string);
    }

    public String writeAsTempGif(String string) throws Exception {
        this.mChartSpec = this.makeTempSpec(string);
        this.writeAsGif(this.mChartSpec);
        return this.mChartSpec;
    }

    public synchronized String makeTempSpec(String string) {
        ++this.mCycleCount;
        if (this.mCycleCount > 1000) {
            this.mCycleCount = 0;
        }
        Date date = new Date();
        long l = date.getTime();
        return String.valueOf(string) + l + "-" + this.mCycleCount + cGifExt;
    }

    public void writeColorKeyBoxes(String string) throws Exception {
        this.mColorKeyBoxSpecs.removeAllElements();
        int n = Math.min(this.mChartItemMax, this.mValues.size());
        n = Math.min(n, sRowColors.size());
        int n2 = 0;
        while (n2 < n) {
            Color color = this.getColorForBar(n2);
            if (color != null) {
                String string2 = this.makeColorHexString(color);
                String string3 = String.valueOf(string) + string2 + cGifExt;
                this.mColorKeyBoxSpecs.addElement(string3);
                File file = new File(string3);
                if (!file.exists()) {
                    Image image = this.mImageWin.createImage(20, 20);
                    if (image == null) {
                        return;
                    }
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, 20, 20);
                    RepChart.writeImageAsGif(image, string3);
                }
            }
            ++n2;
        }
    }

    private void makeColorKeyHexStrings() {
        this.mColorKeyHexStrings.removeAllElements();
        int n = Math.min(this.mChartItemMax, this.mValues.size());
        n = Math.min(n, sRowColors.size());
        int n2 = 0;
        while (n2 < n) {
            Color color = this.getColorForBar(n2);
            if (color != null) {
                String string = this.makeColorHexString(color);
                this.mColorKeyHexStrings.addElement("#" + string);
            }
            ++n2;
        }
    }

    private String makeColorHexString(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return String.valueOf(string) + string2 + string3;
    }

    private void makeChart() throws Exception {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n4 < this.mChartItemMax && n4 < this.mValues.size()) {
            String string = (String)this.mValues.elementAt(n4);
            if (string != null && string.length() >= 1) {
                Integer n5 = new Integer(string);
                int n6 = n5;
                if (n6 < n2) {
                    n2 = n6;
                }
                if (n6 > n3) {
                    n3 = n6;
                }
                n += n6;
            }
            ++n4;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0;
        }
        if (n3 == Integer.MIN_VALUE) {
            n3 = 0;
        }
        if (n3 < 1) {
            n2 = 0;
            n3 = 2;
        }
        if (n2 == n3) {
            n2 = (int)Math.ceil((double)n3 * 0.9);
        }
        this.makeImage();
        switch (this.mChartType) {
            case 1: {
                this.mAreaShape = cPolyShape;
                this.makePieChart(n);
                return;
            }
            case 2: {
                this.mAreaShape = cRectShape;
                this.makeBarChart(n2, n3);
                return;
            }
        }
    }

    private void makeImage() {
        this.mImage = this.mImageWin.createImage(this.mChartWidth, this.mChartHeight + this.mAxisHeight);
        if (this.mImage == null) {
            return;
        }
        Graphics graphics = this.mImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.mChartWidth, this.mChartHeight + this.mAxisHeight);
    }

    private void makePieChart(int n) throws Exception {
        if (n == 0) {
            throw new Exception(this.cBadChartError);
        }
        Graphics graphics = this.mImage.getGraphics();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mChartItemMax && n3 < this.mValues.size()) {
            Color color = (Color)sRowColors.elementAt(n3);
            graphics.setColor(color);
            int n4 = this.getValue(this.mValues, n3);
            if (n4 >= 0) {
                int n5 = 360 * n4 / n;
                if (n3 == this.mChartItemMax - 1 || n3 == this.mValues.size() - 1) {
                    n5 = 360 - n2;
                }
                graphics.fillArc(0, 0, 250, 250, n2, n5);
                n2 += n5;
            }
            ++n3;
        }
    }

    private void makeBarChart(int n, int n2) throws Exception {
        Graphics graphics = this.mImage.getGraphics();
        int n3 = this.drawBarChartGrid(graphics, n, n2);
        int n4 = Math.min(this.mChartItemMax, this.mValues.size());
        int n5 = this.mChartWidth - n3 - 10;
        int n6 = n5 / (2 * n4 + 1);
        int n7 = n3 + 10 + n6;
        int n8 = this.mChartHeight - 2;
        this.drawBaseLine(graphics, n7, n8, n4, n6);
        if (this.useAxis()) {
            this.drawAxis(graphics, n7, n8, n4, n6);
        }
        this.drawBars(graphics, n7, n8, n4, n6, n, n2);
    }

    private int drawBarChartGrid(Graphics graphics, int n, int n2) throws Exception {
        int n3 = this.calcBarFloor(n, n2);
        int n4 = this.calcBarCeil(n, n2);
        int n5 = this.calcGridScale(Math.abs(n4 - n3));
        Font font = new Font(cGridFontFace, 0, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n6 = fontMetrics.getHeight();
        int n7 = 0;
        String string = this.numericLabelFor(n4);
        int n8 = fontMetrics.stringWidth(string) + 10;
        int n9 = this.mChartHeight - 2 - n6;
        int n10 = n3;
        while (n10 < n4) {
            if (n5 == 0 || n10 % n5 == 0) {
                int n11 = this.calcBarHeight(n10, n, n2);
                int n12 = 10 + n8;
                int n13 = this.mChartHeight - 2 - n11;
                string = this.numericLabelFor(n10);
                int n14 = n12 - fontMetrics.stringWidth(string) - 10;
                int n15 = n13 + n6 / 2 - 1;
                if (n15 < n9 && n15 > n6) {
                    n9 = n15 - n6 - n7;
                    graphics.setColor(Color.black);
                    graphics.drawString(string, n14, n15);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n12, n13, this.mChartWidth - 10, n13);
                }
            }
            ++n10;
        }
        return n8;
    }

    private void drawBaseLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3 * (n4 * 2);
        n5 = Math.min(n5, this.mChartWidth - 10);
        graphics.setColor(Color.black);
        graphics.drawLine(n - n4, n2, n5, n2);
        graphics.drawLine(n - n4, n2 + 1, n5, n2 + 1);
    }

    private void drawAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n4 / 2;
        int n6 = n2 + this.mAxisHeight / 2;
        Font font = new Font(cGridFontFace, 0, 9);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n7 = fontMetrics.getHeight() / 2;
        graphics.setColor(Color.black);
        int n8 = 0;
        while (n8 < n3) {
            String string = (String)this.mLabels.elementAt(n8);
            if (string != null && string.length() >= 1) {
                int n9;
                int n10 = Math.min(this.mAxisWidth, string.length());
                int n11 = 0;
                while (n11 < n10) {
                    n9 = string.charAt(n11);
                    if (this.mAxisDelims.indexOf(n9) != -1) {
                        n10 = n11;
                    }
                    ++n11;
                }
                if (n10 >= 1) {
                    string = string.substring(0, n10);
                    n9 = fontMetrics.stringWidth(string) / 2;
                    graphics.drawString(string, n5 - n9, n6 - n7);
                    n5 += n4 * 2;
                }
            }
            ++n8;
        }
    }

    private void drawBars(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            Color color;
            if (n8 < sRowColors.size()) {
                try {
                    color = this.getColorForBar(n8);
                }
                catch (Exception exception) {
                    color = Color.white;
                }
            } else {
                color = Color.white;
            }
            if ((n9 = this.getValue(this.mValues, n8)) > 0) {
                int n10 = this.calcBarHeight(n9, n5, n6);
                int n11 = n2 - n10;
                this.drawBar(graphics, n7, n11, n4, n10, color);
                String string = String.valueOf(n7) + "," + n11 + "," + (n7 + n4) + "," + (n11 + n10);
                this.mAreaCoords.addElement(string);
            }
            n7 += n4 * 2;
            ++n8;
        }
    }

    private void drawBar(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(Color.black);
        graphics.drawRect(n - 1, n2 - 1, n3 + 1, n4);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
    }

    private void draw3dRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(Color.lightGray);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawLine(n + n5 - n6, n2 + n6, n + n3 - (n6 + 1), n2 + n6);
            ++n6;
        }
        graphics.setColor(color.darker());
        int n7 = 1;
        while (n7 <= n5) {
            graphics.drawLine(n + n3 - n7, n2 + n7 - 1, n + n3 - n7, n2 + n4 - n5 + n7);
            ++n7;
        }
        graphics.setColor(color);
        graphics.fillRect(n, n2 + n5, n3 - n5, n4);
    }

    private int calcBarVertMargin(int n, int n2) {
        double d;
        double d2;
        double d3 = Math.abs(n2 - n);
        if (d3 < (d2 = Math.max(10.0, Math.pow(10.0, (d = (double)this.calcOrderOfMag(n2)) - 1.0)))) {
            d3 = d2;
        }
        double d4 = 20.0 * d3 / 100.0;
        return (int)Math.round(d4);
    }

    private int calcBarFloor(int n, int n2) {
        int n3 = this.calcBarVertMargin(n, n2);
        return Math.max(0, n - n3);
    }

    private int calcBarCeil(int n, int n2) {
        int n3 = this.calcBarVertMargin(n, n2);
        return n2 + n3;
    }

    private int calcBarHeight(int n, int n2, int n3) {
        int n4 = this.calcBarFloor(n2, n3);
        float f = this.calcPixelsPerValue(n2, n3);
        Float f2 = new Float((float)(n - n4) * f);
        return f2.intValue();
    }

    private float calcPixelsPerValue(int n, int n2) {
        int n3 = this.calcBarFloor(n, n2);
        int n4 = this.calcBarCeil(n, n2);
        int n5 = Math.abs(n4 - n3);
        float f = 0.0f;
        f = n5 < 1 ? 246.0f : 246.0f / (float)n5;
        return f;
    }

    private int calcGridScale(int n) throws Exception {
        int n2 = this.calcOrderOfMag(n);
        double d = Math.min(1.0, Math.pow(10.0, n2 - 1));
        if (d == 0.0) {
            throw new Exception(this.cBadChartError);
        }
        double d2 = (double)Math.round((double)n / d) * d;
        double d3 = d2 / 10.0;
        return (int)Math.round(d3);
    }

    private int calcOrderOfMag(float f) {
        int n = 0;
        while (f > 1.0f) {
            f /= 10.0f;
            ++n;
        }
        return n;
    }

    private String numericLabelFor(int n) {
        String string = Integer.toString(n);
        int n2 = string.length();
        if (n2 > 4) {
            String string2 = new String();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0 && n3 % 3 == 0) {
                    string2 = "," + string2;
                }
                string2 = String.valueOf(string.charAt(n2 - n3 - 1)) + string2;
                ++n3;
            }
            string = string2;
        }
        return string;
    }

    private int getValue(Vector vector, int n) {
        String string = (String)vector.elementAt(n);
        if (string == null) {
            return -1;
        }
        Integer n2 = new Integer(string);
        return n2;
    }

    public boolean isValid() {
        return this.mImage != null;
    }

    public static int getColorForRow(int n) {
        int n2 = 1;
        try {
            n2 = (Integer)sRowColors.elementAt(n);
        }
        catch (Exception exception) {
            n2 = 1;
        }
        return n2;
    }

    public Color getColorForBar(int n) {
        if (n < sBarColors.size()) {
            return (Color)sBarColors.elementAt(n);
        }
        return Color.white;
    }

    public void cleanUp() {
        this.mImageWin.dispose();
        this.mImageWin = null;
    }

    static {
        sRowColors.addElement(new Integer(2));
        sRowColors.addElement(new Integer(4));
        sRowColors.addElement(new Integer(3));
        sRowColors.addElement(new Integer(7));
        sRowColors.addElement(new Integer(14));
        sRowColors.addElement(new Integer(5));
        sRowColors.addElement(new Integer(6));
        sRowColors.addElement(new Integer(8));
        sRowColors.addElement(new Integer(10));
        sRowColors.addElement(new Integer(0));
        sBarColors = new Vector();
        sBarColors.addElement(Color.red);
        sBarColors.addElement(Color.blue);
        sBarColors.addElement(Color.green);
        sBarColors.addElement(Color.cyan);
        sBarColors.addElement(Color.gray);
        sBarColors.addElement(Color.magenta);
        sBarColors.addElement(Color.yellow);
        sBarColors.addElement(Color.red.darker());
        sBarColors.addElement(Color.blue.darker());
        sBarColors.addElement(Color.black);
    }
}

