/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.reports;

import java.util.Enumeration;
import java.util.Vector;
import lotus.notes.apps.reports.InternationalResources;
import lotus.notes.apps.reports.RepColDef;

class RepDef {
    private static InternationalResources international_string = new InternationalResources("lotus/notes/apps/reports/ReportsResources");
    public static final String cAxisDelims = ":-";
    public static final int cAxisWidth = 2;
    public static final int cInvalidReportId = 0;
    public static final int cUserMsgCountReportId = 1;
    public static final int cUserMsgSizeReportId = 2;
    public static final int cOrigMsgCountReportId = 3;
    public static final int cOrigMsgSizeReportId = 4;
    public static final int cRecipMsgCountReportId = 5;
    public static final int cRecipMsgSizeReportId = 6;
    public static final int cNextHopMsgCountReportId = 7;
    public static final int cPrevHopMsgCountReportId = 8;
    public static final int cMsgSizeReportId = 10;
    public static final int cMsgSummaryReportId = 11;
    public static final int cMsgStatusReportId = 12;
    public static final String cTopNumStr = international_string.getString("keyword_top25");
    public static final String cUserMsgCountReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_users_by_number");
    public static final String cUserMsgSizeReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_users_by_size");
    public static final String cOrigMsgCountReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_senders_by_number");
    public static final String cOrigMsgSizeReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_senders_by_size");
    public static final String cRecipMsgCountReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_receivers_by_number");
    public static final String cRecipMsgSizeReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_receivers_by_size");
    public static final String cNextHopMsgCountReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_next_hop");
    public static final String cPrevHopMsgCountReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_previous_hop");
    public static final String cMsgSizeReportName = String.valueOf(cTopNumStr) + " " + international_string.getString("rpt_name_largest_messages");
    public static final String cMsgSummaryReportName = international_string.getString("rpt_name_message_volume");
    public static final String cMsgStatusReportName = international_string.getString("rpt_name_message_status");
    public static final int cMsgCountType = 1;
    public static final int cMsgSizeType = 2;
    public static final int cHopCountType = 3;
    public static final int cSentType = 4;
    public static final int cReceivedType = 5;
    public static final int cRelayedType = 6;
    public static final int cStatusType = 7;
    public static final int cStartTimeType = 8;
    public static final int cEndTimeType = 9;
    public static final int cUserType = 10;
    public static final int cOrigType = 11;
    public static final int cRecipType = 12;
    public static final int cMtaType = 13;
    public static final int cDoTypeBase = 5000;
    public static final int cDoUserServerType = 5000;
    public static final int cDoOrigServerType = 5001;
    public static final int cDoRecipServerType = 5002;
    public static final int cDoTotalType = 5003;
    public static final int cAlignLeft = 1;
    public static final int cAlignRight = 2;
    public static final int cAlignCenter = 3;
    public static final String cNL = "\n";
    public static final String cUser = international_string.getString("keyword_user");
    public static final String cName = international_string.getString("keyword_name");
    public static final String cOrig = international_string.getString("keyword_sender");
    public static final String cRecip = international_string.getString("keyword_recipient");
    public static final String cServer = international_string.getString("keyword_server");
    public static final String cCount = international_string.getString("keyword_count");
    public static final String cSize = international_string.getString("keyword_size");
    public static final String cMsg = international_string.getString("keyword_message");
    public static final String cMsgs = international_string.getString("keyword_messages");
    public static final String cBytes = international_string.getString("keyword_bytes");
    public static final String cTotal = international_string.getString("keyword_total");
    public static final String cSent = international_string.getString("keyword_sent");
    public static final String cRelayed = international_string.getString("keyword_relayed");
    public static final String cReceived = international_string.getString("keyword_received");
    public static final String cHop = international_string.getString("keyword_hop");
    public static final String cPrev = international_string.getString("keyword_previous");
    public static final String cNext = international_string.getString("keyword_next");
    public static final String cStart = international_string.getString("keyword_start");
    public static final String cEnd = international_string.getString("keyword_end");
    public static final String cTime = international_string.getString("keyword_time");
    public static final String cDelivery = international_string.getString("keyword_delivery");
    public static final String cStatus = international_string.getString("keyword_status");
    private static Vector sRepDefs = new Vector();
    private int mId;
    private String mDisplayName;
    private Vector mColDefs;
    private int mChartType;
    private boolean mUseLegend;
    private int mChartItemMax;
    private int mChartLabelCol;
    private int mChartValueCol;
    private boolean mUseAxis;
    private int mAxisWidth;
    private String mAxisDelims;

    public static Enumeration getDefs() {
        return sRepDefs.elements();
    }

    public static RepDef getDef(int n) {
        Enumeration enumeration = RepDef.getDefs();
        while (enumeration.hasMoreElements()) {
            RepDef repDef = (RepDef)enumeration.nextElement();
            if (repDef.getId() != n) continue;
            return repDef;
        }
        return null;
    }

    public static RepColDef getColDef(int n, int n2) {
        RepDef repDef = RepDef.getDef(n);
        if (repDef == null) {
            return null;
        }
        Vector vector = repDef.getColDefs();
        if (vector.size() < n2) {
            return null;
        }
        return (RepColDef)vector.elementAt(n2);
    }

    public static int getColType(int n, int n2) {
        RepColDef repColDef = RepDef.getColDef(n, n2);
        if (repColDef == null) {
            return 0;
        }
        return repColDef.getType();
    }

    public static String getColHeading(int n, int n2) {
        RepColDef repColDef = RepDef.getColDef(n, n2);
        if (repColDef == null) {
            return null;
        }
        return repColDef.getHeading();
    }

    public static int getColAlign(int n, int n2) {
        RepColDef repColDef = RepDef.getColDef(n, n2);
        if (repColDef == null) {
            return 0;
        }
        return repColDef.getAlign();
    }

    public static int getNumCols(int n) {
        RepDef repDef = RepDef.getDef(n);
        Vector vector = repDef.getColDefs();
        return vector.size();
    }

    public int getId() {
        return this.mId;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public Vector getColDefs() {
        return this.mColDefs;
    }

    public int getChartType() {
        return this.mChartType;
    }

    public int getChartItemMax() {
        return this.mChartItemMax;
    }

    public int getChartLabelCol() {
        return this.mChartLabelCol;
    }

    public int getChartValueCol() {
        return this.mChartValueCol;
    }

    public boolean useLegend() {
        return this.mUseLegend;
    }

    public boolean useAxis() {
        return this.mUseAxis;
    }

    public int getAxisWidth() {
        return this.mAxisWidth;
    }

    public String getAxisDelims() {
        return this.mAxisDelims;
    }

    public RepDef(int n, String string) {
        this.mId = n;
        this.mDisplayName = string;
        this.mChartType = 0;
        this.mUseLegend = false;
        this.mUseAxis = false;
        this.mColDefs = new Vector();
    }

    public void setChart(int n, int n2, boolean bl, int n3, int n4) {
        this.mChartType = n;
        this.mChartItemMax = n2;
        this.mUseLegend = bl;
        this.mChartLabelCol = n3;
        this.mChartValueCol = n4;
    }

    public void setAxis(int n, String string) {
        this.mUseAxis = true;
        this.mAxisWidth = n;
        this.mAxisDelims = string;
    }

    public void add(RepColDef repColDef) {
        this.mColDefs.addElement(repColDef);
    }

    static {
        RepDef repDef = new RepDef(1, cUserMsgCountReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(10, String.valueOf(cUser) + cNL + cName, 1));
        repDef.add(new RepColDef(5003, String.valueOf(cTotal) + cNL + cMsgs, 3));
        repDef.add(new RepColDef(4, String.valueOf(cMsgs) + cNL + cSent, 3));
        repDef.add(new RepColDef(6, String.valueOf(cMsgs) + cNL + cRelayed, 3));
        repDef.add(new RepColDef(5, String.valueOf(cMsgs) + cNL + cReceived, 3));
        repDef.add(new RepColDef(5000, String.valueOf(cUser) + cNL + cServer, 1));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(2, cUserMsgSizeReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(10, String.valueOf(cUser) + cNL + cName, 1));
        repDef.add(new RepColDef(5003, String.valueOf(cTotal) + cNL + cBytes, 3));
        repDef.add(new RepColDef(4, String.valueOf(cBytes) + cNL + cSent, 3));
        repDef.add(new RepColDef(6, String.valueOf(cBytes) + cNL + cRelayed, 3));
        repDef.add(new RepColDef(5, String.valueOf(cBytes) + cNL + cReceived, 3));
        repDef.add(new RepColDef(5000, String.valueOf(cUser) + cNL + cServer, 1));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(3, cOrigMsgCountReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(11, String.valueOf(cOrig) + cNL + cName, 1));
        repDef.add(new RepColDef(1, String.valueOf(cMsgs) + cNL + cSent, 3));
        repDef.add(new RepColDef(13, String.valueOf(cNext) + cNL + cHop + " " + cName, 3));
        repDef.add(new RepColDef(3, String.valueOf(cHop) + cNL + cMsgs, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(4, cOrigMsgSizeReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(11, String.valueOf(cOrig) + cNL + cName, 1));
        repDef.add(new RepColDef(2, String.valueOf(cBytes) + cNL + cSent, 3));
        repDef.add(new RepColDef(13, String.valueOf(cPrev) + cNL + cHop + " " + cName, 3));
        repDef.add(new RepColDef(3, String.valueOf(cHop) + cNL + cBytes, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(5, cRecipMsgCountReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(12, String.valueOf(cRecip) + cNL + cName, 1));
        repDef.add(new RepColDef(1, String.valueOf(cMsgs) + cNL + cReceived, 3));
        repDef.add(new RepColDef(13, String.valueOf(cPrev) + cNL + cHop + " " + cName, 3));
        repDef.add(new RepColDef(3, String.valueOf(cHop) + cNL + cMsgs, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(6, cRecipMsgSizeReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(12, String.valueOf(cRecip) + cNL + cName, 1));
        repDef.add(new RepColDef(2, String.valueOf(cBytes) + cNL + cReceived, 3));
        repDef.add(new RepColDef(13, String.valueOf(cPrev) + cNL + cHop + " " + cName, 3));
        repDef.add(new RepColDef(3, String.valueOf(cHop) + cNL + cBytes, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(7, cNextHopMsgCountReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(13, String.valueOf(cNext) + cNL + cHop + " " + cName, 1));
        repDef.add(new RepColDef(1, String.valueOf(cMsg) + cNL + cCount, 3));
        repDef.add(new RepColDef(2, String.valueOf(cMsg) + cNL + cBytes, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(8, cPrevHopMsgCountReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(13, String.valueOf(cPrev) + cNL + cHop + " " + cName, 1));
        repDef.add(new RepColDef(1, String.valueOf(cMsg) + cNL + cCount, 3));
        repDef.add(new RepColDef(2, String.valueOf(cMsg) + cNL + cBytes, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(10, cMsgSizeReportName);
        repDef.setChart(2, 10, true, 0, 4);
        repDef.add(new RepColDef(11, String.valueOf(cOrig) + cNL + cName, 1));
        repDef.add(new RepColDef(5001, String.valueOf(cOrig) + cNL + cServer, 3));
        repDef.add(new RepColDef(12, String.valueOf(cRecip) + cNL + cName, 1));
        repDef.add(new RepColDef(5002, String.valueOf(cRecip) + cNL + cServer, 1));
        repDef.add(new RepColDef(2, String.valueOf(cMsg) + cNL + cSize, 3));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(11, cMsgSummaryReportName);
        repDef.setChart(2, -1, false, 0, 2);
        repDef.setAxis(2, cAxisDelims);
        repDef.add(new RepColDef(8, String.valueOf(cStart) + cNL + cTime, 3));
        repDef.add(new RepColDef(9, String.valueOf(cEnd) + cNL + cTime, 3));
        repDef.add(new RepColDef(1, String.valueOf(cMsg) + cNL + cCount, 2));
        repDef.add(new RepColDef(2, String.valueOf(cMsg) + cNL + cBytes, 2));
        sRepDefs.addElement(repDef);
        repDef = new RepDef(12, cMsgStatusReportName);
        repDef.setChart(2, 10, true, 0, 1);
        repDef.add(new RepColDef(7, String.valueOf(cDelivery) + cNL + cStatus, 3));
        repDef.add(new RepColDef(1, String.valueOf(cMsg) + cNL + cCount, 2));
        sRepDefs.addElement(repDef);
    }
}

