/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.reports;

import java.util.Date;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.notes.apps.reports.RepAgent;

public class RepQuery {
    private static final int MAX_RESPONSES = 25;
    private static final int SECONDS_IN_DAY = 86400;
    private static final String WILDCARD = new String("*");
    public static String sReportTypeField = "ReportType";
    public static String sTimeRangeField = "TimeRange";
    public static String sReportChartField = "ReportChart";
    public static String sReportTableField = "ReportTable";
    public static String sUseSenderNameField = "UseSenderName";
    public static String sQualifySenderNameField = "QualifySenderName";
    public static String sSenderNameTextField = "SenderNameText";
    public static String sUseRecipNameField = "UseRecipName";
    public static String sQualifyRecipNameField = "QualifyRecipName";
    public static String sRecipNameTextField = "RecipNameText";
    public static String sUseDeliveryStatusField = "UseDeliveryStatus";
    public static String sQualifyDeliveryStatusField = "QualifyDeliveryStatus";
    public static String sDeliveryStatusField = "DeliveryStatus";
    public static String sUseMessageSizeField = "UseMessageSize";
    public static String sQualifyMessageSizeField = "QualifyMessageSize";
    public static String sMessageSize = "MessageSize";
    public static String sToday = "T";
    public static String sYesterday = "Y";
    public static String sOverTheLastWeek = "LW";
    public static String sOverTheLastTwoWeeks = "L2W";
    public static String sOverTheLastMonth = "LM";
    public static String sAllInfo = "ALL";
    public static String sContains = "C";
    public static String sExactlyMatches = "EM";
    public static String sIs = "IS";
    public static String sIsNot = "NOT";
    public static String sDelivered = "D";
    public static String sNotDelivered = "ND";
    public static String sBeingProcessed = "BP";
    public static String sIsGreaterThan = "GT";
    public static String sIsLessThan = "LT";
    private Document mDoc;
    private RepAgent mAgent;
    private Database mDb;
    private Integer mReportId;
    private String mEarliestArrivalTime;
    private String mLatestArrivalTime;
    private String mInboundOriginator;
    private String mOutboundRecipient;
    private Integer mDispositionStatus;
    private Integer mMinMsgSize;
    private Integer mMaxMsgSize;
    private int mMaxResponses;

    public Integer getReportId() {
        return this.mReportId;
    }

    public String getEarliestArrivalTime() {
        return this.mEarliestArrivalTime;
    }

    public String getLatestArrivalTime() {
        return this.mLatestArrivalTime;
    }

    public String getInboundOriginator() {
        return this.mInboundOriginator;
    }

    public String getOutboundRecipient() {
        return this.mOutboundRecipient;
    }

    public Integer getDispositionStatus() {
        return this.mDispositionStatus;
    }

    public Integer getMinMsgSize() {
        return this.mMinMsgSize;
    }

    public Integer getMaxMsgSize() {
        return this.mMaxMsgSize;
    }

    public int getMaxResponses() {
        return this.mMaxResponses;
    }

    public void setMaxResponses(int n) {
        this.mMaxResponses = n;
    }

    public RepQuery(RepAgent repAgent, Document document, Database database) {
        this.mDoc = document;
        this.mAgent = repAgent;
        this.mDb = database;
        try {
            this.setReportId();
            this.setTimeRange();
            this.setSenderName();
            this.setRecipName();
            this.setDeliveryStatus();
            this.setMessageSize();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void reopenDoc() {
        try {
            String string = this.mDoc.getNoteID();
            this.mDoc.recycle();
            this.mDoc = null;
            this.mDoc = this.mDb.getDocumentByID(string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected boolean isChecked(Document document, String string) {
        boolean bl = false;
        try {
            String string2 = document.getItemValueString(string);
            if (string2 != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected boolean equalsValue(Document document, String string, String string2) {
        boolean bl = false;
        try {
            String string3 = document.getItemValueString(string);
            if (string3 == null) {
                return false;
            }
            if (string3.equals(string2)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void setReportId() {
        try {
            String string = this.mDoc.getItemValueString(sReportTypeField);
            if (string != null) {
                this.mReportId = Integer.valueOf(string);
                return;
            }
            this.mReportId = null;
            return;
        }
        catch (Exception exception) {
            this.mReportId = null;
            return;
        }
    }

    private void setTimeRange() {
        try {
            String string = this.mDoc.getItemValueString(sTimeRangeField);
            DateTime dateTime = this.mAgent.mSession.createDateTime(new Date());
            dateTime.setNow();
            this.mLatestArrivalTime = dateTime.toString();
            if (string == null) {
                return;
            }
            if (string.equals(sAllInfo)) {
                if (this.mReportId == 11) {
                    this.setMaxResponses(-1);
                }
                return;
            }
            DateTime dateTime2 = this.mAgent.mSession.createDateTime(new Date());
            dateTime2.setLocalTime(this.mAgent.mSession.getInternational().getToday());
            dateTime2.setLocalTime(String.valueOf(dateTime2.toString()) + " 00:00:00 " + this.mAgent.mSession.getInternational().getAMString());
            if (string.equals(sYesterday)) {
                dateTime2.adjustDay(-1, true);
            }
            if (string.equals(sOverTheLastWeek)) {
                dateTime2.adjustDay(-7, true);
            }
            if (string.equals(sOverTheLastTwoWeeks)) {
                dateTime2.adjustDay(-14, true);
            }
            if (string.equals(sOverTheLastMonth)) {
                dateTime2.adjustMonth(-1, true);
            }
            this.mEarliestArrivalTime = dateTime2.toString();
            this.calculateMaxResponses(dateTime2, dateTime);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void calculateMaxResponses(DateTime dateTime, DateTime dateTime2) {
        int n = 25;
        if (this.getReportId() == 11) {
            int n2;
            int n3 = 0;
            try {
                n3 = dateTime2.timeDifference(dateTime);
            }
            catch (NotesException notesException) {}
            if (n3 > 86400 && (n2 = (int)Math.ceil((float)n3 / 86400.0f)) > 25) {
                n = n2;
            }
        }
        this.setMaxResponses(n);
    }

    private void setSenderName() {
        try {
            if (this.isChecked(this.mDoc, sUseSenderNameField)) {
                String string = this.mDoc.getItemValueString(sSenderNameTextField);
                if (this.equalsValue(this.mDoc, sQualifySenderNameField, sContains)) {
                    string = String.valueOf(WILDCARD) + string + WILDCARD;
                }
                this.mInboundOriginator = string;
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setRecipName() {
        try {
            if (this.isChecked(this.mDoc, sUseRecipNameField)) {
                String string = this.mDoc.getItemValueString(sRecipNameTextField);
                if (this.equalsValue(this.mDoc, sQualifyRecipNameField, sContains)) {
                    string = String.valueOf(WILDCARD) + string + WILDCARD;
                }
                this.mOutboundRecipient = string;
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setDeliveryStatus() {
        try {
            if (this.isChecked(this.mDoc, sUseDeliveryStatusField)) {
                int n = 1;
                boolean bl = this.equalsValue(this.mDoc, sQualifyDeliveryStatusField, sIs);
                if (this.equalsValue(this.mDoc, sDeliveryStatusField, sDelivered)) {
                    n = bl ? 84 : 43;
                } else if (this.equalsValue(this.mDoc, sDeliveryStatusField, sNotDelivered)) {
                    n = bl ? 41 : 86;
                } else if (this.equalsValue(this.mDoc, sDeliveryStatusField, sBeingProcessed)) {
                    n = bl ? 2 : 125;
                }
                this.mDispositionStatus = new Integer(n);
                return;
            }
            this.mDispositionStatus = new Integer(127);
            return;
        }
        catch (Exception exception) {
            this.mDispositionStatus = null;
            exception.printStackTrace();
            return;
        }
    }

    private void setMessageSize() {
        try {
            if (this.isChecked(this.mDoc, sUseMessageSizeField)) {
                boolean bl = this.equalsValue(this.mDoc, sQualifyMessageSizeField, sIsGreaterThan);
                int n = this.mDoc.getItemValueInteger(sMessageSize);
                if (bl) {
                    this.mMinMsgSize = new Integer(n);
                    return;
                }
                this.mMaxMsgSize = new Integer(n);
                return;
            }
        }
        catch (Exception exception) {
            this.mMinMsgSize = null;
            this.mMaxMsgSize = null;
            exception.printStackTrace();
        }
    }

    public void dump() {
        try {
            System.out.println();
            System.out.println("QUERY From Document: " + this.mDoc.getNoteID());
            System.out.println(">> ReportId = " + this.getReportId());
            System.out.println(">> EarliestArrivalTime = " + this.getEarliestArrivalTime());
            System.out.println(">> LatestArrivalTime = " + this.getLatestArrivalTime());
            System.out.println(">> InboundOriginator = " + this.getInboundOriginator());
            System.out.println(">> OutboundRecipient = " + this.getOutboundRecipient());
            System.out.println(">> DispositionStatus = " + this.getDispositionStatus());
            System.out.println(">> MinMsgSize = " + this.getMinMsgSize());
            System.out.println(">> MaxMsgSize = " + this.getMaxMsgSize());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public String toString() {
        String string = new String();
        String string2 = ",";
        String string3 = "\"";
        string = String.valueOf(string) + string3 + this.stripNull(this.getReportId()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getEarliestArrivalTime()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getLatestArrivalTime()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getInboundOriginator()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getOutboundRecipient()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getDispositionStatus()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getMinMsgSize()) + string3 + string2;
        string = String.valueOf(string) + string3 + this.stripNull(this.getMaxMsgSize()) + string3 + string2;
        string = this.getMaxResponses() != 0 ? String.valueOf(string) + string3 + this.stripNull(new Integer(this.getMaxResponses())) + string3 : String.valueOf(string) + string3 + "" + string3;
        return string;
    }

    public String stripNull(String string) {
        if (string == null || string == "null") {
            return "";
        }
        return string;
    }

    public String stripNull(Integer n) {
        if (n == null) {
            return "";
        }
        return n.toString();
    }
}

