/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.wmsgtrc;

import lotus.notes.apps.wmsgtrc.InternationalResources;

public class DispositionStatus {
    private static final int MAIL_STATUS_FLAG_BASE = 0;
    public static final int MAIL_STATUSFLAG_UNKNOWN = 1;
    public static final int MAIL_STATUSFLAG_INQUEUE = 2;
    public static final int MAIL_STATUSFLAG_DELIVERED = 4;
    public static final int MAIL_STATUSFLAG_DELIVERY_FAILED = 8;
    public static final int MAIL_STATUSFLAG_TRANSFERRED = 16;
    public static final int MAIL_STATUSFLAG_TRANSFER_FAILED = 32;
    public static final int MAIL_STATUSFLAG_GROUP_EXPANDED = 64;
    public static final int MAIL_STATUSFLAG_ALL = 127;
    public static final int MIN_VALUE = 1;
    public static final int MAX_VALUE = 127;
    public static final int DELIVERED = 84;
    public static final int NOT_DELIVERED = 41;
    public static final int BEING_PROCESSED = 2;
    private int status;

    public DispositionStatus(int n) {
        if (n > 127 || n < 1) {
            this.status = 1;
            return;
        }
        this.status = n;
    }

    public int getIntValue() {
        return this.status;
    }

    public static String stringValue(int n) {
        InternationalResources internationalResources = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
        switch (n) {
            case 1: {
                return internationalResources.getString("unknown");
            }
            case 4: {
                return internationalResources.getString("delivered");
            }
            case 8: {
                return internationalResources.getString("delivery_failed");
            }
            case 2: {
                return internationalResources.getString("in_queue");
            }
            case 16: {
                return internationalResources.getString("transferred");
            }
            case 32: {
                return internationalResources.getString("transfer_failed");
            }
            case 64: {
                return internationalResources.getString("group_expanded");
            }
        }
        return null;
    }

    public static String stringMaskedValue(int n) {
        InternationalResources internationalResources = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
        switch (n) {
            case 84: {
                return internationalResources.getString("delivered");
            }
            case 2: {
                return internationalResources.getString("being_processed");
            }
            case 41: {
                return internationalResources.getString("not_delivered");
            }
        }
        return DispositionStatus.stringValue(n);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isStatusDelivered() {
        return this.status == 4;
    }

    public boolean isStatusDeliveryFailed() {
        return this.status == 8;
    }

    public boolean isStatusTransferFailed() {
        return this.status == 32;
    }
}

