/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.wmsgtrc;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.notes.addins.ispy.NABUtils;
import lotus.notes.apps.wmsgtrc.DispositionStatus;
import lotus.notes.apps.wmsgtrc.InternationalResources;

public class MsgTrackRequestEntry {
    private static final int SERVER_RECORD = 0;
    private static final int PERSON_RECORD = 1;
    public static final String WILDCARD = new String("*");
    private InternationalResources intlStr = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
    private boolean WMSGTRACK_DEBUG = false;
    private static String sOriginator = "InboundOriginator";
    private static String sRecipient = "InboundRecipient";
    private static String sWhen = "When";
    private static String sMta = "MTA";
    private static String sSubject = "MsgSubject";
    private static String sOutHtml = "HtmlOut";
    private static String sDeliveryStatusField = "DispositionStatus";
    private static String sMinMsgSize = "MinMsgSize";
    private static String sMaxMsgSize = "MaxMsgSize";
    private static String sUniqueMsgID = "UniqueMsgID";
    private static String sTimeZone = "LocalTimeZone";
    public static String sToday = "Today";
    public static String sYesterday = "Yesterday";
    public static String sOverTheLastWeek = "Over the last week";
    public static String sOverTheLastTwoWeeks = "Over the last two weeks";
    public static String sOverTheLastMonth = "Over the last month";
    public static String sAllInfo = "As long as information is available";
    public static String sSenderServer = "Sender's Server";
    private Document mDoc;
    private Session mSession;
    private PrintWriter mpw;
    private String docID;
    private DateTime earliestArrivalTime;
    private DateTime latestArrivalTime;
    private DateTime aStartDT;
    private DateTime aEndDT;
    private String inboundOriginator;
    private String inboundRecipient;
    private String mta;
    private String uniqueMsgID;
    private String subject;
    private DispositionStatus dispositionStatus;
    private int minMsgSize;
    private int maxMsgSize;
    private DateTime gmtTime;
    private boolean dst = false;
    private int timeZone;

    public String getMsgUniqueMsgID() {
        return this.uniqueMsgID;
    }

    public String getInboundOriginator() {
        return this.inboundOriginator;
    }

    public String getInboundRecipient() {
        return this.inboundRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMta() {
        return this.mta;
    }

    public String getDocID() {
        return this.docID;
    }

    public int getDispositionStatus() {
        return this.dispositionStatus.getIntValue();
    }

    public String getDispositionStatusString() {
        return DispositionStatus.stringValue(this.dispositionStatus.getIntValue());
    }

    public int getMinMsgSize() {
        return this.minMsgSize;
    }

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public DateTime getEarliestArrivalTime() {
        return this.earliestArrivalTime;
    }

    public DateTime getLatestArrivalTime() {
        return this.latestArrivalTime;
    }

    public int getDST() {
        if (this.dst) {
            return 1;
        }
        return 0;
    }

    public boolean getDSTbool() {
        return this.dst;
    }

    public long getTimeZone() {
        Integer n = new Integer(this.timeZone);
        return n.longValue();
    }

    public MsgTrackRequestEntry(Session session) {
        this.mSession = session;
    }

    public MsgTrackRequestEntry(Document document, Session session) {
        this.mDoc = document;
        this.mSession = session;
        try {
            String string;
            String string2;
            String string3;
            String string4 = this.mDoc.getItemValueString(sOriginator);
            if (string4 != null && string4.compareTo("") != 0 && string4.compareTo(WILDCARD) != 0) {
                this.setSenderName(string4);
            }
            if ((string3 = this.mDoc.getItemValueString(sRecipient)) != null && string3.compareTo("") != 0 && string3.compareTo(WILDCARD) != 0) {
                this.setRecipName(string3);
            }
            String string5 = this.mDoc.getItemValueString(sWhen);
            this.setTimeRange(string5);
            String string6 = this.mDoc.getItemValueString(sMta);
            if (!this.setMta(string6)) {
                System.out.println(String.valueOf(this.intlStr.getString("err_sender_server")) + " " + this.getInboundOriginator());
            }
            if ((string2 = this.mDoc.getItemValueString(sSubject)) != null && string2.compareTo("") != 0 && string2.compareTo(WILDCARD) != 0) {
                this.setSubject(string2);
            }
            if ((string = this.mDoc.getItemValueString(sUniqueMsgID)) != null && string.compareTo("") != 0 && string.compareTo(WILDCARD) != 0) {
                this.setUniqueMsgID(string);
            }
            Vector vector = this.mDoc.getItemValue("LocalTimeZone");
            DateTime dateTime = (DateTime)vector.firstElement();
            this.setTimeZone(dateTime);
            this.setDST(dateTime);
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    public boolean equalsValue(Document document, String string, String string2) {
        boolean bl = false;
        try {
            String string3 = document.getItemValueString(string);
            if (string3 == null) {
                return false;
            }
            if (string3.equals(string2)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void setTimeRange(String string) {
        try {
            if (string.equals(sAllInfo)) {
                return;
            }
            Date date = new Date();
            DateTime dateTime = this.mSession.createDateTime(date);
            DateTime dateTime2 = this.mSession.createDateTime(date);
            dateTime.setLocalTime(this.mSession.getInternational().getToday());
            dateTime.setLocalTime(String.valueOf(dateTime.toString()) + " 00:00:00 " + this.mSession.getInternational().getAMString());
            dateTime2.setNow();
            if (string.equals(sYesterday)) {
                dateTime.adjustDay(-1, true);
            }
            if (string.equals(sOverTheLastWeek)) {
                dateTime.adjustDay(-7, true);
            }
            if (string.equals(sOverTheLastTwoWeeks)) {
                dateTime.adjustDay(-14, true);
            }
            if (string.equals(sOverTheLastMonth)) {
                dateTime.adjustMonth(-1, true);
            }
            this.earliestArrivalTime = dateTime;
            this.latestArrivalTime = dateTime2;
            return;
        }
        catch (NotesException notesException) {
            System.out.println(notesException.toString());
            notesException.printStackTrace();
            this.earliestArrivalTime = null;
            this.latestArrivalTime = null;
            return;
        }
    }

    public void setTimeZone(DateTime dateTime) {
        try {
            this.timeZone = dateTime.getTimeZone();
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    public void setTimeZone(int n) {
        this.timeZone = n;
    }

    public void setDST(DateTime dateTime) {
        try {
            this.dst = dateTime.isDST();
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    public void setDST(int n) {
        this.dst = n != 0;
    }

    public void setTimeRange(DateTime dateTime, DateTime dateTime2) {
        try {
            this.earliestArrivalTime = dateTime;
            this.latestArrivalTime = dateTime2;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setSenderName(String string) {
        try {
            this.inboundOriginator = String.valueOf(string) + WILDCARD;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setRecipName(String string) {
        try {
            this.inboundRecipient = String.valueOf(string) + WILDCARD;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setUniqueMsgID(String string) {
        try {
            this.uniqueMsgID = string;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setSubject(String string) {
        try {
            this.subject = String.valueOf(WILDCARD) + string + WILDCARD;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean setMta(String string) {
        boolean bl = false;
        try {
            if (string == null || string.compareTo("") == 0 || string.compareTo(WILDCARD) == 0) {
                return bl;
            }
            if (string.equals(sSenderServer)) {
                String string2 = this.getInboundOriginator();
                if (string2 == null || string2.compareTo(WILDCARD) == 0 || string2.compareTo("") == 0) {
                    return bl;
                }
                String string3 = string2.substring(0, string2.lastIndexOf(WILDCARD));
                if (string3 == null || string3.compareTo("") == 0 || string3.compareTo(WILDCARD) == 0) {
                    return bl;
                }
                Document document = NABUtils.getFirstDocumentFromAddressBook(this.mSession, 1, string3);
                if (document != null) {
                    string = document.getItemValueString("MailServer");
                    if (string != null) {
                        this.mta = string = this.mSession.createName(string).getCommon();
                        if (this.WMSGTRACK_DEBUG) {
                            System.out.println("Mail server = " + this.mta);
                        }
                        bl = true;
                    }
                } else {
                    System.out.println(String.valueOf(this.intlStr.getString("no_adr_record")) + " " + string2);
                }
                string = null;
            } else {
                this.mta = string;
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void setDeliveryStatus(int n) {
        this.dispositionStatus = new DispositionStatus(n);
    }

    public void setMessageSize(int n, int n2) {
        try {
            this.minMsgSize = 0;
            this.maxMsgSize = 0;
            if (n < this.minMsgSize) {
                n = this.minMsgSize;
            }
            if (n2 <= n) {
                n2 = n;
            }
            this.minMsgSize = n * 1024;
            this.maxMsgSize = n2 * 1024;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void dump(PrintWriter printWriter, Document document) {
        try {
            System.out.println("MtRequest Entry Values");
            System.out.println(" QUERY From Document with UNID: " + document.getUniversalID());
            System.out.println(" InboundOriginator = " + this.getInboundOriginator());
            System.out.println(" InboundRecipient = " + this.getInboundRecipient());
            System.out.println(" Subject = " + this.getSubject());
            System.out.println(" Mta = " + this.getMta());
            System.out.println(" TimeZone = " + this.getTimeZone());
            System.out.println(" DaylightSavings = " + this.getDST());
            DateTime dateTime = this.getEarliestArrivalTime();
            if (dateTime == null) {
                System.out.println("EarliestArrivalTime = null");
            } else {
                System.out.println(" EarliestArrivalTime = " + dateTime.getLocalTime());
            }
            DateTime dateTime2 = this.getLatestArrivalTime();
            if (dateTime2 == null) {
                System.out.println("LatestArrivalTime = null");
            } else {
                System.out.println(" LatestArrivalTime = " + dateTime2.getLocalTime());
            }
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private boolean checkDebug(Session session) {
        boolean bl = false;
        try {
            String string = session.getEnvironmentString("debug_wmsgtrc", true);
            if (string != null && string.compareTo("1") == 0) {
                bl = true;
            }
        }
        catch (NotesException notesException) {}
        return bl;
    }

    public void setDebugFlag(boolean bl) {
        this.WMSGTRACK_DEBUG = bl;
    }
}

