/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.wmsgtrc;

import java.io.PrintWriter;
import java.util.Date;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.notes.apps.wmsgtrc.DispositionStatus;
import lotus.notes.apps.wmsgtrc.InternationalResources;

public class MsgTrackResponseEntry {
    private DispositionStatus dispositionStatus;
    private String inboundOriginator;
    private String outboundOriginator;
    private String inboundRecipient;
    private String outboundRecipient;
    private String mta;
    private String nextHopMta;
    private String previousHopMta;
    private String msgID;
    private String inboundMsgID;
    private String outboundMsgID;
    private String subject;
    private String supplementalInfo;
    private String nonDeliveryReason;
    private DateTime dispositionTime;
    private DateTime msgArrivalTime;
    private int msgType;
    private int msgSize;
    private int mailBoxStatus;
    private static final int MAIL_MESSAGEFLAG_BASE = 0;
    public static final int MAIL_MESSAGEFLAG_UNKNOWN = 1;
    public static final int MAIL_MESSAGEFLAG_MEMO = 2;
    public static final int MAIL_MESSAGEFLAG_DELIVERYREPORT = 4;
    public static final int MAIL_MESSAGEFLAG_NONDELIVERYREPORT = 8;
    public static final int MAIL_MESSAGEFLAG_RETURNRECEIPT = 16;
    public static final int MAIL_MESSAGEFLAG_PHONEMESSAGE = 32;
    public static final int MAIL_MESSAGEFLAG_TRACEREPORT = 64;
    public static final int MAIL_MESSAGEFLAG_NOTICE = 128;
    public static final int MAIL_MESSAGEFLAGS_ALL = 255;
    public static final int MAILBOX_STATUSFLAG_UNKNOWN = 0;
    public static final int MAILBOX_STATUSFLAG_UNREAD = 1;
    public static final int MAILBOX_STATUSFLAG_READ = 2;
    public static final int MAILBOX_STATUSFLAG_DELETED = 3;

    public static String mailBoxStatusStringValue(int n) {
        InternationalResources internationalResources = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
        switch (n) {
            case 0: {
                return internationalResources.getString("unknown");
            }
            case 1: {
                return internationalResources.getString("unread");
            }
            case 2: {
                return internationalResources.getString("read");
            }
            case 3: {
                return internationalResources.getString("deleted");
            }
        }
        return null;
    }

    MsgTrackResponseEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, int n, int n2, DispositionStatus dispositionStatus, DateTime dateTime, DateTime dateTime2) {
        this.inboundOriginator = string;
        this.inboundRecipient = string2;
        this.outboundOriginator = string3;
        this.outboundRecipient = string4;
        this.dispositionStatus = dispositionStatus;
        this.dispositionTime = dateTime;
        this.msgArrivalTime = dateTime2;
        this.mta = string5;
        this.nextHopMta = string6;
        this.previousHopMta = string7;
        this.msgSize = n2;
        this.msgID = string9;
        this.inboundMsgID = string10;
        this.outboundMsgID = string11;
        this.subject = string12;
        this.supplementalInfo = string13;
        this.msgType = n;
        this.nonDeliveryReason = string14;
    }

    MsgTrackResponseEntry() {
    }

    public void setInboundOriginator(String string) {
        this.inboundOriginator = string;
    }

    public void setInboundRecipient(String string) {
        this.inboundRecipient = string;
    }

    public void setOutboundOriginator(String string) {
        this.outboundOriginator = string;
    }

    public void setOutboundRecipient(String string) {
        this.outboundRecipient = string;
    }

    public void setMta(String string) {
        this.mta = string;
    }

    public void setNextHopMta(String string) {
        this.nextHopMta = string;
    }

    public void setPrevHopMta(String string) {
        this.previousHopMta = string;
    }

    public void setSupplementalInfo(String string) {
        this.supplementalInfo = string;
    }

    public void setMsgID(String string) {
        this.msgID = string;
    }

    public void setInboundMsgID(String string) {
        this.inboundMsgID = string;
    }

    public void setOutboundMsgID(String string) {
        this.outboundMsgID = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setMsgType(int n) {
        this.msgType = n;
    }

    public void setMsgSize(int n) {
        this.msgSize = n;
    }

    public void setMailBoxStatus(int n) {
        this.mailBoxStatus = n;
    }

    public void setDispositionTime(DateTime dateTime) {
        this.dispositionTime = dateTime;
    }

    public void setDispositionTime(String string, Session session, long l, long l2) {
        try {
            Date date = new Date();
            this.dispositionTime = session.createDateTime(date);
            this.dispositionTime.setLocalTime(string);
            boolean bl = false;
            if (l2 != 0L) {
                bl = true;
            }
            Long l3 = new Long(l);
            this.ConvertToTimeZone(l3.intValue(), bl, this.dispositionTime);
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            System.out.println("Notes Exception in convert time " + notesException);
            return;
        }
    }

    public void setMsgArrivalTime(String string, Session session, long l, long l2) {
        try {
            Date date = new Date();
            this.msgArrivalTime = session.createDateTime(date);
            this.msgArrivalTime.setLocalTime(string);
            boolean bl = false;
            if (l2 != 0L) {
                bl = true;
            }
            Long l3 = new Long(l);
            this.ConvertToTimeZone(l3.intValue(), bl, this.msgArrivalTime);
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    public void setMsgArrivalTime(DateTime dateTime) {
        this.msgArrivalTime = dateTime;
    }

    public void ConvertToTimeZone(int n, boolean bl, DateTime dateTime) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            String string = new String("");
            string = String.valueOf(n);
            if (string.charAt(0) == '-') {
                n2 = 1;
            }
            if (string.length() > n2 + 2) {
                String string2 = string.substring(0, n2 + 2);
                n3 = Integer.parseInt(string2);
                n4 = n2 == 1 ? Integer.parseInt("-" + string.substring(n2 + 2, string.length())) : Integer.parseInt(string.substring(n2 + 2, string.length()));
                dateTime.convertToZone(n4, bl);
                dateTime.adjustMinute(n3, true);
                return;
            }
            dateTime.convertToZone(n, bl);
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            System.out.println("Notes Exception in convert to zone" + notesException);
            return;
        }
    }

    public void setDispositionStatus(DispositionStatus dispositionStatus) {
        this.dispositionStatus = dispositionStatus;
    }

    public void setDispositionStatus(int n) {
        this.dispositionStatus = new DispositionStatus(n);
    }

    public void setNonDeliveryReason(String string) {
        this.nonDeliveryReason = string;
    }

    public String getInboundOriginator() {
        return this.inboundOriginator;
    }

    public String getInboundRecipient() {
        return this.inboundRecipient;
    }

    public String getOutboundOriginator() {
        return this.outboundOriginator;
    }

    public String getOutboundRecipient() {
        return this.outboundRecipient;
    }

    public String getMta() {
        return this.mta;
    }

    public String getNextHopMta() {
        return this.nextHopMta;
    }

    public String getPreviousHopMta() {
        return this.previousHopMta;
    }

    public String getSupplementalInfo() {
        return this.supplementalInfo;
    }

    public String getMsgID() {
        return this.msgID;
    }

    public String getInboundMsgID() {
        return this.inboundMsgID;
    }

    public String getOutboundMsgID() {
        return this.outboundMsgID;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String getMsgTypeString() {
        InternationalResources internationalResources = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
        String string = new String(internationalResources.getString("unknown"));
        switch (this.msgType) {
            case 2: {
                string = internationalResources.getString("memo");
                break;
            }
            case 4: {
                string = internationalResources.getString("delivery_report");
                break;
            }
            case 8: {
                string = internationalResources.getString("non_delivery_report");
                break;
            }
            case 16: {
                string = internationalResources.getString("return_receipt");
                break;
            }
            case 32: {
                string = internationalResources.getString("phone_message");
                break;
            }
            case 64: {
                string = internationalResources.getString("trace_report");
                break;
            }
            case 128: {
                string = internationalResources.getString("notice");
                break;
            }
            default: {
                string = internationalResources.getString("unknown");
            }
        }
        return string;
    }

    public int getMailBoxStatus() {
        return this.mailBoxStatus;
    }

    public String getMailBoxStatusString() {
        InternationalResources internationalResources = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
        String string = new String(internationalResources.getString("unknown"));
        switch (this.mailBoxStatus) {
            case 1: {
                string = internationalResources.getString("unread");
                break;
            }
            case 2: {
                string = internationalResources.getString("read");
                break;
            }
            case 3: {
                string = internationalResources.getString("deleted");
                break;
            }
            case 0: {
                string = internationalResources.getString("unknown");
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public DateTime getDispositionTime() {
        try {
            return this.dispositionTime;
        }
        catch (Exception exception) {
            System.out.println("Exception in get DispositionTime " + exception);
            return null;
        }
    }

    public DateTime getMsgArrivalTime() {
        return this.msgArrivalTime;
    }

    public DispositionStatus getDispositionStatus() {
        return this.dispositionStatus;
    }

    public String getDispositionStatusString() {
        return DispositionStatus.stringValue(this.dispositionStatus.getIntValue());
    }

    public String getNonDeliveryReason() {
        return this.nonDeliveryReason;
    }

    public void dump(PrintWriter printWriter, Document document) {
        try {
            System.out.println("MtResponse Entry Values");
            System.out.println("QUERY From Document: " + document.getUniversalID());
            if (this.getInboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundOriginator = " + this.getInboundOriginator());
            }
            if (this.getInboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundRecipient = " + this.getInboundRecipient());
            }
            if (this.getOutboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundOriginator = " + this.getOutboundOriginator());
            }
            if (this.getOutboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println("  OutboundRecipient = " + this.getOutboundRecipient());
            }
            if (this.getDispositionStatus() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionStatus = " + this.getDispositionStatus());
            }
            if (this.getMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Mta = " + this.getMta());
            }
            if (this.getNextHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" NextHopMta = " + this.getNextHopMta());
            }
            if (this.getPreviousHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" PrevHopMta = " + this.getPreviousHopMta());
            }
            if (this.getSubject() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Subject = " + this.getSubject());
            }
            if (this.getMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgID = " + this.getMsgID());
            }
            if (this.getInboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundMsgID = " + this.getInboundMsgID());
            }
            if (this.getOutboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundMsgID = " + this.getOutboundMsgID());
            }
            if (this.getMsgType() == 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgType = " + this.getMsgType());
            }
            if (this.getMsgSize() == 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgSize = " + this.getMsgSize());
            }
            if (this.getMsgArrivalTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgArrivalTime = " + this.getMsgArrivalTime().getLocalTime());
            }
            if (this.getDispositionTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionTime = " + this.getDispositionTime().getLocalTime());
            }
            if (this.getSupplementalInfo() == null) {
                System.out.println("null");
            } else {
                System.out.println(" SupplementalInfo = " + this.getSupplementalInfo());
            }
            if (this.getNonDeliveryReason() == null) {
                System.out.println("null");
            } else {
                System.out.println(" NonDeliveryReason = " + this.getNonDeliveryReason());
            }
            if (this.getMailBoxStatusString() == null) {
                System.out.println("MailBoxStatus = null");
            } else {
                System.out.println("MailBoxStatus = " + this.getMailBoxStatusString());
            }
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

