/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.wmsgtrc;

import java.io.PrintWriter;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.ACL;
import lotus.domino.ACLEntry;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.notes.apps.wmsgtrc.InternationalResources;
import lotus.notes.apps.wmsgtrc.MsgTrackRequestEntry;
import lotus.notes.apps.wmsgtrc.MsgTrackResponseEntry;
import lotus.notes.apps.wmsgtrc.ResultsOut;
import lotus.notes.apps.wmsgtrc.WebMsgTrack;

public class UnderspecifiedAgent
extends WebMsgTrack {
    private boolean WMSGTRACK_DEBUG = false;
    private Session session;
    private int Status;
    private PrintWriter pw;
    private Document doc;
    private InternationalResources intlStr;
    private static final String sSubjectRole = "[ServerAdmin]";
    private boolean bAllFieldsEnabled = true;

    public void NotesMain() {
        try {
            this.session = this.getSession();
            this.WMSGTRACK_DEBUG = this.checkDebug(this.session);
            AgentContext agentContext = this.session.getAgentContext();
            this.doc = agentContext.getDocumentContext();
            this.intlStr = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
            this.pw = this.getAgentOutput();
            MsgTrackRequestEntry msgTrackRequestEntry = new MsgTrackRequestEntry(this.session);
            String string = this.doc.getItemValueString("Query_String");
            if (this.WMSGTRACK_DEBUG) {
                System.out.println("QueryString:" + string);
            }
            boolean bl = this.MakeRequestFromQueryString(msgTrackRequestEntry, string, this.pw);
            if (this.WMSGTRACK_DEBUG) {
                msgTrackRequestEntry.dump(this.pw, this.doc);
                System.out.println("reqStatus = " + bl);
            }
            if (bl) {
                Vector vector = new Vector();
                if (this.WMSGTRACK_DEBUG) {
                    System.out.println("About to call track recipient");
                }
                int n = this.NwTrackRecipient(msgTrackRequestEntry, vector, this.session);
                ResultsOut resultsOut = new ResultsOut(this.pw, this.doc);
                String string2 = new String("");
                switch (n) {
                    case 0: {
                        if (this.WMSGTRACK_DEBUG) {
                            System.out.println("Summary Response number of hops =: " + vector.size());
                        }
                        resultsOut.SummaryOut(msgTrackRequestEntry, vector, this.doc, this.pw, this.bAllFieldsEnabled);
                        return;
                    }
                    case 1: {
                        if (this.WMSGTRACK_DEBUG) {
                            System.out.println("Underspecified Response number of responses =:" + vector.size());
                        }
                        string2 = String.valueOf(this.intlStr.getString("err_duplicate")) + " " + msgTrackRequestEntry.getMta();
                        resultsOut.ErrorOut(msgTrackRequestEntry, string2);
                        return;
                    }
                    case 2: {
                        string2 = this.intlStr.getString("err_no_messages");
                        resultsOut.ErrorOut(msgTrackRequestEntry, string2);
                        return;
                    }
                    case 3: {
                        string2 = String.valueOf(this.intlStr.getString("err_duplicate")) + " " + msgTrackRequestEntry.getMta();
                        resultsOut.ErrorOut(msgTrackRequestEntry, string2);
                        return;
                    }
                    case 5: {
                        string2 = String.valueOf(this.intlStr.getString("err_servernotfound")) + " " + msgTrackRequestEntry.getMta();
                        resultsOut.ErrorOut(msgTrackRequestEntry, string2);
                        return;
                    }
                }
                string2 = this.intlStr.getString("err_tracking_failed");
                resultsOut.ErrorOut(msgTrackRequestEntry, string2);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean MakeRequestFromQueryString(MsgTrackRequestEntry msgTrackRequestEntry, String string, PrintWriter printWriter) {
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        Integer n = null;
        Integer n2 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            int n3 = stringTokenizer.countTokens();
            String[] stringArray = new String[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                stringArray[n5] = stringTokenizer.nextToken();
                if (this.WMSGTRACK_DEBUG) {
                    System.out.println(stringArray[n5]);
                }
                ++n5;
            }
            int n6 = 1;
            while (n6 < n3) {
                String string4;
                n4 = stringArray[n6].indexOf("=");
                if (stringArray[n6].substring(0, n4).equals("o")) {
                    string2 = this.ReplaceSpaces(stringArray[n6].substring(n4 + 1));
                    msgTrackRequestEntry.setSenderName(string2);
                } else if (stringArray[n6].substring(0, n4).equals("s")) {
                    string3 = this.ReplaceSpaces(stringArray[n6].substring(n4 + 1));
                    msgTrackRequestEntry.setMta(string3);
                } else if (stringArray[n6].substring(0, n4).equals("r")) {
                    string4 = this.ReplaceSpaces(stringArray[n6].substring(n4 + 1));
                    msgTrackRequestEntry.setRecipName(string4);
                } else if (stringArray[n6].substring(0, n4).equals("tz")) {
                    n = new Integer(stringArray[n6].substring(n4 + 1));
                } else if (stringArray[n6].substring(0, n4).equals("dst")) {
                    n2 = new Integer(stringArray[n6].substring(n4 + 1));
                } else if (stringArray[n6].substring(0, n4).equals("id")) {
                    string4 = this.ReplaceSpaces(stringArray[n6].substring(n4 + 1));
                    msgTrackRequestEntry.setUniqueMsgID(string4);
                }
                ++n6;
            }
            msgTrackRequestEntry.setDeliveryStatus(127);
            msgTrackRequestEntry.setTimeZone(n);
            msgTrackRequestEntry.setDST(n2);
            if (this.WMSGTRACK_DEBUG) {
                this.dumpreq(msgTrackRequestEntry, printWriter, this.doc);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            printWriter.println(this.intlStr.getString("err_make_request"));
            bl = false;
        }
        return bl;
    }

    private void MainQueryOut(Document document) {
        try {
            Object object;
            Vector vector = document.getItems();
            System.out.println("Agent Context Document");
            System.out.println("Found vector with " + vector.size() + " elements<BR>");
            int n = 0;
            while (n < vector.size()) {
                object = (Item)vector.elementAt(n);
                System.out.print("Item " + n + " :  ");
                if (object == null) {
                    System.out.print("NULL");
                } else {
                    System.out.print(String.valueOf(object.getName()) + " / " + object.getText());
                }
                System.out.println("<BR>");
                ++n;
            }
            object = document.getItemValueString("QUERY_STRING");
            System.out.println("QueryString = " + (String)object);
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    private String ReplaceSpaces(String string) {
        String string2 = new String("");
        string2 = string.replace('+', ' ');
        return string2;
    }

    private int TrackMessage(MsgTrackRequestEntry msgTrackRequestEntry, Vector vector, Session session) {
        int n = 0;
        try {
            MsgTrackResponseEntry msgTrackResponseEntry = new MsgTrackResponseEntry();
            msgTrackResponseEntry.setInboundOriginator("Jennifer");
            msgTrackResponseEntry.setInboundRecipient("Mick Jagger");
            msgTrackResponseEntry.setOutboundOriginator("jshiple@dshiple_nt.ssw.com");
            msgTrackResponseEntry.setOutboundRecipient("Mick Jagger");
            msgTrackResponseEntry.setMta("Rock/OU=Music");
            msgTrackResponseEntry.setNextHopMta("dshiple_nt.ssw.com");
            msgTrackResponseEntry.setPrevHopMta("rock/OU=Music");
            msgTrackResponseEntry.setSupplementalInfo("suppInfo");
            msgTrackResponseEntry.setMsgID("4738975384758975");
            msgTrackResponseEntry.setInboundMsgID("3938753897593");
            msgTrackResponseEntry.setOutboundMsgID("384930859jf498");
            msgTrackResponseEntry.setSubject("test");
            msgTrackResponseEntry.setMsgType(2);
            msgTrackResponseEntry.setMsgSize(100);
            Date date = new Date();
            DateTime dateTime = session.createDateTime(date);
            dateTime.setNow();
            msgTrackResponseEntry.setDispositionTime(dateTime);
            dateTime.adjustMinute(10, true);
            msgTrackResponseEntry.setMsgArrivalTime(dateTime);
            msgTrackResponseEntry.setDispositionStatus(4);
            vector.addElement(msgTrackResponseEntry);
            msgTrackResponseEntry.setMta(msgTrackResponseEntry.getNextHopMta());
            vector.addElement(msgTrackResponseEntry);
            msgTrackResponseEntry.setMta(msgTrackResponseEntry.getPreviousHopMta());
            msgTrackResponseEntry.setNextHopMta("");
            vector.addElement(msgTrackResponseEntry);
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
        }
        return n;
    }

    public void dumprsp(MsgTrackResponseEntry msgTrackResponseEntry) {
        try {
            System.out.println("MtResponse From Query String");
            System.out.println("QUERY From Document: " + this.doc.getUniversalID());
            if (msgTrackResponseEntry.getInboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundOriginator = " + msgTrackResponseEntry.getInboundOriginator());
            }
            if (msgTrackResponseEntry.getInboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundRecipient = " + msgTrackResponseEntry.getInboundRecipient());
            }
            if (msgTrackResponseEntry.getOutboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundOriginator = " + msgTrackResponseEntry.getOutboundOriginator());
            }
            if (msgTrackResponseEntry.getOutboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println("  OutboundRecipient = " + msgTrackResponseEntry.getOutboundRecipient());
            }
            if (msgTrackResponseEntry.getDispositionStatusString() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionStatus = " + msgTrackResponseEntry.getDispositionStatusString());
            }
            if (msgTrackResponseEntry.getMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Mta = " + msgTrackResponseEntry.getMta());
            }
            if (msgTrackResponseEntry.getNextHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" NextHopMta = " + msgTrackResponseEntry.getNextHopMta());
            }
            if (msgTrackResponseEntry.getPreviousHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" PrevHopMta = " + msgTrackResponseEntry.getPreviousHopMta());
            }
            if (msgTrackResponseEntry.getSubject() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Subject = " + msgTrackResponseEntry.getSubject());
            }
            if (msgTrackResponseEntry.getMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgID = " + msgTrackResponseEntry.getMsgID());
            }
            if (msgTrackResponseEntry.getInboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundMsgID = " + msgTrackResponseEntry.getInboundMsgID());
            }
            if (msgTrackResponseEntry.getOutboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundMsgID = " + msgTrackResponseEntry.getOutboundMsgID());
            }
            if (msgTrackResponseEntry.getMsgType() < 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgType = " + msgTrackResponseEntry.getMsgType());
            }
            if (msgTrackResponseEntry.getMsgSize() <= 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgSize = " + msgTrackResponseEntry.getMsgSize());
            }
            if (msgTrackResponseEntry.getMsgArrivalTime().getLocalTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgArrivalTime = " + msgTrackResponseEntry.getMsgArrivalTime().getLocalTime());
            }
            if (msgTrackResponseEntry.getDispositionTime().getLocalTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionTime = " + msgTrackResponseEntry.getDispositionTime().getLocalTime());
            }
            if (msgTrackResponseEntry.getSupplementalInfo() == null) {
                System.out.println("null");
            } else {
                System.out.println(" SupplementalInfo = " + msgTrackResponseEntry.getSupplementalInfo());
            }
            if (msgTrackResponseEntry.getNonDeliveryReason() == null) {
                System.out.println("Non Delivery Reason = null");
            } else {
                System.out.println(" NonDeliveryReason = " + msgTrackResponseEntry.getNonDeliveryReason());
            }
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void dumpreq(MsgTrackRequestEntry msgTrackRequestEntry, PrintWriter printWriter, Document document) {
        try {
            System.out.println("MtRequest Entry Values");
            if (document.getUniversalID() == null) {
                System.out.println("Universal ID = null");
            } else {
                System.out.println(" QUERY From Document: " + document.getUniversalID());
            }
            if (msgTrackRequestEntry.getInboundOriginator() == null) {
                System.out.println(" InboundOriginator = null");
            } else {
                System.out.println(" InboundOriginator = " + msgTrackRequestEntry.getInboundOriginator());
            }
            if (msgTrackRequestEntry.getInboundRecipient() == null) {
                System.out.println(" InboundRecipient = null");
            } else {
                System.out.println(" InboundRecipient = " + msgTrackRequestEntry.getInboundRecipient());
            }
            if (msgTrackRequestEntry.getSubject() == null) {
                System.out.println("Subject = null");
            } else {
                System.out.println(" Subject = " + msgTrackRequestEntry.getSubject());
            }
            if (msgTrackRequestEntry.getMta() == null) {
                System.out.println("Mta = null");
            } else {
                System.out.println(" Mta = " + msgTrackRequestEntry.getMta());
            }
            if (msgTrackRequestEntry.getDispositionStatus() < 0) {
                System.out.println("DispStatus = null");
            } else {
                System.out.println(" DispositionStatus = " + msgTrackRequestEntry.getDispositionStatus());
            }
            if (msgTrackRequestEntry.getMinMsgSize() < 0) {
                System.out.println("MinMsgSize = null");
            } else {
                System.out.println(" MinMsgSize = " + msgTrackRequestEntry.getMinMsgSize());
            }
            if (msgTrackRequestEntry.getMaxMsgSize() < 0) {
                System.out.println("MaxMsgSize = null");
            } else {
                System.out.println(" MaxMsgSize = " + msgTrackRequestEntry.getMaxMsgSize());
            }
            if (msgTrackRequestEntry.getTimeZone() < 0L) {
                System.out.println("TimeZone = null");
            } else {
                System.out.println(" TimeZone = " + msgTrackRequestEntry.getTimeZone());
            }
            if (msgTrackRequestEntry.getDST() < 0) {
                System.out.println("DST = null");
            } else {
                System.out.println(" DaylightSavings = " + msgTrackRequestEntry.getDST());
            }
            if (msgTrackRequestEntry.getEarliestArrivalTime() == null) {
                System.out.println("Earliest time = null");
            } else {
                System.out.println(" EarliestArrivalTime = " + msgTrackRequestEntry.getEarliestArrivalTime().getLocalTime());
            }
            if (msgTrackRequestEntry.getLatestArrivalTime() == null) {
                System.out.println("Latest time = null");
            } else {
                System.out.println(" LatestArrivalTime = " + msgTrackRequestEntry.getLatestArrivalTime().getLocalTime());
            }
            System.out.println("<BR>");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Notes Exception in dumpreq" + exception);
            return;
        }
    }

    private boolean isSubjectEnabled(Session session, String string) {
        boolean bl = false;
        String string2 = new String("");
        try {
            Object object;
            Object object2;
            AgentContext agentContext = session.getAgentContext();
            Database database = agentContext.getCurrentDatabase();
            ACL aCL = database.getACL();
            Vector vector = aCL.getRoles();
            if (this.WMSGTRACK_DEBUG) {
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    System.out.println("roles =" + (String)object);
                }
            }
            if (vector == null || !vector.contains(string)) {
                return false;
            }
            object2 = session.getUserNameObject();
            if (object2 == null) {
                System.out.println(this.intlStr.getString("err_name"));
                return false;
            }
            if (object2.isHierarchical()) {
                string2 = session.getCommonUserName();
            }
            if (session.isOnServer()) {
                string2 = agentContext.getEffectiveUserName();
            }
            if (string2 == null) {
                System.out.println(this.intlStr.getString("err_name"));
                return false;
            }
            if (this.WMSGTRACK_DEBUG) {
                System.out.println("Username = " + string2);
            }
            if ((object = this.session.createName(string2)) == null) {
                return false;
            }
            ACLEntry aCLEntry = aCL.getEntry(object.getAbbreviated());
            object.recycle();
            if (aCLEntry == null) {
                aCLEntry = aCL.getEntry("-Default-");
            }
            bl = aCLEntry.isRoleEnabled(string);
            if (this.WMSGTRACK_DEBUG) {
                System.out.println("Name object name:" + object + "role = " + string + "ret = " + bl);
            }
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            System.out.println("Notes Exception e  " + this.intlStr.getString("err_name"));
            bl = false;
        }
        return bl;
    }

    private boolean checkDebug(Session session) {
        boolean bl = false;
        try {
            String string = session.getEnvironmentString("debug_wmsgtrc", true);
            if (string != null && string.compareTo("1") == 0) {
                bl = true;
            }
        }
        catch (NotesException notesException) {}
        return bl;
    }
}

