/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.apps.wmsgtrc;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.ACL;
import lotus.domino.ACLEntry;
import lotus.domino.AgentBase;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.util.Platform;
import lotus.notes.apps.wmsgtrc.InternationalResources;
import lotus.notes.apps.wmsgtrc.MsgTrackRequestEntry;
import lotus.notes.apps.wmsgtrc.MsgTrackResponseEntry;
import lotus.notes.apps.wmsgtrc.ResultsOut;

public class WebMsgTrack
extends AgentBase {
    public boolean WMSGTRACK_DEBUG = false;
    private static final int MAXROWS = 25;
    private InternationalResources intlStr;
    public static final int JNI_MSGTRACK_SUCCESS = 0;
    public static final int JNI_MSGTRACK_UNDERQUALIFIED = 1;
    public static final int JNI_MSGTRACK_NOTFOUND = 2;
    public static final int JNI_MSGTRACK_DUPLICATE = 3;
    public static final int JNI_MSGTRACK_FAILED = 4;
    public static final int JNI_MSGTRACK_UNABLE_TO_FIND_SERVER = 5;
    private static final String sSubjectRole = "[ServerAdmin]";
    private boolean bAllFieldsEnabled = true;
    private PrintWriter pw;
    private Document doc;
    private Document ndoc;
    private Session session;
    private String mta;

    public native int NwFindMessage(MsgTrackRequestEntry var1, Vector var2, Session var3);

    public native int NwTrackRecipient(MsgTrackRequestEntry var1, Vector var2, Session var3);

    public native int NwTrackMessage(MsgTrackRequestEntry var1, Vector var2, Session var3);

    public void NotesMain() {
        try {
            this.session = this.getSession();
            AgentContext agentContext = this.session.getAgentContext();
            this.WMSGTRACK_DEBUG = this.checkDebug(this.session);
            this.doc = agentContext.getDocumentContext();
            this.intlStr = new InternationalResources("lotus.notes.apps.wmsgtrc.WebMsgTrackResources");
            this.pw = this.getAgentOutput();
            MsgTrackRequestEntry msgTrackRequestEntry = new MsgTrackRequestEntry(this.doc, this.session);
            msgTrackRequestEntry.setDebugFlag(this.WMSGTRACK_DEBUG);
            if (this.WMSGTRACK_DEBUG) {
                msgTrackRequestEntry.dump(this.pw, this.doc);
            }
            Vector vector = new Vector();
            int n = this.NwFindMessage(msgTrackRequestEntry, vector, this.session);
            ResultsOut resultsOut = new ResultsOut(this.pw, this.doc);
            resultsOut.setDebugFlag(this.WMSGTRACK_DEBUG);
            String string = new String("");
            switch (n) {
                case 0: {
                    if (this.WMSGTRACK_DEBUG) {
                        System.out.println("Summary");
                        System.out.println("Number of hops =: " + vector.size());
                    }
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        MsgTrackResponseEntry msgTrackResponseEntry = (MsgTrackResponseEntry)enumeration.nextElement();
                        if (!this.WMSGTRACK_DEBUG) continue;
                        this.dumprsp(msgTrackResponseEntry);
                    }
                    resultsOut.SummaryOut(msgTrackRequestEntry, vector, this.doc, this.pw, this.bAllFieldsEnabled);
                    return;
                }
                case 1: {
                    if (this.WMSGTRACK_DEBUG) {
                        System.out.println("Underspec");
                        System.out.println("Number of responses =: " + vector.size());
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            MsgTrackResponseEntry msgTrackResponseEntry = (MsgTrackResponseEntry)enumeration.nextElement();
                            this.dumprsp(msgTrackResponseEntry);
                        }
                    }
                    resultsOut.UnderspecifiedOut(msgTrackRequestEntry, vector, this.bAllFieldsEnabled);
                    return;
                }
                case 2: {
                    string = this.intlStr.getString("err_no_messages");
                    resultsOut.ErrorOut(msgTrackRequestEntry, string);
                    return;
                }
                case 3: {
                    string = String.valueOf(this.intlStr.getString("err_duplicate")) + " " + msgTrackRequestEntry.getMta();
                    resultsOut.ErrorOut(msgTrackRequestEntry, string);
                    return;
                }
                case 5: {
                    string = String.valueOf(this.intlStr.getString("err_servernotfound")) + " " + msgTrackRequestEntry.getMta();
                    resultsOut.ErrorOut(msgTrackRequestEntry, string);
                    return;
                }
            }
            string = this.intlStr.getString("err_tracking_failed");
            resultsOut.ErrorOut(msgTrackRequestEntry, string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void MainQueryOut(Document document) {
        System.out.println("The values of all the fields in the form");
        try {
            Vector vector = document.getItems();
            System.out.println("Found vector with " + vector.size() + " elements<BR>");
            int n = 0;
            while (n < vector.size()) {
                Item item = (Item)vector.elementAt(n);
                System.out.print("Item " + n + " :  ");
                if (item == null) {
                    System.out.print("NULL");
                } else {
                    System.out.print(String.valueOf(item.getName()) + " / " + item.getText());
                }
                System.out.println("<BR>");
                ++n;
            }
            return;
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            return;
        }
    }

    public boolean IsBrowserSupported(Document document) {
        boolean bl = true;
        try {
            String string = document.getItemValueString("HTTP_User_Agent");
            bl = string.indexOf("MSIE 2") != -1 ? false : (string.indexOf("Windows 3.1") != -1 ? false : (string.indexOf("Win16") != -1 ? false : string.indexOf("MSIE 3") == -1 || string.indexOf("MAC") == -1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public boolean isLowEndBrowser(Document document) {
        try {
            String string = document.getItemValueString("HTTP_User_Agent");
            return string.indexOf("OS/2") != -1 || string.indexOf("Windows 3.1") != -1 || string.indexOf("Win16") != -1;
        }
        catch (Exception exception) {
            System.out.println("Notes Exception " + exception);
            return false;
        }
    }

    private String getPath(Document document, AgentContext agentContext) {
        String string = "";
        try {
            string = String.valueOf(document.getItemValueString("Server_Name")) + "/" + agentContext.getCurrentDatabase();
        }
        catch (NotesException notesException) {
            System.out.println("Notes Exception" + notesException);
        }
        return string;
    }

    private boolean isSubjectEnabled(Session session, String string) {
        boolean bl = false;
        String string2 = new String("");
        try {
            Name name;
            AgentContext agentContext = session.getAgentContext();
            Database database = agentContext.getCurrentDatabase();
            ACL aCL = database.getACL();
            Vector vector = aCL.getRoles();
            if (vector == null || !vector.contains(string)) {
                return false;
            }
            Name name2 = session.getUserNameObject();
            if (name2 == null) {
                System.out.println(this.intlStr.getString("err_name"));
                return false;
            }
            if (name2.isHierarchical()) {
                string2 = session.getCommonUserName();
            }
            if (session.isOnServer()) {
                string2 = agentContext.getEffectiveUserName();
            }
            if (string2 == null) {
                System.out.println(this.intlStr.getString("err_name"));
                return false;
            }
            if (this.WMSGTRACK_DEBUG) {
                System.out.println("Username = " + string2);
            }
            if ((name = this.session.createName(string2)) == null) {
                return false;
            }
            ACLEntry aCLEntry = aCL.getEntry(name.getAbbreviated());
            name.recycle();
            if (aCLEntry == null) {
                aCLEntry = aCL.getEntry("-Default-");
            }
            bl = aCLEntry.isRoleEnabled(string);
        }
        catch (NotesException notesException) {
            notesException.printStackTrace();
            System.out.println("Notes Exception e  " + this.intlStr.getString("err_name"));
            bl = false;
        }
        return bl;
    }

    public boolean getDebugFlag() {
        return this.WMSGTRACK_DEBUG;
    }

    private boolean checkDebug(Session session) {
        boolean bl = false;
        try {
            String string = session.getEnvironmentString("debug_wmsgtrc", true);
            if (string != null && string.compareTo("1") == 0) {
                bl = true;
            }
        }
        catch (NotesException notesException) {}
        return bl;
    }

    public void dumprsp(MsgTrackResponseEntry msgTrackResponseEntry) {
        try {
            System.out.println("MtResponse Entry Values");
            System.out.println("QUERY From Document: " + this.doc.getUniversalID());
            if (msgTrackResponseEntry.getInboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundOriginator = " + msgTrackResponseEntry.getInboundOriginator());
            }
            if (msgTrackResponseEntry.getInboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundRecipient = " + msgTrackResponseEntry.getInboundRecipient());
            }
            if (msgTrackResponseEntry.getOutboundOriginator() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundOriginator = " + msgTrackResponseEntry.getOutboundOriginator());
            }
            if (msgTrackResponseEntry.getOutboundRecipient() == null) {
                System.out.println("null");
            } else {
                System.out.println("  OutboundRecipient = " + msgTrackResponseEntry.getOutboundRecipient());
            }
            if (msgTrackResponseEntry.getDispositionStatusString() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionStatus = " + msgTrackResponseEntry.getDispositionStatusString());
            }
            if (msgTrackResponseEntry.getMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Mta = " + msgTrackResponseEntry.getMta());
            }
            if (msgTrackResponseEntry.getNextHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" NextHopMta = " + msgTrackResponseEntry.getNextHopMta());
            }
            if (msgTrackResponseEntry.getPreviousHopMta() == null) {
                System.out.println("null");
            } else {
                System.out.println(" PrevHopMta = " + msgTrackResponseEntry.getPreviousHopMta());
            }
            if (msgTrackResponseEntry.getSubject() == null) {
                System.out.println("null");
            } else {
                System.out.println(" Subject = " + msgTrackResponseEntry.getSubject());
            }
            if (msgTrackResponseEntry.getMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgID = " + msgTrackResponseEntry.getMsgID());
            }
            if (msgTrackResponseEntry.getInboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" InboundMsgID = " + msgTrackResponseEntry.getInboundMsgID());
            }
            if (msgTrackResponseEntry.getOutboundMsgID() == null) {
                System.out.println("null");
            } else {
                System.out.println(" OutboundMsgID = " + msgTrackResponseEntry.getOutboundMsgID());
            }
            if (msgTrackResponseEntry.getMsgType() < 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgType = " + msgTrackResponseEntry.getMsgTypeString());
            }
            if (msgTrackResponseEntry.getMsgSize() <= 0) {
                System.out.println("null");
            } else {
                System.out.println(" MsgSize = " + msgTrackResponseEntry.getMsgSize());
            }
            if (msgTrackResponseEntry.getMsgArrivalTime().getLocalTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" MsgArrivalTime = " + msgTrackResponseEntry.getMsgArrivalTime().getLocalTime());
            }
            if (msgTrackResponseEntry.getDispositionTime().getLocalTime() == null) {
                System.out.println("null");
            } else {
                System.out.println(" DispositionTime = " + msgTrackResponseEntry.getDispositionTime().getLocalTime());
            }
            if (msgTrackResponseEntry.getSupplementalInfo() == null) {
                System.out.println("null");
            } else {
                System.out.println(" SupplementalInfo = " + msgTrackResponseEntry.getSupplementalInfo());
            }
            if (msgTrackResponseEntry.getNonDeliveryReason() == null) {
                System.out.println("Non Delivery Reason = null");
            } else {
                System.out.println(" NonDeliveryReason = " + msgTrackResponseEntry.getNonDeliveryReason());
            }
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static {
        try {
            String string = "wmsgtrc";
            System.out.print("Loading...");
            String string2 = Platform.getLibName(string);
            System.loadLibrary(string2);
            System.out.println(String.valueOf(string2) + ".");
        }
        catch (Exception exception) {
            System.out.println("Encountered error loading library: + aDLLname");
            System.out.println(exception.getMessage());
        }
    }
}

