/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lotus.notes.internal.AgentOutputStream;
import sun.tools.javac.Main;

class IDEHelper {
    static String[] listJar(String string) throws IOException {
        Object[] objectArray;
        ZipEntry zipEntry;
        Vector<Object[]> vector = new Vector<Object[]>();
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            objectArray = zipEntry.getName();
            zipInputStream.closeEntry();
            if (zipEntry.isDirectory() || objectArray.startsWith("META-INF/")) continue;
            vector.addElement(objectArray);
        }
        zipInputStream.close();
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static boolean extractJar(String string, String string2) throws IOException {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string3 = zipEntry.getName();
            if (!zipEntry.isDirectory() && !string3.startsWith("META-INF/")) {
                int n;
                Object object;
                File file = new File(string2, string3.replace('/', File.separatorChar));
                if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                    throw new IOException(String.valueOf(object) + ": could not create directory");
                }
                object = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                    ((OutputStream)object).write(byArray, 0, n);
                }
                ((OutputStream)object).close();
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        return true;
    }

    private static void addFiles(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        File file = new File(string, string2);
        if (file.isFile()) {
            String string3 = string2.replace(File.separatorChar, '/');
            ZipEntry zipEntry = new ZipEntry(string3);
            zipEntry.setTime(file.lastModified());
            if (file.length() == 0L) {
                zipEntry.setMethod(0);
                zipEntry.setSize(0L);
                zipEntry.setCrc(0L);
                zipOutputStream.putNextEntry(zipEntry);
            } else {
                int n;
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = new byte[4096];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), byArray.length);
                while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                ((InputStream)bufferedInputStream).close();
            }
            zipOutputStream.closeEntry();
            return;
        }
        if (file.isDirectory()) {
            if (string2.length() > 0) {
                string2 = String.valueOf(string2) + File.separatorChar;
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                IDEHelper.addFiles(string, String.valueOf(string2) + stringArray[n], zipOutputStream);
                ++n;
            }
        }
    }

    static boolean createJar(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        IDEHelper.addFiles(string2, "", zipOutputStream);
        try {
            zipOutputStream.close();
        }
        catch (ZipException zipException) {
            bufferedOutputStream.close();
            return false;
        }
        return true;
    }

    static String setDir(String string) {
        String string2 = System.getProperty("user.dir");
        ((Hashtable)System.getProperties()).put("user.dir", string);
        return string2;
    }

    static boolean compile(String string, String[] stringArray, String string2, int n) {
        OutputStream outputStream;
        String string3 = System.getProperty("file.encoding");
        try {
            ((Hashtable)System.getProperties()).put("file.encoding", "UTF8");
            outputStream = new AgentOutputStream(n, 4);
            outputStream = new PrintStream(outputStream);
        }
        catch (Throwable throwable) {
            System.err.println("Exception in AgentIDEHelper.compile(): " + throwable);
            throwable.printStackTrace(System.err);
            return false;
        }
        ((Hashtable)System.getProperties()).put("file.encoding", string3);
        Main main = new Main(outputStream, "Javac");
        String string4 = System.getProperty("path.separator", ";");
        String string5 = System.getProperty("java.class.path");
        string2 = "." + string4 + string2;
        if (string5 != null) {
            string2 = String.valueOf(string2) + string4 + string5;
        }
        String[] stringArray2 = new String[5 + stringArray.length];
        stringArray2[0] = "-classpath";
        stringArray2[1] = string2;
        stringArray2[2] = "-d";
        stringArray2[3] = string;
        stringArray2[4] = "-deprecation";
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2 + 5] = stringArray[n2].replace('/', File.separatorChar);
            ++n2;
        }
        boolean bl = main.compile(stringArray2);
        try {
            outputStream.flush();
        }
        catch (Throwable throwable) {
            System.err.println("Exception in AgentIDEHelper.compile() flush: " + throwable);
            throwable.printStackTrace(System.err);
        }
        return bl;
    }

    IDEHelper() {
    }
}

