/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneRootItem;
import lotus.notes.internal.InfoPaneTopItem;

public class InfoPane {
    private static InfoPaneRootItem rootItem;
    static final String indexFilePath = "lotus/notes/internal/INFOPANE";
    static /* synthetic */ Class class$lotus$notes$internal$InfoPaneTopItem;

    InfoPane() {
        rootItem = null;
    }

    public static void main(String[] stringArray) {
        InfoPane.GetRootItem();
        if (stringArray.length > 0) {
            rootItem.Print("", true);
        } else {
            rootItem.Print("", false);
        }
        System.exit(0);
    }

    static InfoPaneRootItem GetRootItem() {
        if (rootItem == null) {
            InfoPane.Initialize();
        }
        return rootItem;
    }

    static void Initialize() {
        try {
            rootItem = new InfoPaneRootItem();
            String string = System.getProperty("java.class.path");
            String string2 = System.getProperty("path.separator", ";");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                Closeable closeable;
                String string3 = stringTokenizer.nextToken();
                if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                    try {
                        closeable = new ZipFile(string3);
                        ZipEntry zipEntry = closeable.getEntry(indexFilePath);
                        if (zipEntry == null) continue;
                        InfoPane.ReadIndexFile(closeable.getInputStream(zipEntry));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                try {
                    closeable = new FileInputStream(String.valueOf(string3) + "/" + indexFilePath);
                    InfoPane.ReadIndexFile((InputStream)closeable);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("InfoPane.Initialize exception: " + exception);
            exception.printStackTrace();
            return;
        }
    }

    static void ReadIndexFile(InputStream inputStream) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                Object object;
                while ((object = objectInputStream.readObject()) != null) {
                    InfoPane.AssertClass(object, class$lotus$notes$internal$InfoPaneTopItem != null ? class$lotus$notes$internal$InfoPaneTopItem : InfoPane.class$("lotus.notes.internal.InfoPaneTopItem"));
                    InfoPaneTopItem infoPaneTopItem = (InfoPaneTopItem)object;
                    InfoPaneTopItem infoPaneTopItem2 = rootItem.FindItem(infoPaneTopItem.name);
                    if (infoPaneTopItem2 != null) continue;
                    rootItem.AddItem(infoPaneTopItem);
                }
            }
            catch (EOFException eOFException) {}
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("InfoPane.ReadIndexFile exception: " + exception);
            exception.printStackTrace();
            return;
        }
    }

    static void AssertClass(Object object, Class clazz) throws InfoPaneException {
        if (object.getClass() != clazz) {
            throw new InfoPaneException("\nClass mismatch: Expected " + clazz + ",\n\t\tactual " + object.getClass());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

