/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import lotus.notes.internal.InfoPaneClassSubItem;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneClassItem
implements InfoPaneItem {
    private String name;
    private String midName;
    private String longName;

    InfoPaneClassItem(String string, String string2) {
        this.longName = string2;
        this.midName = InfoPaneClassItem.After(this.longName, ' ');
        this.name = InfoPaneClassItem.After(this.midName, '.');
    }

    static String After(String string, char c) {
        return string.substring(string.lastIndexOf(c) + 1);
    }

    public boolean HasSubCategory() {
        return !this.midName.equals("java.io.Serializable") && !this.midName.equals("java.lang.Cloneable") && !this.midName.equals("java.rmi.Remote") && !this.midName.equals("java.util.EventListener") || this.GetEnumeration().hasMoreElements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.longName;
    }

    public Enumeration GetEnumeration() {
        InfoPaneVector infoPaneVector = new InfoPaneVector();
        try {
            Class<?> clazz = Class.forName(this.midName);
            if (clazz != null) {
                this.AddModifier(clazz, infoPaneVector);
                this.AddConstructors(clazz, infoPaneVector);
                this.AddFields(clazz, infoPaneVector);
                this.AddInterfaces(clazz, infoPaneVector);
                this.AddMethods(clazz, infoPaneVector);
                this.AddSuperclass(clazz, infoPaneVector);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("InfoPaneClassItem.GetEnumeration: " + classNotFoundException + " -- could not load " + this.longName);
            classNotFoundException.printStackTrace();
        }
        catch (LinkageError linkageError) {
            System.out.println("InfoClassItem.GetEnumeration:  " + linkageError + " -- could not load " + this.longName);
            linkageError.printStackTrace();
        }
        catch (InfoPaneException infoPaneException) {
            System.out.println("InfoPaneClassItem.GetEnumeration: " + infoPaneException + " -- could not load " + this.longName);
            infoPaneException.printStackTrace();
        }
        return infoPaneVector.elements();
    }

    void AddModifier(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        InfoPaneClassSubItem infoPaneClassSubItem;
        if (!clazz.isInterface() && (infoPaneClassSubItem = new InfoPaneClassSubItem(clazz.getModifiers())).HasSubCategory()) {
            infoPaneVector.Insert(infoPaneClassSubItem);
        }
    }

    void AddFields(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        Field[] fieldArray = clazz.getFields();
        if (fieldArray != null) {
            InfoPaneClassSubItem infoPaneClassSubItem = new InfoPaneClassSubItem("InfoPane_Constants");
            InfoPaneClassSubItem infoPaneClassSubItem2 = new InfoPaneClassSubItem("InfoPane_Fields");
            InfoPaneClassSubItem.AddFields(infoPaneClassSubItem, infoPaneClassSubItem2, fieldArray);
            if (infoPaneClassSubItem.HasSubCategory()) {
                infoPaneVector.Insert(infoPaneClassSubItem);
            }
            if (infoPaneClassSubItem2.HasSubCategory()) {
                infoPaneVector.Insert(infoPaneClassSubItem2);
            }
        }
    }

    void AddInterfaces(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        InfoPaneClassSubItem infoPaneClassSubItem;
        Class[] classArray = clazz.getInterfaces();
        if (classArray != null && (infoPaneClassSubItem = new InfoPaneClassSubItem(classArray, clazz.isInterface())).HasSubCategory()) {
            infoPaneVector.Insert(infoPaneClassSubItem);
        }
    }

    void AddConstructors(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        InfoPaneClassSubItem infoPaneClassSubItem;
        Constructor[] constructorArray = clazz.getConstructors();
        if (constructorArray != null && (infoPaneClassSubItem = new InfoPaneClassSubItem(constructorArray)).HasSubCategory()) {
            infoPaneVector.Insert(infoPaneClassSubItem);
        }
    }

    void AddMethods(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        Method[] methodArray = clazz.getMethods();
        if (methodArray != null) {
            InfoPaneClassSubItem infoPaneClassSubItem = new InfoPaneClassSubItem("InfoPane_Methods");
            InfoPaneClassSubItem infoPaneClassSubItem2 = new InfoPaneClassSubItem("InfoPane_Static_Methods");
            InfoPaneClassSubItem.AddMethods(infoPaneClassSubItem, infoPaneClassSubItem2, methodArray, clazz.isInterface(), this.midName);
            if (infoPaneClassSubItem.HasSubCategory()) {
                infoPaneVector.Insert(infoPaneClassSubItem);
            }
            if (infoPaneClassSubItem2.HasSubCategory()) {
                infoPaneVector.Insert(infoPaneClassSubItem2);
            }
        }
    }

    void AddSuperclass(Class clazz, InfoPaneVector infoPaneVector) throws InfoPaneException {
        InfoPaneClassSubItem infoPaneClassSubItem;
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (infoPaneClassSubItem = new InfoPaneClassSubItem(clazz2)).HasSubCategory()) {
            infoPaneVector.Insert(infoPaneClassSubItem);
        }
    }

    public boolean HasLongName() {
        return true;
    }

    public boolean CanPaste() {
        return true;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

