/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import lotus.domino.JavaString;
import lotus.notes.internal.InfoPaneConstructorItem;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneFieldItem;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneMemberItem;
import lotus.notes.internal.InfoPaneMethodItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneClassSubItem
implements InfoPaneItem {
    private InfoPaneVector vector;
    private String name;

    InfoPaneClassSubItem(String string) {
        this.name = JavaString.getString(string);
        this.vector = new InfoPaneVector();
    }

    InfoPaneClassSubItem(int n) throws InfoPaneException {
        this("InfoPane_Class_Modifier");
        if (Modifier.isAbstract(n)) {
            this.AddMember("abstract");
            return;
        }
        if (Modifier.isFinal(n)) {
            this.AddMember("final");
        }
    }

    InfoPaneClassSubItem(Constructor[] constructorArray) throws InfoPaneException {
        this("InfoPane_Constructors");
        try {
            int n = 0;
            while (constructorArray[n] != null) {
                Constructor constructor = constructorArray[n];
                if (Modifier.isPublic(constructor.getModifiers())) {
                    this.AddConstructor(constructor);
                }
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    InfoPaneClassSubItem(Class[] classArray, boolean bl) throws InfoPaneException {
        this(bl ? "InfoPane_Extends_Interfaces" : "InfoPane_Implements_Interfaces");
        try {
            int n = 0;
            while (classArray[n] != null) {
                Class clazz = classArray[n];
                if (Modifier.isPublic(clazz.getModifiers())) {
                    this.AddMember(clazz.getName(), clazz.toString());
                }
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    InfoPaneClassSubItem(Class clazz) throws InfoPaneException {
        this("InfoPane_Superclass");
        if (Modifier.isPublic(clazz.getModifiers())) {
            this.AddMember(clazz.getName(), clazz.toString());
        }
    }

    static void AddFields(InfoPaneClassSubItem infoPaneClassSubItem, InfoPaneClassSubItem infoPaneClassSubItem2, Field[] fieldArray) throws InfoPaneException {
        try {
            int n = 0;
            while (fieldArray[n] != null) {
                Field field = fieldArray[n];
                int n2 = field.getModifiers();
                if (Modifier.isPublic(n2)) {
                    if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                        infoPaneClassSubItem.AddField(field);
                    } else {
                        infoPaneClassSubItem2.AddField(field);
                    }
                }
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    static void AddMethods(InfoPaneClassSubItem infoPaneClassSubItem, InfoPaneClassSubItem infoPaneClassSubItem2, Method[] methodArray, boolean bl, String string) throws InfoPaneException {
        try {
            int n = 0;
            while (methodArray[n] != null) {
                Method method = methodArray[n];
                int n2 = method.getModifiers();
                String string2 = method.getName();
                if (!(!Modifier.isPublic(n2) || string.equals("lotus.domino.Database") && string2.equals("getURLHeaderInfo") || string.equals("lotus.domino.Form") && string2.equals("getFieldType"))) {
                    if (Modifier.isStatic(n2)) {
                        infoPaneClassSubItem2.AddMethod(method, bl);
                    } else {
                        infoPaneClassSubItem.AddMethod(method, bl);
                    }
                }
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    InfoPaneConstructorItem AddConstructor(Constructor constructor) throws InfoPaneException {
        return (InfoPaneConstructorItem)this.vector.Insert(new InfoPaneConstructorItem(constructor));
    }

    InfoPaneFieldItem AddField(Field field) throws InfoPaneException {
        return (InfoPaneFieldItem)this.vector.Insert(new InfoPaneFieldItem(field), true);
    }

    InfoPaneMethodItem AddMethod(Method method, boolean bl) throws InfoPaneException {
        return (InfoPaneMethodItem)this.vector.Insert(new InfoPaneMethodItem(method, bl), true);
    }

    InfoPaneMemberItem AddMember(String string) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string));
    }

    InfoPaneMemberItem AddMember(String string, String string2) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string, string2));
    }

    InfoPaneMemberItem FindMember(String string) {
        return (InfoPaneMemberItem)this.vector.Find(string);
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.name;
    }

    public boolean HasLongName() {
        return false;
    }

    public boolean CanPaste() {
        return false;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

