/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneFieldSubItem;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneFieldItem
implements InfoPaneItem {
    private String name;
    private String longName;
    private InfoPaneVector vector;

    InfoPaneFieldItem(Field field) {
        this.name = field.getName();
        Class<?> clazz = field.getDeclaringClass();
        boolean bl = Modifier.isPublic(clazz.getModifiers());
        this.longName = bl ? field.toString() : this.name;
        this.vector = new InfoPaneVector();
        try {
            this.AddModifiers(field);
            this.AddType(field);
            if (bl) {
                this.AddValue(field);
                return;
            }
        }
        catch (InfoPaneException infoPaneException) {
            System.out.println("InfoPaneFieldItem constructor: " + infoPaneException);
        }
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    void AddModifiers(Field field) throws InfoPaneException {
        InfoPaneFieldSubItem infoPaneFieldSubItem = new InfoPaneFieldSubItem(field.getModifiers());
        if (infoPaneFieldSubItem.HasSubCategory()) {
            this.vector.Insert(infoPaneFieldSubItem);
        }
    }

    void AddType(Field field) throws InfoPaneException {
        InfoPaneFieldSubItem infoPaneFieldSubItem = new InfoPaneFieldSubItem(field.getType());
        this.vector.Insert(infoPaneFieldSubItem);
    }

    void AddValue(Field field) throws InfoPaneException {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                InfoPaneFieldSubItem infoPaneFieldSubItem = new InfoPaneFieldSubItem(field.get(null));
                this.vector.Insert(infoPaneFieldSubItem);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
        }
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.longName;
    }

    public boolean HasLongName() {
        return this.longName != null && this.name != null && this.longName.length() > this.name.length();
    }

    public boolean CanPaste() {
        return true;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

